/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.DynamicBundle;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.externalSystem.service.ui.ExternalSystemJdkComboBox;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.updateSettings.impl.LabelTextReplacingUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.projectImport.ProjectFormatPanel;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.actions.LookForNestedToggleAction;

public class MavenImportingSettingsForm {
    private JPanel myPanel;
    private JCheckBox mySearchRecursivelyCheckBox;
    private JLabel myProjectFormatLabel;
    private JComboBox myProjectFormatComboBox;
    private ProjectFormatPanel myProjectFormatPanel;
    private JCheckBox mySeparateModulesDirCheckBox;
    private TextFieldWithBrowseButton mySeparateModulesDirChooser;
    private JCheckBox myCreateModulesForAggregators;
    private JCheckBox myCreateGroupsCheckBox;
    private JComboBox<String> myUpdateFoldersOnImportPhaseComboBox;
    private JCheckBox myKeepSourceFoldersCheckBox;
    private JCheckBox myUseMavenOutputCheckBox;
    private JCheckBox myDownloadSourcesCheckBox;
    private JCheckBox myDownloadDocsCheckBox;
    private JCheckBox myDownloadAnnotationsCheckBox;
    private JPanel myAdditionalSettingsPanel;
    private JComboBox<MavenImportingSettings.GeneratedSourcesFolder> myGeneratedSourcesComboBox;
    private JCheckBox myExcludeTargetFolderCheckBox;
    private JTextField myDependencyTypes;
    private JCheckBox myStoreProjectFilesExternally;
    private JBTextField myVMOptionsForImporter;
    private ExternalSystemJdkComboBox myJdkForImporterComboBox;
    private JCheckBox myAutoDetectCompilerCheckBox;
    private JBCheckBox myJBCheckBox1;

    public MavenImportingSettingsForm(boolean isDefaultProject) {
        this.$$$setupUI$$$();
        this.mySearchRecursivelyCheckBox.setVisible(isDefaultProject);
        this.myProjectFormatLabel.setVisible(false);
        this.myProjectFormatComboBox.setVisible(false);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MavenImportingSettingsForm.this.updateControls();
            }
        };
        this.mySeparateModulesDirCheckBox.addActionListener(listener);
        this.mySeparateModulesDirChooser.addBrowseFolderListener(MavenProjectBundle.message("maven.import.title.module.dir", new Object[0]), "", null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myUpdateFoldersOnImportPhaseComboBox.setModel(new DefaultComboBoxModel<String>(MavenImportingSettings.UPDATE_FOLDERS_PHASES));
        this.myGeneratedSourcesComboBox.setModel((ComboBoxModel<MavenImportingSettings.GeneratedSourcesFolder>)new EnumComboBoxModel(MavenImportingSettings.GeneratedSourcesFolder.class));
        this.myGeneratedSourcesComboBox.setRenderer((ListCellRenderer<MavenImportingSettings.GeneratedSourcesFolder>)SimpleListCellRenderer.create((String)"", value -> value.title));
        LabelTextReplacingUtil.replaceText((JComponent)this.myPanel);
        this.myAutoDetectCompilerCheckBox.setVisible(Registry.is((String)"maven.import.compiler.arguments", (boolean)true));
        this.myJdkForImporterComboBox.setHighlightInternalJdk(false);
    }

    private void createUIComponents() {
        this.myProjectFormatPanel = new ProjectFormatPanel();
        this.myProjectFormatComboBox = this.myProjectFormatPanel.getStorageFormatComboBox();
    }

    private void updateControls() {
        boolean useSeparateDir = this.mySeparateModulesDirCheckBox.isSelected();
        this.mySeparateModulesDirChooser.setEnabled(useSeparateDir);
        if (useSeparateDir && StringUtil.isEmptyOrSpaces((String)this.mySeparateModulesDirChooser.getText())) {
            this.mySeparateModulesDirChooser.setText(FileUtil.toSystemDependentName((String)this.getDefaultModuleDir()));
        }
    }

    public String getDefaultModuleDir() {
        return "";
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public void getData(@NotNull MavenImportingSettings data) {
        if (data == null) {
            MavenImportingSettingsForm.$$$reportNull$$$0(0);
        }
        data.setLookForNested(this.mySearchRecursivelyCheckBox.isSelected());
        LookForNestedToggleAction.setSelected(this.mySearchRecursivelyCheckBox.isSelected());
        data.setDedicatedModuleDir(this.mySeparateModulesDirCheckBox.isSelected() ? this.mySeparateModulesDirChooser.getText() : "");
        data.setCreateModulesForAggregators(this.myCreateModulesForAggregators.isSelected());
        data.setCreateModuleGroups(this.myCreateGroupsCheckBox.isSelected());
        data.setKeepSourceFolders(this.myKeepSourceFoldersCheckBox.isSelected());
        data.setExcludeTargetFolder(this.myExcludeTargetFolderCheckBox.isSelected());
        data.setUseMavenOutput(this.myUseMavenOutputCheckBox.isSelected());
        data.setUpdateFoldersOnImportPhase((String)this.myUpdateFoldersOnImportPhaseComboBox.getSelectedItem());
        data.setGeneratedSourcesFolder((MavenImportingSettings.GeneratedSourcesFolder)((Object)this.myGeneratedSourcesComboBox.getSelectedItem()));
        data.setDownloadSourcesAutomatically(this.myDownloadSourcesCheckBox.isSelected());
        data.setDownloadDocsAutomatically(this.myDownloadDocsCheckBox.isSelected());
        data.setDownloadAnnotationsAutomatically(this.myDownloadAnnotationsCheckBox.isSelected());
        data.setAutoDetectCompiler(this.myAutoDetectCompilerCheckBox.isSelected());
        data.setVmOptionsForImporter(this.myVMOptionsForImporter.getText());
        data.setJdkForImporter(this.myJdkForImporterComboBox.getSelectedValue());
        data.setDependencyTypes(this.myDependencyTypes.getText());
    }

    public void setData(MavenImportingSettings data, @Nullable Project project) {
        this.mySearchRecursivelyCheckBox.setSelected(LookForNestedToggleAction.isSelected());
        this.mySeparateModulesDirCheckBox.setSelected(!StringUtil.isEmptyOrSpaces((String)data.getDedicatedModuleDir()));
        this.mySeparateModulesDirChooser.setText(data.getDedicatedModuleDir());
        this.myCreateModulesForAggregators.setSelected(data.isCreateModulesForAggregators());
        this.myCreateGroupsCheckBox.setSelected(data.isCreateModuleGroups());
        this.myKeepSourceFoldersCheckBox.setSelected(data.isKeepSourceFolders());
        if (project == null) {
            this.myStoreProjectFilesExternally.setVisible(false);
        } else {
            this.myStoreProjectFilesExternally.setVisible(true);
            this.myStoreProjectFilesExternally.setSelected(MavenImportingSettingsForm.isCurrentlyStoredExternally(project));
        }
        this.myExcludeTargetFolderCheckBox.setSelected(data.isExcludeTargetFolder());
        this.myUseMavenOutputCheckBox.setSelected(data.isUseMavenOutput());
        this.myUpdateFoldersOnImportPhaseComboBox.setSelectedItem(data.getUpdateFoldersOnImportPhase());
        this.myGeneratedSourcesComboBox.setSelectedItem((Object)data.getGeneratedSourcesFolder());
        this.myDownloadSourcesCheckBox.setSelected(data.isDownloadSourcesAutomatically());
        this.myDownloadDocsCheckBox.setSelected(data.isDownloadDocsAutomatically());
        this.myDownloadAnnotationsCheckBox.setSelected(data.isDownloadAnnotationsAutomatically());
        this.myAutoDetectCompilerCheckBox.setSelected(data.isAutoDetectCompiler());
        this.myDependencyTypes.setText(data.getDependencyTypes());
        this.myVMOptionsForImporter.setText(data.getVmOptionsForImporter());
        this.myJdkForImporterComboBox.refreshData(data.getJdkForImporter());
        this.updateControls();
    }

    private static boolean isCurrentlyStoredExternally(@Nullable Project project) {
        return project == null || ExternalStorageConfigurationManager.getInstance((Project)project).isEnabled();
    }

    public boolean isModified(@NotNull MavenImportingSettings settings, @Nullable Project project) {
        if (settings == null) {
            MavenImportingSettingsForm.$$$reportNull$$$0(1);
        }
        if (project != null && MavenImportingSettingsForm.isCurrentlyStoredExternally(project) != this.isStoreExternally()) {
            return true;
        }
        MavenImportingSettings formData = new MavenImportingSettings();
        this.getData(formData);
        return !formData.equals(settings);
    }

    boolean isStoreExternally() {
        return !this.myStoreProjectFilesExternally.isVisible() || this.myStoreProjectFilesExternally.isSelected();
    }

    public void updateData(WizardContext wizardContext) {
        this.myProjectFormatPanel.updateData(wizardContext);
    }

    public JPanel getAdditionalSettingsPanel() {
        return this.myAdditionalSettingsPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        ExternalSystemJdkComboBox externalSystemJdkComboBox;
        JBTextField jBTextField;
        JTextField jTextField;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox4;
        JLabel jLabel;
        JPanel jPanel;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JCheckBox jCheckBox10;
        JCheckBox jCheckBox11;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(23, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCreateModulesForAggregators = jCheckBox11 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox11, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.create.modules.for.aggregator"));
        jPanel2.add((Component)jCheckBox11, new GridConstraints(5, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myCreateGroupsCheckBox = jCheckBox10 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox10, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.create.module.groups"));
        jPanel2.add((Component)jCheckBox10, new GridConstraints(6, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.mySearchRecursivelyCheckBox = jCheckBox9 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox9, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.search.recursively"));
        jPanel2.add((Component)jCheckBox9, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myUseMavenOutputCheckBox = jCheckBox8 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox8, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.use.output.directories"));
        jCheckBox8.setToolTipText(ResourceBundle.getBundle("messages/MavenConfigurableBundle").getString("maven.settings.importing.use.output.directories.tooltip"));
        jPanel2.add((Component)jCheckBox8, new GridConstraints(9, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.phase.for.source.updates.notes"));
        jPanel2.add((Component)jBLabel, new GridConstraints(13, 0, 1, 3, 0, 1, 3, 0, null, null, null, 3));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(10, 0, 0, 0), -1, -1, false, false));
        jPanel3.setFocusable(true);
        jPanel2.add((Component)jPanel3, new GridConstraints(15, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.auto.download"));
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDownloadSourcesCheckBox = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.auto.download.sources"));
        jPanel3.add((Component)jCheckBox7, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDownloadDocsCheckBox = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.auto.download.documentation"));
        jPanel3.add((Component)jCheckBox6, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        JBCheckBox jBCheckBox = new JBCheckBox();
        this.myDownloadAnnotationsCheckBox = jBCheckBox;
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.auto.download.annotations"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 3, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myKeepSourceFoldersCheckBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.keep.folders.on.reimport"));
        jPanel2.add((Component)jCheckBox5, new GridConstraints(7, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myAdditionalSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(15, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(21, 0, 1, 3, 8, 2, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(15, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myProjectFormatLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.project.format"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = this.myProjectFormatComboBox;
        jPanel4.add((Component)jComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 10, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.mySeparateModulesDirCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.project.files.keep.in"));
        jCheckBox4.setToolTipText(ResourceBundle.getBundle("messages/MavenConfigurableBundle").getString("maven.settings.importing.project.files.keep.in.tooltip"));
        jPanel5.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySeparateModulesDirChooser = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myStoreProjectFilesExternally = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.project.store.externally"));
        jPanel5.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel2.add((Component)spacer4, new GridConstraints(22, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(12, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.myUpdateFoldersOnImportPhaseComboBox = jComboBox2;
        jPanel6.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.phase.for.source.updates"));
        jPanel6.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel6.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel2.add((Component)spacer6, new GridConstraints(11, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        Spacer spacer7 = new Spacer();
        jPanel2.add((Component)spacer7, new GridConstraints(1, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(10, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.generated.source.folders"));
        jPanel7.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel7.add((Component)spacer8, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JComboBox jComboBox3 = new JComboBox();
        this.myGeneratedSourcesComboBox = jComboBox3;
        jPanel7.add(jComboBox3, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myExcludeTargetFolderCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.project.exclude.build.directory"));
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("messages/MavenConfigurableBundle").getString("maven.settings.importing.project.exclude.build.directory.tooltip"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(8, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.dependency.type"));
        jLabel5.setToolTipText(ResourceBundle.getBundle("messages/MavenConfigurableBundle").getString("maven.settings.importing.dependency.type.tooltip"));
        jPanel2.add((Component)jLabel5, new GridConstraints(16, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDependencyTypes = jTextField = new JTextField();
        jTextField.setColumns(0);
        jTextField.setToolTipText(ResourceBundle.getBundle("messages/MavenConfigurableBundle").getString("maven.settings.importing.dependency.type.tooltip"));
        jPanel2.add((Component)jTextField, new GridConstraints(16, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel2.setHorizontalTextPosition(4);
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.dependency.type.tooltip"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(17, 1, 1, 2, 9, 0, 0, 0, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel2.add((Component)spacer9, new GridConstraints(18, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        Spacer spacer10 = new Spacer();
        jPanel2.add((Component)spacer10, new GridConstraints(14, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.vm.options"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(19, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVMOptionsForImporter = jBTextField = new JBTextField();
        jPanel2.add((Component)jBTextField, new GridConstraints(19, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.jdk"));
        jPanel2.add((Component)jBLabel4, new GridConstraints(20, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myJdkForImporterComboBox = externalSystemJdkComboBox = new ExternalSystemJdkComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        externalSystemJdkComboBox.setModel(defaultComboBoxModel);
        jPanel2.add((Component)externalSystemJdkComboBox, new GridConstraints(20, 1, 1, 2, 0, 1, 2, 2, null, null, null));
        this.myAutoDetectCompilerCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.detect.compiler"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
        jLabel3.setLabelFor(jComboBox2);
        jLabel5.setLabelFor(jTextField);
        jBLabel2.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/project/MavenImportingSettingsForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

