/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemKeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.KeymapGroupFactory;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.keymap.impl.ui.Hyperlink;
import com.intellij.openapi.keymap.impl.ui.KeymapListener;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import icons.ExternalSystemIcons;
import icons.OpenapiIcons;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.model.MavenConstants;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.navigator.MavenProjectsStructure;
import org.jetbrains.idea.maven.navigator.SelectMavenGoalDialog;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.tasks.MavenShortcutsManager;
import org.jetbrains.idea.maven.tasks.TasksBundle;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenPluginInfo;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public final class MavenKeymapExtension
implements ExternalSystemKeymapExtension.ActionsProvider {
    public KeymapGroup createGroup(Condition<? super AnAction> condition, final Project project) {
        KeymapGroup result = KeymapGroupFactory.getInstance().createGroup(TasksBundle.message("maven.tasks.action.group.name", new Object[0]), OpenapiIcons.RepositoryLibraryLogo);
        if (project == null) {
            return result;
        }
        Comparator projectComparator = (o1, o2) -> o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
        TreeMap<MavenProject, TreeSet<Pair>> projectToActionsMapping = new TreeMap<MavenProject, TreeSet<Pair>>(projectComparator);
        ActionManager actionManager = ActionManager.getInstance();
        for (String eachId : actionManager.getActionIds(MavenKeymapExtension.getActionPrefix(project, null))) {
            AnAction eachAction = actionManager.getAction(eachId);
            if (!(eachAction instanceof MavenGoalAction) || condition != null && !condition.value((Object)actionManager.getActionOrStub(eachId))) continue;
            MavenGoalAction mavenAction = (MavenGoalAction)eachAction;
            MavenProject mavenProject = mavenAction.getMavenProject();
            TreeSet<Pair> actions = (TreeSet<Pair>)projectToActionsMapping.get(mavenProject);
            if (actions == null) {
                List<String> projectGoals = MavenKeymapExtension.collectGoals(mavenProject);
                actions = new TreeSet<Pair>((o1, o2) -> {
                    int index2;
                    String goal1 = (String)o1.getFirst();
                    String goal2 = (String)o2.getFirst();
                    int index1 = projectGoals.indexOf(goal1);
                    if (index1 == (index2 = projectGoals.indexOf(goal2))) {
                        return goal1.compareToIgnoreCase(goal2);
                    }
                    return index1 < index2 ? -1 : 1;
                });
                projectToActionsMapping.put(mavenProject, actions);
            }
            actions.add(Pair.create((Object)mavenAction.getGoal(), (Object)eachId));
        }
        for (Map.Entry entry : projectToActionsMapping.entrySet()) {
            Set goalsToActionIds = (Set)entry.getValue();
            for (Pair eachGoalToActionId : goalsToActionIds) {
                result.addActionId((String)eachGoalToActionId.getSecond());
            }
        }
        Icon icon = AllIcons.General.Add;
        ((Group)result).addHyperlink(new Hyperlink(icon, "Choose a phase/goal to assign a shortcut"){

            public void onClick(MouseEvent e) {
                SelectMavenGoalDialog dialog = new SelectMavenGoalDialog(project);
                if (dialog.showAndGet() && dialog.getResult() != null) {
                    KeymapPanel keymapPanel;
                    MavenProjectsStructure.GoalNode goalNode = dialog.getResult();
                    String goal = goalNode.getGoal();
                    String actionId = MavenShortcutsManager.getInstance(project).getActionId(goalNode.getProjectPath(), goal);
                    MavenKeymapExtension.getOrRegisterAction(goalNode.getMavenProject(), actionId, goal);
                    ((KeymapListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(KeymapListener.CHANGE_TOPIC)).processCurrentKeymapChanged();
                    Settings allSettings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext(e.getComponent()));
                    KeymapPanel keymapPanel2 = keymapPanel = allSettings != null ? (KeymapPanel)allSettings.find(KeymapPanel.class) : null;
                    if (keymapPanel != null) {
                        keymapPanel.showOption("");
                        keymapPanel.selectAction(actionId);
                    }
                }
            }
        });
        return result;
    }

    static void updateActions(Project project, List<? extends MavenProject> mavenProjects) {
        MavenKeymapExtension.clearActions(project, mavenProjects);
        MavenKeymapExtension.createActions(project, mavenProjects);
    }

    public static MavenAction getOrRegisterAction(MavenProject mavenProject, String actionId, String goal) {
        MavenGoalAction mavenGoalAction = new MavenGoalAction(mavenProject, goal);
        ActionManager manager = ActionManager.getInstance();
        AnAction anAction = manager.getAction(actionId);
        if (anAction instanceof MavenGoalAction) {
            return (MavenGoalAction)anAction;
        }
        manager.replaceAction(actionId, (AnAction)mavenGoalAction);
        return mavenGoalAction;
    }

    private static void createActions(Project project, List<? extends MavenProject> mavenProjects) {
        ActionManager actionManager = ActionManager.getInstance();
        MavenShortcutsManager shortcutsManager = MavenShortcutsManager.getInstance(project);
        for (MavenProject mavenProject : mavenProjects) {
            String actionIdPrefix = MavenKeymapExtension.getActionPrefix(project, mavenProject);
            for (MavenGoalAction eachAction : MavenKeymapExtension.collectActions(mavenProject)) {
                String id = actionIdPrefix + eachAction.getGoal();
                if (shortcutsManager.hasShortcuts(mavenProject, eachAction.getGoal())) {
                    actionManager.replaceAction(id, (AnAction)eachAction);
                    continue;
                }
                actionManager.unregisterAction(id);
            }
        }
    }

    private static List<MavenGoalAction> collectActions(MavenProject mavenProject) {
        ArrayList<MavenGoalAction> result = new ArrayList<MavenGoalAction>();
        for (String eachGoal : MavenKeymapExtension.collectGoals(mavenProject)) {
            result.add(new MavenGoalAction(mavenProject, eachGoal));
        }
        return result;
    }

    public static void clearActions(Project project) {
        ActionManager manager = ActionManager.getInstance();
        for (String each : manager.getActionIds(MavenKeymapExtension.getActionPrefix(project, null))) {
            manager.unregisterAction(each);
        }
    }

    static void clearActions(Project project, List<? extends MavenProject> mavenProjects) {
        ActionManager manager = ActionManager.getInstance();
        for (MavenProject mavenProject : mavenProjects) {
            for (String eachAction : manager.getActionIds(MavenKeymapExtension.getActionPrefix(project, mavenProject))) {
                manager.unregisterAction(eachAction);
            }
        }
    }

    private static List<String> collectGoals(MavenProject project) {
        LinkedHashSet result = new LinkedHashSet(MavenConstants.PHASES);
        for (MavenPlugin each : project.getDeclaredPlugins()) {
            MavenKeymapExtension.collectGoals(project.getLocalRepository(), each, result);
        }
        return new ArrayList<String>(result);
    }

    private static void collectGoals(File repository, MavenPlugin plugin, Set<? super String> list) {
        MavenPluginInfo info = MavenArtifactUtil.readPluginInfo(repository, plugin.getMavenId());
        if (info == null) {
            return;
        }
        for (MavenPluginInfo.Mojo m : info.getMojos()) {
            list.add(m.getQualifiedGoal());
        }
    }

    public static String getActionPrefix(Project project, MavenProject mavenProject) {
        String pomPath = mavenProject == null ? null : mavenProject.getPath();
        return MavenShortcutsManager.getInstance(project).getActionId(pomPath, null);
    }

    private static class MavenGoalAction
    extends MavenAction {
        private final MavenProject myMavenProject;
        private final String myGoal;

        MavenGoalAction(MavenProject mavenProject, String goal) {
            this.myMavenProject = mavenProject;
            this.myGoal = goal;
            Presentation template = this.getTemplatePresentation();
            template.setText(goal + " (" + mavenProject.getMavenId() + ")", false);
            template.setIcon(ExternalSystemIcons.Task);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataContext context;
            Project project;
            if (e == null) {
                MavenGoalAction.$$$reportNull$$$0(0);
            }
            if ((project = MavenActionUtil.getProject(context = e.getDataContext())) == null) {
                return;
            }
            MavenProjectsManager projectsManager = MavenActionUtil.getProjectsManager(context);
            if (projectsManager == null) {
                return;
            }
            MavenExplicitProfiles explicitProfiles = projectsManager.getExplicitProfiles();
            MavenRunnerParameters params = new MavenRunnerParameters(true, this.myMavenProject.getDirectory(), this.myMavenProject.getFile().getName(), Collections.singletonList(this.myGoal), explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles());
            MavenRunConfigurationType.runConfiguration(project, params, null);
        }

        public MavenProject getMavenProject() {
            return this.myMavenProject;
        }

        public String getGoal() {
            return this.myGoal;
        }

        public String toString() {
            return this.myMavenProject + ":" + this.myGoal;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/maven/tasks/MavenKeymapExtension$MavenGoalAction", "actionPerformed"));
        }
    }
}

