/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.languagetool.analysis.AnalyzedSentence;
import org.languagetool.analysis.AnalyzedToken;
import org.languagetool.analysis.AnalyzedTokenReadings;
import org.languagetool.language.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public abstract class AbstractWordCoherencyRule
extends TextLevelRule {
    protected abstract Map<String, Set<String>> getWordMap();

    protected abstract String getMessage(String var1, String var2);

    public AbstractWordCoherencyRule(ResourceBundle messages, Language language) throws IOException {
        super(messages, language);
        super.setCategory(Categories.MISC.getCategory(messages, language));
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        HashMap<String, RuleMatch> shouldNotAppearWord = new HashMap<String, RuleMatch>();
        int pos = 0;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens;
            block1: for (AnalyzedTokenReadings tmpToken : tokens = sentence.getTokensWithoutWhitespace()) {
                String token = tmpToken.getToken();
                List<AnalyzedToken> readings = tmpToken.getReadings();
                if (readings.isEmpty()) continue;
                Set baseforms = readings.stream().map(AnalyzedToken::getLemma).collect(Collectors.toSet());
                for (String baseform : baseforms) {
                    if (baseform != null) {
                        token = baseform;
                    }
                    if (shouldNotAppearWord.containsKey(token)) {
                        RuleMatch otherMatch = (RuleMatch)shouldNotAppearWord.get(token);
                        String otherSpelling = otherMatch.getMessage();
                        String msg = this.getMessage(token, otherSpelling);
                        RuleMatch ruleMatch = new RuleMatch(this, sentence, pos + tmpToken.getStartPos(), pos + tmpToken.getEndPos(), msg);
                        ruleMatch.setSuggestedReplacement(otherSpelling);
                        ruleMatches.add(ruleMatch);
                        continue block1;
                    }
                    if (!this.getWordMap().containsKey(token)) continue;
                    Set<String> shouldNotAppearSet = this.getWordMap().get(token);
                    for (String shouldNotAppear : shouldNotAppearSet) {
                        RuleMatch potentialRuleMatch = new RuleMatch(this, sentence, pos + tmpToken.getStartPos(), pos + tmpToken.getEndPos(), token);
                        shouldNotAppearWord.put(shouldNotAppear, potentialRuleMatch);
                    }
                }
            }
            pos += sentence.getText().length();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public int minToCheckParagraph() {
        return -1;
    }
}

