/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.analysis.AnalyzedSentence;
import org.languagetool.analysis.AnalyzedTokenReadings;
import org.languagetool.language.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public class ParagraphRepeatBeginningRule
extends TextLevelRule {
    private static final Pattern QUOTES_REGEX = Pattern.compile("[\u2019'\"\u201e\u201c\u201d\u00bb\u00ab\u201a\u2018\u203a\u2039()\\[\\]]");

    public ParagraphRepeatBeginningRule(ResourceBundle messages, Language lang) {
        super(messages, lang);
        super.setCategory(Categories.STYLE.getCategory(messages, lang));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.setDefaultOff();
    }

    @Override
    public String getId() {
        return "PARAGRAPH_REPEAT_BEGINNING_RULE";
    }

    @Override
    public String getDescription() {
        return this.messages.getString("repetition_paragraph_beginning_desc");
    }

    public boolean isArticle(AnalyzedTokenReadings token) {
        return token.hasPosTagStartingWith("DT");
    }

    private int numCharEqualBeginning(AnalyzedTokenReadings[] lastTokens, AnalyzedTokenReadings[] nextTokens) throws IOException {
        if (lastTokens.length < 2 || nextTokens.length < 2 || lastTokens[1].isWhitespace() || nextTokens[1].isWhitespace()) {
            return 0;
        }
        int nToken = 1;
        String lastToken = lastTokens[nToken].getToken();
        String nextToken = nextTokens[nToken].getToken();
        if (QUOTES_REGEX.matcher(lastToken).matches() && lastToken.equals(nextToken)) {
            if (lastTokens.length <= nToken + 1 || nextTokens.length <= nToken + 1) {
                return 0;
            }
            lastToken = lastTokens[++nToken].getToken();
            nextToken = nextTokens[nToken].getToken();
        }
        if (!Character.isLetter(lastToken.charAt(0))) {
            return 0;
        }
        if (lastTokens.length > nToken + 1 && this.isArticle(lastTokens[nToken]) && lastToken.equals(nextToken)) {
            if (lastTokens.length <= nToken + 1 || nextTokens.length <= nToken + 1) {
                return 0;
            }
            lastToken = lastTokens[++nToken].getToken();
            nextToken = nextTokens[nToken].getToken();
        }
        if (!Character.isLetter(lastToken.charAt(0))) {
            return 0;
        }
        if (lastToken.equals(nextToken)) {
            return lastTokens[nToken].getEndPos();
        }
        return 0;
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        if (sentences.size() < 1) {
            return this.toRuleMatchArray(ruleMatches);
        }
        int nextPos = 0;
        int lastPos = 0;
        int endPos = 0;
        AnalyzedSentence lastSentence = sentences.get(0);
        AnalyzedTokenReadings[] lastTokens = lastSentence.getTokensWithoutWhitespace();
        AnalyzedSentence nextSentence = null;
        AnalyzedTokenReadings[] nextTokens = null;
        for (int n = 0; n < sentences.size() - 1; ++n) {
            nextPos += sentences.get(n).getText().length();
            if (!sentences.get(n).hasParagraphEndMark(this.language)) continue;
            nextSentence = sentences.get(n + 1);
            nextTokens = nextSentence.getTokensWithoutWhitespace();
            endPos = this.numCharEqualBeginning(lastTokens, nextTokens);
            if (endPos > 0) {
                int startPos = lastPos + lastTokens[1].getStartPos();
                String msg = this.messages.getString("repetition_paragraph_beginning_last_msg");
                RuleMatch ruleMatch = new RuleMatch(this, lastSentence, startPos, lastPos + endPos, msg);
                ruleMatches.add(ruleMatch);
                startPos = nextPos + nextTokens[1].getStartPos();
                msg = this.messages.getString("repetition_paragraph_beginning_last_msg");
                ruleMatch = new RuleMatch(this, nextSentence, startPos, nextPos + endPos, msg);
                ruleMatches.add(ruleMatch);
            }
            lastSentence = nextSentence;
            lastTokens = nextTokens;
            lastPos = nextPos;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public int minToCheckParagraph() {
        return 1;
    }
}

