/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.analysis.AnalyzedSentence;
import org.languagetool.analysis.AnalyzedTokenReadings;
import org.languagetool.language.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public class WhiteSpaceBeforeParagraphEnd
extends TextLevelRule {
    public WhiteSpaceBeforeParagraphEnd(ResourceBundle messages, Language lang, boolean defaultActive) {
        super(messages, lang);
        super.setCategory(Categories.STYLE.getCategory(messages, lang));
        if (!defaultActive) {
            this.setDefaultOff();
        }
        this.setOfficeDefaultOn();
        this.setLocQualityIssueType(ITSIssueType.Style);
    }

    public WhiteSpaceBeforeParagraphEnd(ResourceBundle messages, Language lang) {
        this(messages, lang, false);
    }

    @Override
    public String getId() {
        return "WHITESPACE_PARAGRAPH";
    }

    @Override
    public String getDescription() {
        return this.messages.getString("whitespace_before_parapgraph_end_desc");
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int pos = 0;
        for (int n = 0; n < sentences.size(); ++n) {
            AnalyzedSentence sentence = sentences.get(n);
            if (n == sentences.size() - 1 || sentence.hasParagraphEndMark(this.language)) {
                int lw;
                int lb;
                AnalyzedTokenReadings[] tokens = sentence.getTokens();
                for (lb = tokens.length - 1; lb > 0 && tokens[lb].isLinebreak(); --lb) {
                }
                for (lw = lb; lw > 0 && tokens[lw].isWhitespace(); --lw) {
                }
                if (lw < lb) {
                    int fromPos = pos + tokens[lw].getStartPos();
                    int toPos = pos + tokens[lb].getEndPos();
                    RuleMatch ruleMatch = new RuleMatch(this, sentence, fromPos, toPos, this.messages.getString("whitespace_before_parapgraph_end_msg"));
                    if (lw > 0 && !tokens[lw].isWhitespace()) {
                        ruleMatch.setSuggestedReplacement(tokens[lw].getToken());
                    } else {
                        ruleMatch.setSuggestedReplacement("");
                    }
                    ruleMatches.add(ruleMatch);
                }
            }
            pos += sentence.getText().length();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public int minToCheckParagraph() {
        return 0;
    }
}

