/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation.rules;

import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.analysis.AnalyzedSentence;
import org.languagetool.language.Language;
import org.languagetool.tagging.disambiguation.AbstractDisambiguator;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tagging.disambiguation.rules.DisambiguationRuleLoader;
import org.xml.sax.SAXException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\rH\u0004R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/languagetool/tagging/disambiguation/rules/XmlRuleDisambiguator;", "Lorg/languagetool/tagging/disambiguation/AbstractDisambiguator;", "language", "Lorg/languagetool/language/Language;", "(Lorg/languagetool/language/Language;)V", "disambiguationRules", "", "Lorg/languagetool/tagging/disambiguation/rules/DisambiguationPatternRule;", "disambiguate", "Lorg/languagetool/analysis/AnalyzedSentence;", "input", "loadPatternRules", "filename", "", "Companion", "languagetool-core"})
public final class XmlRuleDisambiguator
extends AbstractDisambiguator {
    private List<DisambiguationPatternRule> disambiguationRules;
    private static final String DISAMBIGUATION_FILE = "disambiguation.xml";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public AnalyzedSentence disambiguate(@NotNull AnalyzedSentence input) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        AnalyzedSentence sentence = input;
        for (DisambiguationPatternRule patternRule : this.disambiguationRules) {
            sentence = patternRule.replace(sentence);
        }
        return sentence;
    }

    @NotNull
    protected final List<DisambiguationPatternRule> loadPatternRules(@NotNull String filename) throws ParserConfigurationException, SAXException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        return new DisambiguationRuleLoader().getRules(JLanguageTool.Companion.getDataBroker().getFromResourceDirAsStream(filename));
    }

    public XmlRuleDisambiguator(@NotNull Language language) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        this.disambiguationRules = this.loadPatternRules(language.getShortCode() + "/" + DISAMBIGUATION_FILE);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/languagetool/tagging/disambiguation/rules/XmlRuleDisambiguator$Companion;", "", "()V", "DISAMBIGUATION_FILE", "", "languagetool-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

