/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.instrumentation;

import com.intellij.compiler.instrumentation.FailSafeClassReader;
import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import com.intellij.compiler.instrumentation.InstrumenterClassWriter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.instrumentation.ClassProcessingBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public abstract class BaseInstrumentingBuilder
extends ClassProcessingBuilder {
    private static final Logger LOG = Logger.getInstance(BaseInstrumentingBuilder.class);
    private final Key<Boolean> IS_INSTRUMENTED_KEY = Key.create((String)("_instrumentation_marker_" + this.getPresentableName()));

    public BaseInstrumentingBuilder() {
        super(BuilderCategory.CLASS_INSTRUMENTER);
    }

    @Override
    protected final ModuleLevelBuilder.ExitCode performBuild(CompileContext context, ModuleChunk chunk, InstrumentationClassFinder finder, ModuleLevelBuilder.OutputConsumer outputConsumer) {
        ModuleLevelBuilder.ExitCode exitCode = ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        for (CompiledClass compiledClass : outputConsumer.getCompiledClasses().values()) {
            if (Utils.IS_TEST_MODE || LOG.isDebugEnabled()) {
                LOG.info("checking " + (Object)((Object)compiledClass) + " by " + this.getClass());
            }
            BinaryContent originalContent = compiledClass.getContent();
            FailSafeClassReader reader = new FailSafeClassReader(originalContent.getBuffer(), originalContent.getOffset(), originalContent.getLength());
            int version = InstrumenterClassWriter.getClassFileVersion((ClassReader)reader);
            if (((Boolean)this.IS_INSTRUMENTED_KEY.get((UserDataHolder)compiledClass, (Object)Boolean.FALSE)).booleanValue() || !this.canInstrument(compiledClass, version)) continue;
            InstrumenterClassWriter writer = new InstrumenterClassWriter((ClassReader)reader, InstrumenterClassWriter.getAsmClassWriterFlags((int)version), finder);
            try {
                BinaryContent instrumented;
                if (Utils.IS_TEST_MODE || LOG.isDebugEnabled()) {
                    LOG.info("instrumenting " + (Object)((Object)compiledClass) + " by " + this.getClass());
                }
                if ((instrumented = this.instrument(context, compiledClass, (ClassReader)reader, (ClassWriter)writer, finder)) == null) continue;
                compiledClass.setContent(instrumented);
                String className = compiledClass.getClassName();
                assert (className != null) : compiledClass;
                finder.cleanCachedData(className);
                this.IS_INSTRUMENTED_KEY.set((UserDataHolder)compiledClass, (Object)Boolean.TRUE);
                exitCode = ModuleLevelBuilder.ExitCode.OK;
            }
            catch (Throwable e) {
                LOG.info(e);
                String message = e.getMessage();
                if (message != null) {
                    String sourcePath = (String)ContainerUtil.getFirstItem(compiledClass.getSourceFilesPaths());
                    context.processMessage(new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, message, sourcePath));
                    continue;
                }
                context.processMessage(CompilerMessage.createInternalCompilationError(this.getPresentableName(), e));
            }
        }
        return exitCode;
    }

    protected abstract boolean canInstrument(CompiledClass var1, int var2);

    @Nullable
    protected abstract BinaryContent instrument(CompileContext var1, CompiledClass var2, ClassReader var3, ClassWriter var4, InstrumentationClassFinder var5);
}

