/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaTreeNode;
import com.jetbrains.jsonSchema.impl.SchemaResolveState;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MatchResult {
    public final List<JsonSchemaObject> mySchemas;
    public final List<Collection<? extends JsonSchemaObject>> myExcludingSchemas;

    private MatchResult(@NotNull List<JsonSchemaObject> schemas, @NotNull List<Collection<? extends JsonSchemaObject>> excludingSchemas) {
        if (schemas == null) {
            MatchResult.$$$reportNull$$$0(0);
        }
        if (excludingSchemas == null) {
            MatchResult.$$$reportNull$$$0(1);
        }
        this.mySchemas = Collections.unmodifiableList(schemas);
        this.myExcludingSchemas = Collections.unmodifiableList(excludingSchemas);
    }

    public static MatchResult create(@NotNull JsonSchemaTreeNode root) {
        if (root == null) {
            MatchResult.$$$reportNull$$$0(2);
        }
        ArrayList<JsonSchemaObject> schemas = new ArrayList<JsonSchemaObject>();
        MultiMap oneOfGroups = MultiMap.create();
        MatchResult.iterateTree(root, (Processor<? super JsonSchemaTreeNode>)((Processor)node -> {
            if (node.isAny()) {
                return true;
            }
            int groupNumber = node.getExcludingGroupNumber();
            if (groupNumber < 0) {
                schemas.add(node.getSchema());
            } else {
                oneOfGroups.putValue((Object)groupNumber, (Object)node.getSchema());
            }
            return true;
        }));
        List result = oneOfGroups.isEmpty() ? ContainerUtil.emptyList() : new ArrayList(oneOfGroups.keySet().size());
        for (Map.Entry entry : oneOfGroups.entrySet()) {
            result.add(entry.getValue());
        }
        return new MatchResult(schemas, result);
    }

    public static void iterateTree(@NotNull JsonSchemaTreeNode root, @NotNull Processor<? super JsonSchemaTreeNode> processor) {
        if (root == null) {
            MatchResult.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            MatchResult.$$$reportNull$$$0(4);
        }
        ArrayDeque<JsonSchemaTreeNode> queue = new ArrayDeque<JsonSchemaTreeNode>(root.getChildren());
        while (!queue.isEmpty()) {
            JsonSchemaTreeNode node = queue.removeFirst();
            if (node.getChildren().isEmpty()) {
                if (node.isNothing() || !SchemaResolveState.normal.equals((Object)node.getResolveState()) || processor.process((Object)node)) continue;
                break;
            }
            queue.addAll(node.getChildren());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemas";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludingSchemas";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/MatchResult";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "iterateTree";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

