/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Couple;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Util;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.uiDesigner.radComponents.RadScrollPane;
import com.intellij.uiDesigner.radComponents.RadSplitPane;
import com.intellij.uiDesigner.radComponents.RadTabbedPane;
import com.intellij.uiDesigner.radComponents.XYLayoutManagerImpl;
import com.intellij.uiDesigner.shared.XYLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;

public class GridBuildUtil {
    private static final Logger LOG = Logger.getInstance(GridBuildUtil.class);
    private static final int HORIZONTAL_GRID = 1;
    private static final int VERTICAL_GRID = 2;
    private static final int GRID = 3;
    private static final int GRID_TREMOR = 5;

    private GridBuildUtil() {
    }

    public static void breakGrid(GuiEditor editor) {
        ArrayList<RadComponent> selection = FormEditingUtil.getSelectedComponents(editor);
        if (selection.size() != 1) {
            return;
        }
        if (!(selection.get(0) instanceof RadContainer)) {
            return;
        }
        RadContainer container = (RadContainer)selection.get(0);
        if (container instanceof RadScrollPane || container instanceof RadSplitPane || container instanceof RadTabbedPane) {
            return;
        }
        RadContainer parent = container.getParent();
        if (parent instanceof RadRootContainer) {
            editor.getRootContainer().setMainComponentBinding(container.getBinding());
        }
        if (container.isXY() && !parent.isXY()) {
            return;
        }
        if (parent != null && parent.isXY()) {
            int dx = container.getX();
            int dy = container.getY();
            while (container.getComponentCount() > 0) {
                RadComponent component = container.getComponent(0);
                component.shift(dx, dy);
                parent.addComponent(component);
            }
            parent.removeComponent(container);
        } else {
            XYLayoutManagerImpl xyLayout = new XYLayoutManagerImpl();
            container.setLayout((LayoutManager)((Object)xyLayout));
            xyLayout.setPreferredSize(container.getSize());
        }
        editor.refreshAndSave(true);
    }

    public static void convertToVerticalGrid(GuiEditor editor) {
        GridBuildUtil.convertToGridImpl(editor, 2);
    }

    public static void convertToHorizontalGrid(GuiEditor editor) {
        GridBuildUtil.convertToGridImpl(editor, 1);
    }

    public static void convertToGrid(GuiEditor editor) {
        GridBuildUtil.convertToGridImpl(editor, 3);
    }

    private static void convertToGridImpl(GuiEditor editor, int gridType) {
        GridLayoutManager gridLayoutManager;
        boolean createNewContainer;
        RadContainer parent;
        RadComponent[] componentsToConvert;
        ArrayList<RadComponent> selection = FormEditingUtil.getSelectedComponents(editor);
        if (selection.size() == 0) {
            RadRootContainer rootContainer = editor.getRootContainer();
            if (rootContainer.getComponentCount() < 2) {
                return;
            }
            componentsToConvert = new RadComponent[rootContainer.getComponentCount()];
            for (int i = 0; i < componentsToConvert.length; ++i) {
                componentsToConvert[i] = rootContainer.getComponent(i);
            }
            parent = rootContainer;
            createNewContainer = true;
        } else if (selection.size() == 1 && selection.get(0) instanceof RadContainer) {
            parent = (RadContainer)selection.get(0);
            componentsToConvert = new RadComponent[parent.getComponentCount()];
            for (int i = 0; i < componentsToConvert.length; ++i) {
                componentsToConvert[i] = parent.getComponent(i);
            }
            createNewContainer = false;
        } else {
            componentsToConvert = selection.toArray(RadComponent.EMPTY_ARRAY);
            parent = selection.get(0).getParent();
            createNewContainer = true;
        }
        if (!parent.isXY()) {
            return;
        }
        for (int i = 1; i < componentsToConvert.length; ++i) {
            RadComponent[] component = componentsToConvert[i];
            if (component.getParent() == parent) continue;
            return;
        }
        if (componentsToConvert.length == 0) {
            gridLayoutManager = new GridLayoutManager(1, 1);
        } else if (gridType == 2) {
            gridLayoutManager = GridBuildUtil.createOneDimensionGrid(componentsToConvert, true);
        } else if (gridType == 1) {
            gridLayoutManager = GridBuildUtil.createOneDimensionGrid(componentsToConvert, false);
        } else if (gridType == 3) {
            gridLayoutManager = GridBuildUtil.createTwoDimensionGrid(componentsToConvert);
        } else {
            throw new IllegalArgumentException("invalid grid type: " + gridType);
        }
        for (RadComponent radComponent : componentsToConvert) {
            LayoutManager layout;
            if (!(radComponent instanceof RadContainer) || !((layout = ((RadContainer)radComponent).getLayout()) instanceof XYLayoutManager)) continue;
            ((XYLayoutManager)layout).setPreferredSize(radComponent.getSize());
        }
        if (createNewContainer) {
            Module module = editor.getModule();
            ComponentItem panelItem = Palette.getInstance(editor.getProject()).getPanelItem();
            RadContainer newContainer = new RadContainer(editor, FormEditingUtil.generateId(editor.getRootContainer()));
            newContainer.setLayout((LayoutManager)gridLayoutManager);
            newContainer.init(editor, panelItem);
            for (RadComponent componentToConvert : componentsToConvert) {
                newContainer.addComponent(componentToConvert);
            }
            Point point = GridBuildUtil.getTopLeftPoint(componentsToConvert);
            newContainer.setLocation(point);
            Point bottomRightPoint = GridBuildUtil.getBottomRightPoint(componentsToConvert);
            Dimension size = new Dimension(bottomRightPoint.x - point.x, bottomRightPoint.y - point.y);
            Util.adjustSize((Component)newContainer.getDelegee(), (GridConstraints)newContainer.getConstraints(), (Dimension)size);
            newContainer.getDelegee().setSize(size);
            parent.addComponent(newContainer);
            FormEditingUtil.clearSelection(editor.getRootContainer());
            newContainer.setSelected(true);
            String mainComponentBinding = editor.getRootContainer().getMainComponentBinding();
            if (mainComponentBinding != null && parent instanceof RadRootContainer) {
                newContainer.setBinding(mainComponentBinding);
                editor.getRootContainer().setMainComponentBinding(null);
            }
        } else {
            parent.setLayout((LayoutManager)gridLayoutManager);
            FormEditingUtil.clearSelection(editor.getRootContainer());
            parent.setSelected(true);
        }
        editor.refreshAndSave(true);
    }

    private static GridLayoutManager createOneDimensionGrid(RadComponent[] selection, boolean isVertical) {
        Arrays.sort(selection, (o1, o2) -> {
            Rectangle bounds1 = o1.getBounds();
            Rectangle bounds2 = o2.getBounds();
            if (isVertical) {
                return bounds1.y + bounds1.height / 2 - (bounds2.y + bounds2.height / 2);
            }
            return bounds1.x + bounds1.width / 2 - (bounds2.x + bounds2.width / 2);
        });
        for (int i = 0; i < selection.length; ++i) {
            RadComponent component = selection[i];
            GridConstraints constraints = component.getConstraints();
            if (isVertical) {
                constraints.setRow(i);
                constraints.setColumn(0);
            } else {
                constraints.setRow(0);
                constraints.setColumn(i);
            }
            constraints.setRowSpan(1);
            constraints.setColSpan(1);
        }
        GridLayoutManager gridLayoutManager = isVertical ? new GridLayoutManager(selection.length, 1) : new GridLayoutManager(1, selection.length);
        return gridLayoutManager;
    }

    public static Couple<Integer> layoutInGrid(int[] x, int[] y, int[] rowSpans, int[] colSpans) {
        LOG.assertTrue(x.length == y.length);
        LOG.assertTrue(y.length == colSpans.length);
        LOG.assertTrue(colSpans.length == rowSpans.length);
        for (int i = 0; i < x.length; ++i) {
            colSpans[i] = Math.max(colSpans[i], 1);
            rowSpans[i] = Math.max(rowSpans[i], 1);
            if (colSpans[i] > 20) {
                int n = i;
                colSpans[n] = colSpans[n] - 10;
                int n2 = i;
                x[n2] = x[n2] + 5;
            }
            if (rowSpans[i] <= 20) continue;
            int n = i;
            rowSpans[n] = rowSpans[n] - 10;
            int n3 = i;
            y[n3] = y[n3] + 5;
        }
        return Couple.of((Object)new Integer(Util.eliminate((int[])y, (int[])rowSpans, null)), (Object)new Integer(Util.eliminate((int[])x, (int[])colSpans, null)));
    }

    private static GridLayoutManager createTwoDimensionGrid(RadComponent[] selection) {
        int[] x = new int[selection.length];
        int[] y = new int[selection.length];
        int[] colSpans = new int[selection.length];
        int[] rowSpans = new int[selection.length];
        for (int i = selection.length - 1; i >= 0; --i) {
            x[i] = selection[i].getX();
            y[i] = selection[i].getY();
            rowSpans[i] = selection[i].getHeight();
            colSpans[i] = selection[i].getWidth();
        }
        Couple<Integer> pair = GridBuildUtil.layoutInGrid(x, y, rowSpans, colSpans);
        for (int i = 0; i < selection.length; ++i) {
            RadComponent component = selection[i];
            GridConstraints constraints = component.getConstraints();
            constraints.setRow(y[i]);
            constraints.setRowSpan(rowSpans[i]);
            constraints.setColumn(x[i]);
            constraints.setColSpan(colSpans[i]);
        }
        return new GridLayoutManager(((Integer)pair.first).intValue(), ((Integer)pair.second).intValue());
    }

    private static Point getTopLeftPoint(RadComponent[] components) {
        LOG.assertTrue(components.length > 0);
        Point point = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        for (RadComponent component : components) {
            point.x = Math.min(component.getX(), point.x);
            point.y = Math.min(component.getY(), point.y);
        }
        return point;
    }

    private static Point getBottomRightPoint(RadComponent[] components) {
        LOG.assertTrue(components.length > 0);
        Point point = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        for (RadComponent component : components) {
            point.x = Math.max(component.getX() + component.getWidth(), point.x);
            point.y = Math.max(component.getY() + component.getHeight(), point.y);
        }
        return point;
    }
}

