/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.uiDesigner.CaptionSelection;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import org.jetbrains.annotations.NotNull;

public final class DeleteAction
extends AnAction {
    public DeleteAction() {
        this.getTemplatePresentation().setIcon(AllIcons.General.Remove);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DeleteAction.$$$reportNull$$$0(0);
        }
        GuiEditor editor = FormEditingUtil.getEditorFromContext(e.getDataContext());
        CaptionSelection selection = (CaptionSelection)e.getData(CaptionSelection.DATA_KEY);
        if (editor == null || selection == null || selection.getFocusedIndex() < 0) {
            return;
        }
        FormEditingUtil.deleteRowOrColumn(editor, selection.getContainer(), selection.getSelection(), selection.isRow());
        selection.getContainer().revalidate();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DeleteAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        CaptionSelection selection = (CaptionSelection)e.getData(CaptionSelection.DATA_KEY);
        if (selection == null || selection.getContainer() == null) {
            presentation.setVisible(false);
            return;
        }
        presentation.setVisible(true);
        if (selection.getSelection().length > 1) {
            presentation.setText(!selection.isRow() ? UIDesignerBundle.message("action.delete.columns", new Object[0]) : UIDesignerBundle.message("action.delete.rows", new Object[0]));
        } else {
            presentation.setText(!selection.isRow() ? UIDesignerBundle.message("action.delete.column", new Object[0]) : UIDesignerBundle.message("action.delete.row", new Object[0]));
        }
        int minCellCount = selection.getContainer().getGridLayoutManager().getMinCellCount();
        if (selection.getContainer().getGridCellCount(selection.isRow()) - selection.getSelection().length < minCellCount) {
            presentation.setEnabled(false);
        } else if (selection.getFocusedIndex() < 0) {
            presentation.setEnabled(false);
        } else {
            presentation.setEnabled(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/uiDesigner/actions/DeleteAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

