/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.componentTree;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.componentTree.ButtonGroupDescriptor;
import com.intellij.uiDesigner.componentTree.ButtonGroupListDescriptor;
import com.intellij.uiDesigner.componentTree.ComponentPtr;
import com.intellij.uiDesigner.componentTree.ComponentPtrDescriptor;
import com.intellij.uiDesigner.componentTree.RootDescriptor;
import com.intellij.uiDesigner.componentTree.SuppressionDescriptor;
import com.intellij.uiDesigner.componentTree.SuppressionGroupDescriptor;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.lw.LwInspectionSuppression;
import com.intellij.uiDesigner.radComponents.RadButtonGroup;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

final class ComponentTreeStructure
extends AbstractTreeStructure {
    private static final Logger LOG = Logger.getInstance(ComponentPtr.class);
    private static final Object[] ourEmptyObjectArray = new Object[0];
    private final Object myRootElement;
    private final GuiEditor myEditor;

    ComponentTreeStructure(@NotNull GuiEditor editor) {
        if (editor == null) {
            ComponentTreeStructure.$$$reportNull$$$0(0);
        }
        this.myRootElement = new ComponentTreeStructureRoot();
        this.myEditor = editor;
    }

    @NotNull
    public Object getRootElement() {
        Object object = this.myRootElement;
        if (object == null) {
            ComponentTreeStructure.$$$reportNull$$$0(1);
        }
        return object;
    }

    public Object @NotNull [] getChildElements(@NotNull Object element) {
        if (element == null) {
            ComponentTreeStructure.$$$reportNull$$$0(2);
        }
        if (element == this.myRootElement) {
            RadButtonGroup[] buttonGroups;
            ArrayList<Object> elements = new ArrayList<Object>();
            RadRootContainer rootContainer = this.myEditor.getRootContainer();
            elements.add(new ComponentPtr(this.myEditor, rootContainer));
            LwInspectionSuppression[] suppressions = rootContainer.getInspectionSuppressions();
            if (suppressions.length > 0) {
                elements.add(suppressions);
            }
            if ((buttonGroups = rootContainer.getButtonGroups()).length > 0) {
                elements.add(buttonGroups);
            }
            Object[] objectArray = elements.toArray();
            if (objectArray == null) {
                ComponentTreeStructure.$$$reportNull$$$0(3);
            }
            return objectArray;
        }
        if (element instanceof ComponentPtr) {
            ComponentPtr ptr = (ComponentPtr)element;
            LOG.assertTrue(ptr.isValid());
            RadComponent component = ptr.getComponent();
            if (component instanceof RadContainer) {
                RadContainer container = (RadContainer)component;
                Object[] ptrs = new ComponentPtr[container.getComponentCount()];
                for (int i = 0; i < ptrs.length; ++i) {
                    ptrs[i] = new ComponentPtr(this.myEditor, container.getComponent(i));
                }
                if (ptrs == null) {
                    ComponentTreeStructure.$$$reportNull$$$0(4);
                }
                return ptrs;
            }
            if (ourEmptyObjectArray == null) {
                ComponentTreeStructure.$$$reportNull$$$0(5);
            }
            return ourEmptyObjectArray;
        }
        if (element instanceof LwInspectionSuppression[]) {
            ArrayList<LwInspectionSuppression> result = new ArrayList<LwInspectionSuppression>();
            for (LwInspectionSuppression suppression : (LwInspectionSuppression[])element) {
                if (suppression.getComponentId() != null && FormEditingUtil.findComponent(this.myEditor.getRootContainer(), suppression.getComponentId()) == null) continue;
                result.add(suppression);
            }
            Object[] objectArray = ArrayUtil.toObjectArray(result);
            if (objectArray == null) {
                ComponentTreeStructure.$$$reportNull$$$0(6);
            }
            return objectArray;
        }
        if (element instanceof RadButtonGroup[]) {
            Object[] objectArray = (RadButtonGroup[])element;
            if (objectArray == null) {
                ComponentTreeStructure.$$$reportNull$$$0(7);
            }
            return objectArray;
        }
        if (element instanceof LwInspectionSuppression || element instanceof RadButtonGroup) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                ComponentTreeStructure.$$$reportNull$$$0(8);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        throw new IllegalArgumentException("unknown element: " + element);
    }

    public Object getParentElement(@NotNull Object element) {
        if (element == null) {
            ComponentTreeStructure.$$$reportNull$$$0(9);
        }
        if (element instanceof ComponentTreeStructureRoot) {
            return null;
        }
        if (element instanceof LwInspectionSuppression[] || element instanceof RadButtonGroup[]) {
            return this.myRootElement;
        }
        if (element instanceof LwInspectionSuppression) {
            return this.myEditor.getRootContainer().getInspectionSuppressions();
        }
        if (element instanceof RadButtonGroup) {
            return this.myEditor.getRootContainer().getButtonGroups();
        }
        if (element instanceof ComponentPtr) {
            ComponentPtr ptr = (ComponentPtr)element;
            if (!ptr.isValid()) {
                return this.myRootElement;
            }
            RadComponent component = ptr.getComponent();
            if (component instanceof RadRootContainer) {
                return this.myRootElement;
            }
            return component.getParent() != null ? new ComponentPtr(this.myEditor, component.getParent(), false) : null;
        }
        throw new IllegalArgumentException("unknown element: " + element);
    }

    @NotNull
    public NodeDescriptor createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
        if (element == null) {
            ComponentTreeStructure.$$$reportNull$$$0(10);
        }
        if (element == this.myRootElement) {
            return new RootDescriptor(parentDescriptor, this.myRootElement);
        }
        if (element instanceof ComponentPtr) {
            return new ComponentPtrDescriptor(parentDescriptor, (ComponentPtr)element);
        }
        if (element instanceof LwInspectionSuppression[]) {
            return new SuppressionGroupDescriptor(parentDescriptor, (LwInspectionSuppression[])element);
        }
        if (element instanceof LwInspectionSuppression) {
            LwInspectionSuppression suppression = (LwInspectionSuppression)element;
            RadComponent target = (RadComponent)(suppression.getComponentId() == null ? null : FormEditingUtil.findComponent(this.myEditor.getRootContainer(), suppression.getComponentId()));
            return new SuppressionDescriptor(parentDescriptor, target, suppression);
        }
        if (element instanceof RadButtonGroup[]) {
            return new ButtonGroupListDescriptor(parentDescriptor, (RadButtonGroup[])element);
        }
        if (element instanceof RadButtonGroup) {
            return new ButtonGroupDescriptor(parentDescriptor, (RadButtonGroup)element);
        }
        throw new IllegalArgumentException("unknown element: " + element);
    }

    public boolean isAutoExpandNode(NodeDescriptor descriptor) {
        Object element = descriptor.getElement();
        return element == this.myRootElement || element == this.myEditor.getRootContainer();
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/componentTree/ComponentTreeStructure";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/componentTree/ComponentTreeStructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildElements";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParentElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ComponentTreeStructureRoot {
        private ComponentTreeStructureRoot() {
        }

        public String toString() {
            return "root of component tree structure " + ((Object)((Object)ComponentTreeStructure.this)).toString();
        }
    }
}

