/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadGridLayoutManager;
import com.intellij.uiDesigner.radComponents.RadHSpacer;
import com.intellij.uiDesigner.radComponents.RadVSpacer;
import com.intellij.uiDesigner.snapShooter.SnapshotContext;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.Box;
import javax.swing.JComponent;

public class RadBoxLayoutManager
extends RadGridLayoutManager {
    private boolean myHorizontal = false;
    private int myComponentIndex = 0;

    @Override
    public void createSnapshotLayout(SnapshotContext context, JComponent parent, RadContainer container, LayoutManager layout) {
        int rowCount = 1;
        int colCount = 1;
        boolean hasFiller = false;
        if (parent.getComponentCount() > 1) {
            for (Component component : parent.getComponents()) {
                if (!(component instanceof Box.Filler)) continue;
                hasFiller = true;
                break;
            }
            Rectangle bounds1 = parent.getComponent(0).getBounds();
            Rectangle bounds2 = parent.getComponent(1).getBounds();
            if (bounds2.x >= bounds1.x + bounds1.width) {
                colCount = parent.getComponentCount();
                if (!hasFiller) {
                    ++colCount;
                }
                this.myHorizontal = true;
            } else {
                rowCount = parent.getComponentCount();
                if (!hasFiller) {
                    ++rowCount;
                }
            }
        }
        container.setLayout((LayoutManager)new GridLayoutManager(rowCount, colCount));
        if (!hasFiller) {
            if (this.myHorizontal) {
                container.addComponent(new RadHSpacer(context.newId(), colCount - 1));
            } else {
                container.addComponent(new RadVSpacer(context.newId(), rowCount - 1));
            }
        }
    }

    @Override
    public void addSnapshotComponent(JComponent parent, JComponent child, RadContainer container, RadComponent component) {
        if (this.myHorizontal) {
            component.getConstraints().setColumn(this.myComponentIndex);
        } else {
            component.getConstraints().setRow(this.myComponentIndex);
        }
        ++this.myComponentIndex;
        component.getConstraints().setFill(3);
        container.addComponent(component);
    }
}

