/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.core.AbstractLayout;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.ComponentDragObject;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.FeedbackLayer;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.properties.HGapProperty;
import com.intellij.uiDesigner.propertyInspector.properties.VGapProperty;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadLayoutManager;
import com.intellij.uiDesigner.radComponents.XYLayoutManagerImpl;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadXYLayoutManager
extends RadLayoutManager {
    public static RadXYLayoutManager INSTANCE = new RadXYLayoutManager();

    @Override
    @NonNls
    public String getName() {
        return "XYLayout";
    }

    @Override
    public LayoutManager createLayout() {
        return new XYLayoutManagerImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeLayout(XmlWriter writer, RadContainer radContainer) {
        AbstractLayout layout = (AbstractLayout)radContainer.getLayout();
        writer.addAttribute("hgap", layout.getHGap());
        writer.addAttribute("vgap", layout.getVGap());
        Insets margin = layout.getMargin();
        writer.startElement("margin");
        try {
            writer.writeInsets(margin);
        }
        finally {
            writer.endElement();
        }
    }

    @Override
    public void writeChildConstraints(XmlWriter writer, RadComponent child) {
        writer.startElement("xy");
        try {
            writer.addAttribute("x", child.getX());
            writer.addAttribute("y", child.getY());
            writer.addAttribute("width", child.getWidth());
            writer.addAttribute("height", child.getHeight());
        }
        finally {
            writer.endElement();
        }
    }

    @Override
    @NotNull
    public ComponentDropLocation getDropLocation(RadContainer container, @Nullable Point location) {
        return new MyDropLocation(container, location != null ? location : new Point(5, 5));
    }

    @Override
    public void addComponentToContainer(RadContainer container, RadComponent component, int index) {
        container.getDelegee().add((Component)component.getDelegee(), component.getConstraints());
    }

    @Override
    public Property[] getContainerProperties(Project project) {
        return new Property[]{HGapProperty.getInstance(project), VGapProperty.getInstance(project)};
    }

    private static class MyDropLocation
    implements ComponentDropLocation {
        private final RadContainer myContainer;
        private final Point myLocation;

        MyDropLocation(RadContainer container, @NotNull Point location) {
            if (location == null) {
                MyDropLocation.$$$reportNull$$$0(0);
            }
            this.myContainer = container;
            this.myLocation = location;
        }

        @Override
        public RadContainer getContainer() {
            return this.myContainer;
        }

        @Override
        public boolean canDrop(ComponentDragObject dragObject) {
            if (this.myLocation == null || dragObject.getComponentCount() != 1) {
                return false;
            }
            for (RadComponent component : this.myContainer.getComponents()) {
                if (component.isDragging()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void placeFeedback(FeedbackLayer feedbackLayer, ComponentDragObject dragObject) {
        }

        @Override
        public void processDrop(GuiEditor editor, RadComponent[] components, GridConstraints[] constraintsToAdjust, ComponentDragObject dragObject) {
            int patchX = 0;
            int patchY = 0;
            for (int i = 0; i < components.length; ++i) {
                RadComponent c = components[i];
                Point p = new Point(this.myLocation);
                Point delta = dragObject.getDelta(i);
                if (delta != null) {
                    p.translate(delta.x, delta.y);
                }
                c.setLocation(p);
                patchX = Math.min(patchX, p.x);
                patchY = Math.min(patchY, p.y);
                this.myContainer.addComponent(c);
            }
            if (patchX < 0 || patchY < 0) {
                for (RadComponent component : components) {
                    component.shift(-patchX, -patchY);
                }
            }
        }

        @Override
        @Nullable
        public ComponentDropLocation getAdjacentLocation(ComponentDropLocation.Direction direction) {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/uiDesigner/radComponents/RadXYLayoutManager$MyDropLocation", "<init>"));
        }
    }
}

