/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.snapShooter;

import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.uiDesigner.snapShooter.SnapShotRemoteComponent;
import com.intellij.uiDesigner.snapShooter.SnapshotContext;
import com.intellij.util.ArrayUtilRt;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;

public class SnapShooterDaemon
implements Runnable {
    private final Map<Integer, Component> myIdMap = new HashMap<Integer, Component>();
    private int myNextId = 1;
    private final BlockingQueue<String> myCommandQueue = new ArrayBlockingQueue<String>(20);
    private final BlockingQueue<String> myResponseQueue = new ArrayBlockingQueue<String>(20);
    private final int myPort;

    public SnapShooterDaemon(int port) {
        this.myPort = port;
    }

    @Override
    public void run() {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(this.myPort, 50, InetAddress.getLocalHost());
        }
        catch (IOException ex) {
            System.out.println("Failed to open server socket: " + ex);
            return;
        }
        System.out.println("SnapShooter listening on port " + this.myPort);
        while (true) {
            this.processClientConnection(serverSocket);
        }
    }

    private void processClientConnection(ServerSocket serverSocket) {
        try {
            Socket clientSocket = serverSocket.accept();
            System.out.println("SnapShooter connection accepted");
            InputStreamReader reader = new InputStreamReader(clientSocket.getInputStream(), StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(reader);
            OutputStreamWriter writer = new OutputStreamWriter(clientSocket.getOutputStream(), StandardCharsets.UTF_8);
            while (true) {
                String command;
                try {
                    command = bufferedReader.readLine();
                }
                catch (IOException ex) {
                    break;
                }
                if (command == null) {
                    System.out.println("End of stream receiving command");
                    break;
                }
                this.processCommand(command, writer);
            }
        }
        catch (IOException ex) {
            System.out.println("Exception in SnapShooter connection: " + ex);
        }
    }

    private void processCommand(@NonNls String command, OutputStreamWriter writer) throws IOException {
        if (command.startsWith("S")) {
            SwingUtilities.invokeLater(new SuspendSwingRunnable());
        } else {
            this.myCommandQueue.add(command);
            if (command.startsWith("L") || command.startsWith("X")) {
                String response;
                try {
                    response = this.myResponseQueue.take();
                }
                catch (InterruptedException e) {
                    writer.close();
                    return;
                }
                writer.write(response);
                writer.flush();
            }
        }
    }

    private String[] getChildren(int id) {
        ArrayList<String> result = new ArrayList<String>();
        List<Component> children = this.getChildList(id);
        for (Component child : children) {
            SnapShotRemoteComponent rc = new SnapShotRemoteComponent(this.assignId(child), child.getClass().getName(), SnapShooterDaemon.getLayoutManagerClass(child), SnapShooterDaemon.getChildText(child));
            result.add(rc.toProtocolString());
        }
        return ArrayUtilRt.toStringArray(result);
    }

    private static String getLayoutManagerClass(Component component) {
        LayoutManager layoutManager;
        if (component instanceof JPanel && (layoutManager = ((Container)component).getLayout()) != null) {
            Class<?> layoutManagerClass = layoutManager.getClass();
            while (!layoutManagerClass.getSuperclass().equals(Object.class)) {
                layoutManagerClass = layoutManagerClass.getSuperclass();
            }
            return layoutManagerClass.getName();
        }
        return "";
    }

    private List<Component> getChildList(int id) {
        ArrayList<Component> children = new ArrayList();
        if (id == 0) {
            children = SnapShooterDaemon.getRootWindows();
        } else {
            Component parent = this.myIdMap.get(id);
            if (parent instanceof RootPaneContainer) {
                RootPaneContainer rpc = (RootPaneContainer)((Object)parent);
                children.add(rpc.getContentPane());
            } else if (parent instanceof JSplitPane) {
                JSplitPane splitPane = (JSplitPane)parent;
                if (splitPane.getLeftComponent() != null) {
                    children.add(splitPane.getLeftComponent());
                }
                if (splitPane.getRightComponent() != null) {
                    children.add(splitPane.getRightComponent());
                }
            } else if (parent instanceof JScrollPane) {
                JScrollPane scrollPane = (JScrollPane)parent;
                children.add(scrollPane.getViewport().getView());
            } else if (parent instanceof Container) {
                Collections.addAll(children, ((Container)parent).getComponents());
            }
        }
        return children;
    }

    private static String getChildText(Component component) {
        String text;
        if (component instanceof Frame) {
            Frame frame = (Frame)component;
            return frame.getTitle();
        }
        AccessibleContext accessibleContext = component.getAccessibleContext();
        if (accessibleContext != null && (text = accessibleContext.getAccessibleName()) != null && text.length() > 0) {
            return text;
        }
        return "";
    }

    private int assignId(Component child) {
        int result = this.myNextId++;
        this.myIdMap.put(result, child);
        return result;
    }

    private static List<Component> getRootWindows() {
        ArrayList<Component> result = new ArrayList<Component>();
        for (Frame frame : Frame.getFrames()) {
            if (!frame.getClass().getName().endsWith("SwingUtilities$SharedOwnerFrame")) {
                result.add(frame);
            }
            for (Window window : frame.getOwnedWindows()) {
                if (!window.isVisible()) continue;
                result.add(window);
            }
        }
        return result;
    }

    private class SuspendSwingRunnable
    implements Runnable {
        private SuspendSwingRunnable() {
        }

        @Override
        public void run() {
            while (true) {
                String command;
                try {
                    command = (String)SnapShooterDaemon.this.myCommandQueue.take();
                }
                catch (InterruptedException e) {
                    break;
                }
                if (command.startsWith("R")) break;
                String response = "";
                if (command.startsWith("L")) {
                    response = this.doListCommand(command);
                } else if (command.startsWith("X")) {
                    response = this.doSnapshotCommand(command);
                }
                if (response.length() <= 0) continue;
                System.out.println("Sending response: " + response);
                try {
                    SnapShooterDaemon.this.myResponseQueue.put(response);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        @NonNls
        private String doSnapshotCommand(String command) {
            int id = Integer.parseInt(command.substring(1));
            Component component = (Component)SnapShooterDaemon.this.myIdMap.get(id);
            XmlWriter xmlWriter = new XmlWriter();
            RadRootContainer rootContainer = null;
            try {
                rootContainer = this.createFormSnapshot((JComponent)component);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return "E:" + ex.getMessage() + "\n";
            }
            rootContainer.write(xmlWriter);
            return xmlWriter.getText();
        }

        private RadRootContainer createFormSnapshot(JComponent component) {
            SnapshotContext context = new SnapshotContext();
            RadComponent radComponent = RadComponent.createSnapshotComponent(context, component);
            if (radComponent != null) {
                radComponent.setBounds(new Rectangle(new Point(10, 10), component.getPreferredSize()));
                context.getRootContainer().addComponent(radComponent);
                context.postProcess();
            }
            return context.getRootContainer();
        }

        @NonNls
        private String doListCommand(String command) {
            int id = Integer.parseInt(command.substring(1));
            String[] children = SnapShooterDaemon.this.getChildren(id);
            StringBuilder result = new StringBuilder();
            for (String child : children) {
                result.append(child).append("\n");
            }
            result.append(".\n");
            return result.toString();
        }
    }
}

