/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.snapShooter;

import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IntroComponentProperty;
import com.intellij.uiDesigner.radComponents.RadButtonGroup;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;

public class SnapshotContext {
    private final Palette myPalette;
    private final RadRootContainer myRootContainer;
    private final Set<ButtonGroup> myButtonGroups = new HashSet<ButtonGroup>();
    private final Map<JComponent, RadComponent> myImportMap = new HashMap<JComponent, RadComponent>();
    private final List<ComponentProperty> myComponentProperties = new ArrayList<ComponentProperty>();

    public SnapshotContext() {
        this.myPalette = new Palette(null);
        this.myRootContainer = new RadRootContainer(null, "1");
    }

    public RadRootContainer getRootContainer() {
        return this.myRootContainer;
    }

    public Palette getPalette() {
        return this.myPalette;
    }

    public String newId() {
        return FormEditingUtil.generateId(this.myRootContainer);
    }

    public void registerComponent(JComponent component, RadComponent radComponent) {
        this.myImportMap.put(component, radComponent);
    }

    public void registerButtonGroup(ButtonGroup group) {
        this.myButtonGroups.add(group);
    }

    public void postProcess() {
        for (ButtonGroup group : this.myButtonGroups) {
            RadButtonGroup radButtonGroup = this.myRootContainer.createGroup(this.myRootContainer.suggestGroupName());
            Enumeration<AbstractButton> elements = group.getElements();
            while (elements.hasMoreElements()) {
                AbstractButton btn = elements.nextElement();
                RadComponent c = this.myImportMap.get(btn);
                if (c == null) continue;
                radButtonGroup.add(c);
            }
        }
        for (ComponentProperty prop : this.myComponentProperties) {
            RadComponent radOwner = this.myImportMap.get(prop.owner);
            RadComponent radValue = this.myImportMap.get(prop.value);
            if (radOwner == null || radValue == null) continue;
            IntrospectedProperty property = radOwner.getPalette().getIntrospectedProperty(radOwner, prop.name);
            assert (property != null);
            IntroComponentProperty icp = (IntroComponentProperty)property;
            try {
                icp.setValue(radOwner, radValue.getId());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void registerComponentProperty(JComponent component, String name, JComponent value) {
        this.myComponentProperties.add(new ComponentProperty(component, name, value));
    }

    private static class ComponentProperty {
        public JComponent owner;
        public String name;
        public JComponent value;

        ComponentProperty(JComponent owner, String name, JComponent value) {
            this.owner = owner;
            this.name = name;
            this.value = value;
        }
    }
}

