/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.wizard;

import com.intellij.DynamicBundle;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.StepAdapter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.uiDesigner.wizard.WizardData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

final class BeanStep
extends StepAdapter {
    private JPanel myComponent;
    private TextFieldWithBrowseButton myTfWitgBtnChooseClass;
    private JRadioButton myRbBindToNewBean;
    private JRadioButton myRbBindToExistingBean;
    JTextField myTfShortClassName;
    private TextFieldWithBrowseButton myTfWithBtnChoosePackage;
    private JLabel myPackageLabel;
    private JLabel myExistClassLabel;
    private final WizardData myData;

    BeanStep(@NotNull WizardData data) {
        if (data == null) {
            BeanStep.$$$reportNull$$$0(0);
        }
        this.myData = data;
        this.$$$setupUI$$$();
        this.myPackageLabel.setLabelFor(this.myTfWithBtnChoosePackage.getTextField());
        this.myExistClassLabel.setLabelFor(this.myTfWitgBtnChooseClass.getTextField());
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean state = BeanStep.this.myRbBindToNewBean.isSelected();
                BeanStep.this.myTfShortClassName.setEnabled(state);
                BeanStep.this.myTfWithBtnChoosePackage.setEnabled(state);
                BeanStep.this.myTfWitgBtnChooseClass.setEnabled(!state);
            }
        };
        this.myRbBindToNewBean.addItemListener(itemListener);
        this.myRbBindToExistingBean.addItemListener(itemListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myRbBindToNewBean);
        buttonGroup.add(this.myRbBindToExistingBean);
        this.myTfWitgBtnChooseClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)((BeanStep)BeanStep.this).myData.myProject).createWithInnerClassesScopeChooser(UIDesignerBundle.message("title.choose.bean.class", new Object[0]), GlobalSearchScope.projectScope((Project)((BeanStep)BeanStep.this).myData.myProject), new ClassFilter(){

                    public boolean isAccepted(PsiClass aClass) {
                        return aClass.getParent() instanceof PsiJavaFile;
                    }
                }, null);
                chooser.showDialog();
                PsiClass aClass = chooser.getSelected();
                if (aClass == null) {
                    return;
                }
                String fqName = aClass.getQualifiedName();
                BeanStep.this.myTfWitgBtnChooseClass.setText(fqName);
            }
        });
        this.myTfWithBtnChoosePackage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageChooserDialog dialog = new PackageChooserDialog(UIDesignerBundle.message("title.choose.package", new Object[0]), ((BeanStep)BeanStep.this).myData.myProject);
                dialog.selectPackage(BeanStep.this.myTfWithBtnChoosePackage.getText());
                dialog.show();
                PsiPackage aPackage = dialog.getSelectedPackage();
                if (aPackage != null) {
                    BeanStep.this.myTfWithBtnChoosePackage.setText(aPackage.getQualifiedName());
                }
            }
        });
    }

    public void _init() {
        if (this.myData.myBindToNewBean) {
            this.myRbBindToNewBean.setSelected(true);
        } else {
            this.myRbBindToExistingBean.setSelected(true);
        }
        this.myTfShortClassName.setText(this.myData.myShortClassName);
        this.myTfWithBtnChoosePackage.setText(this.myData.myPackageName);
        this.myTfWitgBtnChooseClass.setText(this.myData.myBeanClass != null ? this.myData.myBeanClass.getQualifiedName() : null);
    }

    private void resetBindings() {
        for (int i = this.myData.myBindings.length - 1; i >= 0; --i) {
            this.myData.myBindings[i].myBeanProperty = null;
        }
    }

    public void _commit(boolean finishChosen) throws CommitStepException {
        boolean newBindToNewBean = this.myRbBindToNewBean.isSelected();
        if (this.myData.myBindToNewBean != newBindToNewBean) {
            this.resetBindings();
        }
        this.myData.myBindToNewBean = newBindToNewBean;
        if (this.myData.myBindToNewBean) {
            String oldShortClassName = this.myData.myShortClassName;
            String oldPackageName = this.myData.myPackageName;
            String shortClassName = this.myTfShortClassName.getText().trim();
            if (shortClassName.length() == 0) {
                throw new CommitStepException(UIDesignerBundle.message("error.please.specify.class.name.of.the.bean.to.be.created", new Object[0]));
            }
            PsiManager psiManager = PsiManager.getInstance((Project)this.myData.myProject);
            if (!PsiNameHelper.getInstance((Project)psiManager.getProject()).isIdentifier(shortClassName)) {
                throw new CommitStepException(UIDesignerBundle.message("error.X.is.not.a.valid.class.name", shortClassName));
            }
            String packageName = this.myTfWithBtnChoosePackage.getText().trim();
            if (packageName.length() != 0 && JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(packageName) == null) {
                throw new CommitStepException(UIDesignerBundle.message("error.package.with.name.X.does.not.exist", packageName));
            }
            this.myData.myShortClassName = shortClassName;
            this.myData.myPackageName = packageName;
            String fullClassName = packageName.length() != 0 ? packageName + "." + shortClassName : shortClassName;
            Module module = ModuleUtil.findModuleForFile((VirtualFile)this.myData.myFormFile, (Project)this.myData.myProject);
            if (JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(fullClassName, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) != null) {
                throw new CommitStepException(UIDesignerBundle.message("error.cannot.create.class.X.because.it.already.exists", fullClassName));
            }
            if (!Comparing.equal((String)oldShortClassName, (String)shortClassName) || !Comparing.equal((String)oldPackageName, (String)packageName)) {
                this.resetBindings();
            }
        } else {
            String oldFqClassName = this.myData.myBeanClass != null ? this.myData.myBeanClass.getQualifiedName() : null;
            String newFqClassName = this.myTfWitgBtnChooseClass.getText().trim();
            if (newFqClassName.length() == 0) {
                throw new CommitStepException(UIDesignerBundle.message("error.please.specify.fully.qualified.name.of.bean.class", new Object[0]));
            }
            PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myData.myProject).findClass(newFqClassName, GlobalSearchScope.allScope((Project)this.myData.myProject));
            if (aClass == null) {
                throw new CommitStepException(UIDesignerBundle.message("error.class.with.name.X.does.not.exist", newFqClassName));
            }
            this.myData.myBeanClass = aClass;
            if (!Comparing.equal((String)oldFqClassName, (String)newFqClassName)) {
                this.resetBindings();
            }
        }
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JLabel jLabel;
        JRadioButton jRadioButton;
        JLabel jLabel2;
        JTextField jTextField;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.myComponent = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myRbBindToNewBean = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/UIDesignerBundle", BeanStep.class).getString("radio.create.new.bean"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/UIDesignerBundle", BeanStep.class).getString("editbox.class"));
        jPanel.add((Component)jLabel3, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTfShortClassName = jTextField = new JTextField();
        jTextField.setColumns(25);
        jPanel.add((Component)jTextField, new GridConstraints(1, 2, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myPackageLabel = jLabel2 = new JLabel();
        jLabel2.setInheritsPopupMenu(true);
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/UIDesignerBundle", BeanStep.class).getString("editbox.package"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(20, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 1, 0, 1, null, null, null));
        this.myRbBindToExistingBean = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/UIDesignerBundle", BeanStep.class).getString("radio.bind.to.existing.bean"));
        jPanel.add((Component)jRadioButton, new GridConstraints(4, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myExistClassLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/UIDesignerBundle", BeanStep.class).getString("editbox.class.2"));
        jPanel.add((Component)jLabel, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTfWitgBtnChooseClass = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(5, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 20), null));
        this.myTfWithBtnChoosePackage = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        jLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myComponent;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/uiDesigner/wizard/BeanStep", "<init>"));
    }
}

