/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.lang.java.parser.ReferenceParser;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class ExpressionParser {
    private static final TokenSet ASSIGNMENT_OPS = TokenSet.create(JavaTokenType.EQ, JavaTokenType.ASTERISKEQ, JavaTokenType.DIVEQ, JavaTokenType.PERCEQ, JavaTokenType.PLUSEQ, JavaTokenType.MINUSEQ, JavaTokenType.LTLTEQ, JavaTokenType.GTGTEQ, JavaTokenType.GTGTGTEQ, JavaTokenType.ANDEQ, JavaTokenType.OREQ, JavaTokenType.XOREQ);
    private static final TokenSet RELATIONAL_OPS = TokenSet.create(JavaTokenType.LT, JavaTokenType.GT, JavaTokenType.LE, JavaTokenType.GE);
    private static final TokenSet POSTFIX_OPS = TokenSet.create(JavaTokenType.PLUSPLUS, JavaTokenType.MINUSMINUS);
    private static final TokenSet PREF_ARITHMETIC_OPS = TokenSet.orSet(POSTFIX_OPS, TokenSet.create(JavaTokenType.PLUS, JavaTokenType.MINUS));
    private static final TokenSet PREFIX_OPS = TokenSet.orSet(PREF_ARITHMETIC_OPS, TokenSet.create(JavaTokenType.TILDE, JavaTokenType.EXCL));
    private static final TokenSet LITERALS = TokenSet.create(JavaTokenType.TRUE_KEYWORD, JavaTokenType.FALSE_KEYWORD, JavaTokenType.NULL_KEYWORD, JavaTokenType.INTEGER_LITERAL, JavaTokenType.LONG_LITERAL, JavaTokenType.FLOAT_LITERAL, JavaTokenType.DOUBLE_LITERAL, JavaTokenType.CHARACTER_LITERAL, JavaTokenType.STRING_LITERAL, JavaTokenType.TEXT_BLOCK_LITERAL);
    private static final TokenSet CONDITIONAL_OR_OPS = TokenSet.create(JavaTokenType.OROR);
    private static final TokenSet CONDITIONAL_AND_OPS = TokenSet.create(JavaTokenType.ANDAND);
    private static final TokenSet OR_OPS = TokenSet.create(JavaTokenType.OR);
    private static final TokenSet XOR_OPS = TokenSet.create(JavaTokenType.XOR);
    private static final TokenSet AND_OPS = TokenSet.create(JavaTokenType.AND);
    private static final TokenSet EQUALITY_OPS = TokenSet.create(JavaTokenType.EQEQ, JavaTokenType.NE);
    private static final TokenSet SHIFT_OPS = TokenSet.create(JavaTokenType.LTLT, JavaTokenType.GTGT, JavaTokenType.GTGTGT);
    private static final TokenSet ADDITIVE_OPS = TokenSet.create(JavaTokenType.PLUS, JavaTokenType.MINUS);
    private static final TokenSet MULTIPLICATIVE_OPS = TokenSet.create(JavaTokenType.ASTERISK, JavaTokenType.DIV, JavaTokenType.PERC);
    private static final TokenSet ARGS_LIST_END = TokenSet.create(JavaTokenType.RPARENTH, JavaTokenType.RBRACE, JavaTokenType.RBRACKET);
    private static final TokenSet ARGS_LIST_CONTINUE = TokenSet.create(JavaTokenType.IDENTIFIER, TokenType.BAD_CHARACTER, JavaTokenType.COMMA, JavaTokenType.INTEGER_LITERAL, JavaTokenType.STRING_LITERAL);
    private static final TokenSet THIS_OR_SUPER = TokenSet.create(JavaTokenType.THIS_KEYWORD, JavaTokenType.SUPER_KEYWORD);
    private static final TokenSet ID_OR_SUPER = TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.SUPER_KEYWORD);
    private static final TokenSet TYPE_START = TokenSet.orSet(ElementType.PRIMITIVE_TYPE_BIT_SET, TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.AT));
    private static final Key<Boolean> CASE_LABEL = Key.create("java.parser.case.label.expr");
    private final JavaParser myParser;

    public ExpressionParser(@NotNull JavaParser javaParser) {
        if (javaParser == null) {
            ExpressionParser.$$$reportNull$$$0(0);
        }
        this.myParser = javaParser;
    }

    @Nullable
    public PsiBuilder.Marker parse(@NotNull PsiBuilder builder) {
        if (builder == null) {
            ExpressionParser.$$$reportNull$$$0(1);
        }
        return this.parseAssignment(builder);
    }

    @Nullable
    public PsiBuilder.Marker parseCaseLabel(@NotNull PsiBuilder builder) {
        if (builder == null) {
            ExpressionParser.$$$reportNull$$$0(2);
        }
        CASE_LABEL.set(builder, Boolean.TRUE);
        try {
            PsiBuilder.Marker marker = this.parseAssignment(builder);
            return marker;
        }
        finally {
            CASE_LABEL.set(builder, null);
        }
    }

    @Nullable
    private PsiBuilder.Marker parseAssignment(PsiBuilder builder) {
        PsiBuilder.Marker left = this.parseConditional(builder);
        if (left == null) {
            return null;
        }
        IElementType tokenType = ExpressionParser.getGtTokenType(builder);
        if (tokenType != null && ASSIGNMENT_OPS.contains(tokenType)) {
            PsiBuilder.Marker assignment = left.precede();
            ExpressionParser.advanceGtToken(builder, tokenType);
            PsiBuilder.Marker right = this.parse(builder);
            if (right == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            }
            assignment.done(JavaElementType.ASSIGNMENT_EXPRESSION);
            return assignment;
        }
        return left;
    }

    @Nullable
    public PsiBuilder.Marker parseConditional(PsiBuilder builder) {
        PsiBuilder.Marker condition = this.parseExpression(builder, ExprType.CONDITIONAL_OR);
        if (condition == null) {
            return null;
        }
        if (builder.getTokenType() != JavaTokenType.QUEST) {
            return condition;
        }
        PsiBuilder.Marker ternary = condition.precede();
        builder.advanceLexer();
        PsiBuilder.Marker truePart = this.parse(builder);
        if (truePart == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            ternary.done(JavaElementType.CONDITIONAL_EXPRESSION);
            return ternary;
        }
        if (builder.getTokenType() != JavaTokenType.COLON) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.colon", new Object[0]));
            ternary.done(JavaElementType.CONDITIONAL_EXPRESSION);
            return ternary;
        }
        builder.advanceLexer();
        PsiBuilder.Marker falsePart = this.parseConditional(builder);
        if (falsePart == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            ternary.done(JavaElementType.CONDITIONAL_EXPRESSION);
            return ternary;
        }
        ternary.done(JavaElementType.CONDITIONAL_EXPRESSION);
        return ternary;
    }

    @Nullable
    private PsiBuilder.Marker parseExpression(PsiBuilder builder, ExprType type2) {
        switch (type2) {
            case CONDITIONAL_OR: {
                return this.parseBinary(builder, ExprType.CONDITIONAL_AND, CONDITIONAL_OR_OPS);
            }
            case CONDITIONAL_AND: {
                return this.parseBinary(builder, ExprType.OR, CONDITIONAL_AND_OPS);
            }
            case OR: {
                return this.parseBinary(builder, ExprType.XOR, OR_OPS);
            }
            case XOR: {
                return this.parseBinary(builder, ExprType.AND, XOR_OPS);
            }
            case AND: {
                return this.parseBinary(builder, ExprType.EQUALITY, AND_OPS);
            }
            case EQUALITY: {
                return this.parseBinary(builder, ExprType.RELATIONAL, EQUALITY_OPS);
            }
            case RELATIONAL: {
                return this.parseRelational(builder);
            }
            case SHIFT: {
                return this.parseBinary(builder, ExprType.ADDITIVE, SHIFT_OPS);
            }
            case ADDITIVE: {
                return this.parseBinary(builder, ExprType.MULTIPLICATIVE, ADDITIVE_OPS);
            }
            case MULTIPLICATIVE: {
                return this.parseBinary(builder, ExprType.UNARY, MULTIPLICATIVE_OPS);
            }
            case UNARY: {
                return this.parseUnary(builder);
            }
            case TYPE: {
                return this.myParser.getReferenceParser().parseType(builder, 5);
            }
        }
        assert (false) : "Unexpected type: " + (Object)((Object)type2);
        return null;
    }

    @Nullable
    private PsiBuilder.Marker parseBinary(PsiBuilder builder, ExprType type2, TokenSet ops) {
        IElementType tokenType;
        PsiBuilder.Marker result2 = this.parseExpression(builder, type2);
        if (result2 == null) {
            return null;
        }
        int operandCount = 1;
        IElementType currentExprTokenType = tokenType = ExpressionParser.getGtTokenType(builder);
        while (tokenType != null && ops.contains(tokenType)) {
            ExpressionParser.advanceGtToken(builder, tokenType);
            PsiBuilder.Marker right = this.parseExpression(builder, type2);
            ++operandCount;
            tokenType = ExpressionParser.getGtTokenType(builder);
            if (tokenType != null && ops.contains(tokenType) && tokenType == currentExprTokenType && right != null) continue;
            result2 = result2.precede();
            if (right == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            }
            result2.done(operandCount > 2 ? JavaElementType.POLYADIC_EXPRESSION : JavaElementType.BINARY_EXPRESSION);
            if (right == null) break;
            currentExprTokenType = tokenType;
            operandCount = 1;
        }
        return result2;
    }

    @Nullable
    private PsiBuilder.Marker parseRelational(PsiBuilder builder) {
        IElementType tokenType;
        PsiBuilder.Marker left = this.parseExpression(builder, ExprType.SHIFT);
        if (left == null) {
            return null;
        }
        while ((tokenType = ExpressionParser.getGtTokenType(builder)) != null) {
            ExprType toParse;
            IElementType toCreate;
            if (RELATIONAL_OPS.contains(tokenType)) {
                toCreate = JavaElementType.BINARY_EXPRESSION;
                toParse = ExprType.SHIFT;
            } else {
                if (tokenType != JavaTokenType.INSTANCEOF_KEYWORD) break;
                toCreate = JavaElementType.INSTANCE_OF_EXPRESSION;
                toParse = ExprType.TYPE;
            }
            PsiBuilder.Marker expression2 = left.precede();
            ExpressionParser.advanceGtToken(builder, tokenType);
            PsiBuilder.Marker right = this.parseExpression(builder, toParse);
            if (right == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message(toParse == ExprType.TYPE ? "expected.type" : "expected.expression", new Object[0]));
                expression2.done(toCreate);
                return expression2;
            }
            expression2.done(toCreate);
            left = expression2;
        }
        return left;
    }

    @Nullable
    private PsiBuilder.Marker parseUnary(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (PREFIX_OPS.contains(tokenType)) {
            PsiBuilder.Marker unary = builder.mark();
            builder.advanceLexer();
            PsiBuilder.Marker operand = this.parseUnary(builder);
            if (operand == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            }
            unary.done(JavaElementType.PREFIX_EXPRESSION);
            return unary;
        }
        if (tokenType == JavaTokenType.LPARENTH) {
            PsiBuilder.Marker typeCast = builder.mark();
            builder.advanceLexer();
            ReferenceParser.TypeInfo typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder, 101);
            if (typeInfo == null || !PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
                typeCast.rollbackTo();
                return this.parsePostfix(builder);
            }
            if (PREF_ARITHMETIC_OPS.contains(builder.getTokenType()) && !typeInfo.isPrimitive) {
                typeCast.rollbackTo();
                return this.parsePostfix(builder);
            }
            PsiBuilder.Marker expr = this.parseUnary(builder);
            if (expr == null) {
                if (!typeInfo.isParameterized) {
                    typeCast.rollbackTo();
                    return this.parsePostfix(builder);
                }
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            }
            typeCast.done(JavaElementType.TYPE_CAST_EXPRESSION);
            return typeCast;
        }
        if (tokenType == JavaTokenType.SWITCH_KEYWORD) {
            return this.myParser.getStatementParser().parseExprInParenthWithBlock(builder, JavaElementType.SWITCH_EXPRESSION, true);
        }
        return this.parsePostfix(builder);
    }

    @Nullable
    private PsiBuilder.Marker parsePostfix(PsiBuilder builder) {
        PsiBuilder.Marker operand = this.parsePrimary(builder, null, -1);
        if (operand == null) {
            return null;
        }
        while (POSTFIX_OPS.contains(builder.getTokenType())) {
            PsiBuilder.Marker postfix = operand.precede();
            builder.advanceLexer();
            postfix.done(JavaElementType.POSTFIX_EXPRESSION);
            operand = postfix;
        }
        return operand;
    }

    @Nullable
    private PsiBuilder.Marker parsePrimary(PsiBuilder builder, @Nullable BreakPoint breakPoint, int breakOffset) {
        IElementType tokenType;
        PsiBuilder.Marker startMarker = builder.mark();
        PsiBuilder.Marker expr = this.parsePrimaryExpressionStart(builder);
        if (expr == null) {
            startMarker.drop();
            return null;
        }
        while (true) {
            if ((tokenType = builder.getTokenType()) == JavaTokenType.DOT) {
                PsiBuilder.Marker refExpr;
                int offset2;
                PsiBuilder.Marker copy2;
                PsiBuilder.Marker dotPos = builder.mark();
                int dotOffset = builder.getCurrentOffset();
                builder.advanceLexer();
                IElementType dotTokenType = builder.getTokenType();
                if (dotTokenType == JavaTokenType.AT) {
                    this.myParser.getDeclarationParser().parseAnnotations(builder);
                    dotTokenType = builder.getTokenType();
                }
                if (dotTokenType == JavaTokenType.CLASS_KEYWORD && JavaParserUtil.exprType(expr) == JavaElementType.REFERENCE_EXPRESSION) {
                    if (breakPoint == BreakPoint.P1 && builder.getCurrentOffset() == breakOffset) {
                        JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                        PsiBuilderUtil.drop(startMarker, dotPos);
                        return expr;
                    }
                    copy2 = startMarker.precede();
                    offset2 = builder.getCurrentOffset();
                    startMarker.rollbackTo();
                    PsiBuilder.Marker classObjAccess = this.parseClassAccessOrMethodReference(builder);
                    if (classObjAccess == null || builder.getCurrentOffset() < offset2) {
                        copy2.rollbackTo();
                        return this.parsePrimary(builder, BreakPoint.P1, offset2);
                    }
                    startMarker = copy2;
                    expr = classObjAccess;
                    continue;
                }
                if (dotTokenType == JavaTokenType.NEW_KEYWORD) {
                    dotPos.drop();
                    expr = this.parseNew(builder, expr);
                    continue;
                }
                if (dotTokenType == JavaTokenType.SUPER_KEYWORD && builder.lookAhead(1) == JavaTokenType.LPARENTH) {
                    dotPos.drop();
                    refExpr = expr.precede();
                    builder.mark().done(JavaElementType.REFERENCE_PARAMETER_LIST);
                    builder.advanceLexer();
                    refExpr.done(JavaElementType.REFERENCE_EXPRESSION);
                    expr = refExpr;
                    continue;
                }
                if (THIS_OR_SUPER.contains(dotTokenType) && JavaParserUtil.exprType(expr) == JavaElementType.REFERENCE_EXPRESSION) {
                    if (breakPoint == BreakPoint.P2 && builder.getCurrentOffset() == breakOffset) {
                        dotPos.rollbackTo();
                        startMarker.drop();
                        return expr;
                    }
                    copy2 = startMarker.precede();
                    offset2 = builder.getCurrentOffset();
                    startMarker.rollbackTo();
                    PsiBuilder.Marker ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, false, true, false, false);
                    if (ref == null || builder.getTokenType() != JavaTokenType.DOT || builder.getCurrentOffset() != dotOffset) {
                        copy2.rollbackTo();
                        return this.parsePrimary(builder, BreakPoint.P2, offset2);
                    }
                    builder.advanceLexer();
                    if (builder.getTokenType() != dotTokenType) {
                        copy2.rollbackTo();
                        return this.parsePrimary(builder, BreakPoint.P2, offset2);
                    }
                    builder.advanceLexer();
                    startMarker = copy2;
                    expr = ref.precede();
                    expr.done(dotTokenType == JavaTokenType.THIS_KEYWORD ? JavaElementType.THIS_EXPRESSION : JavaElementType.SUPER_EXPRESSION);
                    continue;
                }
                refExpr = expr.precede();
                this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, false);
                if (!PsiBuilderUtil.expect(builder, ID_OR_SUPER)) {
                    dotPos.rollbackTo();
                    builder.advanceLexer();
                    this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, false);
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                    refExpr.done(JavaElementType.REFERENCE_EXPRESSION);
                    startMarker.drop();
                    return refExpr;
                }
                dotPos.drop();
                refExpr.done(JavaElementType.REFERENCE_EXPRESSION);
                expr = refExpr;
                continue;
            }
            if (tokenType == JavaTokenType.LPARENTH) {
                if (JavaParserUtil.exprType(expr) != JavaElementType.REFERENCE_EXPRESSION) {
                    startMarker.drop();
                    return expr;
                }
                PsiBuilder.Marker callExpr = expr.precede();
                this.parseArgumentList(builder);
                callExpr.done(JavaElementType.METHOD_CALL_EXPRESSION);
                expr = callExpr;
                continue;
            }
            if (tokenType != JavaTokenType.LBRACKET) break;
            if (breakPoint == BreakPoint.P4) {
                startMarker.drop();
                return expr;
            }
            builder.advanceLexer();
            if (builder.getTokenType() == JavaTokenType.RBRACKET && JavaParserUtil.exprType(expr) == JavaElementType.REFERENCE_EXPRESSION) {
                int pos = builder.getCurrentOffset();
                PsiBuilder.Marker copy3 = startMarker.precede();
                startMarker.rollbackTo();
                PsiBuilder.Marker classObjAccess = this.parseClassAccessOrMethodReference(builder);
                if (classObjAccess == null || builder.getCurrentOffset() <= pos) {
                    copy3.rollbackTo();
                    return this.parsePrimary(builder, BreakPoint.P4, -1);
                }
                startMarker = copy3;
                expr = classObjAccess;
                continue;
            }
            PsiBuilder.Marker arrayAccess = expr.precede();
            PsiBuilder.Marker index2 = this.parse(builder);
            if (index2 == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
                arrayAccess.done(JavaElementType.ARRAY_ACCESS_EXPRESSION);
                startMarker.drop();
                return arrayAccess;
            }
            if (builder.getTokenType() != JavaTokenType.RBRACKET) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rbracket", new Object[0]));
                arrayAccess.done(JavaElementType.ARRAY_ACCESS_EXPRESSION);
                startMarker.drop();
                return arrayAccess;
            }
            builder.advanceLexer();
            arrayAccess.done(JavaElementType.ARRAY_ACCESS_EXPRESSION);
            expr = arrayAccess;
        }
        if (tokenType == JavaTokenType.DOUBLE_COLON) {
            return this.parseMethodReference(builder, startMarker);
        }
        startMarker.drop();
        return expr;
    }

    @Nullable
    private PsiBuilder.Marker parsePrimaryExpressionStart(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (LITERALS.contains(tokenType)) {
            PsiBuilder.Marker literal = builder.mark();
            builder.advanceLexer();
            literal.done(JavaElementType.LITERAL_EXPRESSION);
            return literal;
        }
        if (tokenType == JavaTokenType.LBRACE) {
            return this.parseArrayInitializer(builder);
        }
        if (tokenType == JavaTokenType.NEW_KEYWORD) {
            return this.parseNew(builder, null);
        }
        if (tokenType == JavaTokenType.LPARENTH) {
            PsiBuilder.Marker lambda2;
            if (CASE_LABEL.get(builder) != Boolean.TRUE && (lambda2 = this.parseLambdaAfterParenth(builder)) != null) {
                return lambda2;
            }
            PsiBuilder.Marker parenth = builder.mark();
            builder.advanceLexer();
            PsiBuilder.Marker inner = this.parse(builder);
            if (inner == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            }
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH) && inner != null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rparen", new Object[0]));
            }
            parenth.done(JavaElementType.PARENTH_EXPRESSION);
            return parenth;
        }
        if (TYPE_START.contains(tokenType)) {
            PsiBuilder.Marker mark = builder.mark();
            ReferenceParser.TypeInfo typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder, 0);
            if (typeInfo != null) {
                PsiBuilder.Marker result2;
                boolean optionalClassKeyword;
                boolean bl = optionalClassKeyword = typeInfo.isPrimitive || typeInfo.isArray;
                if ((optionalClassKeyword || !typeInfo.hasErrors && typeInfo.isParameterized) && (result2 = this.parseClassAccessOrMethodReference(builder, mark, optionalClassKeyword)) != null) {
                    return result2;
                }
            }
            mark.rollbackTo();
        }
        PsiBuilder.Marker annotation2 = null;
        if (tokenType == JavaTokenType.AT) {
            annotation2 = this.myParser.getDeclarationParser().parseAnnotations(builder);
            tokenType = builder.getTokenType();
        }
        if (tokenType == JavaTokenType.VAR_KEYWORD) {
            tokenType = JavaTokenType.IDENTIFIER;
            builder.remapCurrentToken(tokenType);
        }
        if (tokenType == JavaTokenType.IDENTIFIER) {
            PsiBuilder.Marker refExpr;
            if (CASE_LABEL.get(builder) != Boolean.TRUE && builder.lookAhead(1) == JavaTokenType.ARROW) {
                return this.parseLambdaExpression(builder, false);
            }
            if (annotation2 != null) {
                PsiBuilder.Marker refParam = annotation2.precede();
                refParam.doneBefore(JavaElementType.REFERENCE_PARAMETER_LIST, annotation2);
                refExpr = refParam.precede();
            } else {
                refExpr = builder.mark();
                builder.mark().done(JavaElementType.REFERENCE_PARAMETER_LIST);
            }
            builder.advanceLexer();
            refExpr.done(JavaElementType.REFERENCE_EXPRESSION);
            return refExpr;
        }
        if (annotation2 != null) {
            annotation2.rollbackTo();
            tokenType = builder.getTokenType();
        }
        PsiBuilder.Marker expr = null;
        if (tokenType == JavaTokenType.LT) {
            expr = builder.mark();
            if (!this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, false)) {
                expr.rollbackTo();
                return null;
            }
            tokenType = builder.getTokenType();
            if (!THIS_OR_SUPER.contains(tokenType)) {
                expr.rollbackTo();
                return null;
            }
        }
        if (THIS_OR_SUPER.contains(tokenType)) {
            if (expr == null) {
                expr = builder.mark();
                builder.mark().done(JavaElementType.REFERENCE_PARAMETER_LIST);
            }
            builder.advanceLexer();
            expr.done(builder.getTokenType() == JavaTokenType.LPARENTH ? JavaElementType.REFERENCE_EXPRESSION : (tokenType == JavaTokenType.THIS_KEYWORD ? JavaElementType.THIS_EXPRESSION : JavaElementType.SUPER_EXPRESSION));
            return expr;
        }
        return null;
    }

    @NotNull
    private PsiBuilder.Marker parseArrayInitializer(PsiBuilder builder) {
        PsiBuilder.Marker marker = this.parseArrayInitializer(builder, JavaElementType.ARRAY_INITIALIZER_EXPRESSION, this::parse, "expected.expression");
        if (marker == null) {
            ExpressionParser.$$$reportNull$$$0(3);
        }
        return marker;
    }

    @NotNull
    public PsiBuilder.Marker parseArrayInitializer(@NotNull PsiBuilder builder, @NotNull IElementType type2, @NotNull Function<? super PsiBuilder, PsiBuilder.Marker> elementParser, @NotNull @PropertyKey(resourceBundle="messages.JavaErrorMessages") String missingElementKey) {
        if (builder == null) {
            ExpressionParser.$$$reportNull$$$0(4);
        }
        if (type2 == null) {
            ExpressionParser.$$$reportNull$$$0(5);
        }
        if (elementParser == null) {
            ExpressionParser.$$$reportNull$$$0(6);
        }
        if (missingElementKey == null) {
            ExpressionParser.$$$reportNull$$$0(7);
        }
        PsiBuilder.Marker arrayInit = builder.mark();
        builder.advanceLexer();
        boolean first2 = true;
        while (true) {
            if (builder.getTokenType() == JavaTokenType.RBRACE) {
                builder.advanceLexer();
                break;
            }
            if (builder.getTokenType() == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rbrace", new Object[0]));
                break;
            }
            if (elementParser.apply(builder) == null) {
                if (builder.getTokenType() == JavaTokenType.COMMA) {
                    if (first2 && builder.lookAhead(1) == JavaTokenType.RBRACE) {
                        PsiBuilderUtil.advance(builder, 2);
                        break;
                    }
                    builder.error(JavaErrorMessages.message(missingElementKey, new Object[0]));
                } else if (builder.getTokenType() != JavaTokenType.RBRACE) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rbrace", new Object[0]));
                    break;
                }
            }
            first2 = false;
            IElementType tokenType = builder.getTokenType();
            if (PsiBuilderUtil.expect(builder, JavaTokenType.COMMA) || tokenType == JavaTokenType.RBRACE) continue;
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.comma", new Object[0]));
        }
        arrayInit.done(type2);
        PsiBuilder.Marker marker = arrayInit;
        if (marker == null) {
            ExpressionParser.$$$reportNull$$$0(8);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseNew(PsiBuilder builder, @Nullable PsiBuilder.Marker start) {
        int dimCount;
        PsiBuilder.Marker anno;
        PsiBuilder.Marker newExpr;
        block19: {
            PsiBuilder.Marker refOrType;
            newExpr = start != null ? start.precede() : builder.mark();
            builder.advanceLexer();
            this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, true);
            anno = this.myParser.getDeclarationParser().parseAnnotations(builder);
            IElementType tokenType = builder.getTokenType();
            if (tokenType == JavaTokenType.IDENTIFIER) {
                PsiBuilderUtil.rollbackTo(anno);
                refOrType = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, true, true, true);
                if (refOrType == null) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                    newExpr.done(JavaElementType.NEW_EXPRESSION);
                    PsiBuilder.Marker marker = newExpr;
                    if (marker == null) {
                        ExpressionParser.$$$reportNull$$$0(9);
                    }
                    return marker;
                }
            } else if (ElementType.PRIMITIVE_TYPE_BIT_SET.contains(tokenType)) {
                refOrType = null;
                builder.advanceLexer();
            } else {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                newExpr.done(JavaElementType.NEW_EXPRESSION);
                PsiBuilder.Marker marker = newExpr;
                if (marker == null) {
                    ExpressionParser.$$$reportNull$$$0(10);
                }
                return marker;
            }
            if (refOrType != null && builder.getTokenType() == JavaTokenType.LPARENTH) {
                this.parseArgumentList(builder);
                if (builder.getTokenType() == JavaTokenType.LBRACE) {
                    PsiBuilder.Marker classElement = refOrType.precede();
                    this.myParser.getDeclarationParser().parseClassBodyWithBraces(builder, false, false);
                    classElement.done(JavaElementType.ANONYMOUS_CLASS);
                }
                newExpr.done(JavaElementType.NEW_EXPRESSION);
                PsiBuilder.Marker marker = newExpr;
                if (marker == null) {
                    ExpressionParser.$$$reportNull$$$0(11);
                }
                return marker;
            }
            anno = this.myParser.getDeclarationParser().parseAnnotations(builder);
            if (builder.getTokenType() != JavaTokenType.LBRACKET) {
                PsiBuilderUtil.rollbackTo(anno);
                JavaParserUtil.error(builder, JavaErrorMessages.message(refOrType == null ? "expected.lbracket" : "expected.lparen.or.lbracket", new Object[0]));
                newExpr.done(JavaElementType.NEW_EXPRESSION);
                PsiBuilder.Marker marker = newExpr;
                if (marker == null) {
                    ExpressionParser.$$$reportNull$$$0(12);
                }
                return marker;
            }
            int bracketCount = 0;
            dimCount = 0;
            do {
                PsiBuilder.Marker dimExpr;
                anno = this.myParser.getDeclarationParser().parseAnnotations(builder);
                if (builder.getTokenType() != JavaTokenType.LBRACKET) break block19;
                builder.advanceLexer();
                if (bracketCount == dimCount && (dimExpr = this.parse(builder)) != null) {
                    ++dimCount;
                }
                ++bracketCount;
            } while (JavaParserUtil.expectOrError(builder, JavaTokenType.RBRACKET, "expected.rbracket"));
            newExpr.done(JavaElementType.NEW_EXPRESSION);
            PsiBuilder.Marker marker = newExpr;
            if (marker == null) {
                ExpressionParser.$$$reportNull$$$0(13);
            }
            return marker;
        }
        PsiBuilderUtil.rollbackTo(anno);
        if (dimCount == 0) {
            if (builder.getTokenType() == JavaTokenType.LBRACE) {
                this.parseArrayInitializer(builder);
            } else {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.array.initializer", new Object[0]));
            }
        }
        newExpr.done(JavaElementType.NEW_EXPRESSION);
        PsiBuilder.Marker marker = newExpr;
        if (marker == null) {
            ExpressionParser.$$$reportNull$$$0(14);
        }
        return marker;
    }

    @Nullable
    private PsiBuilder.Marker parseClassAccessOrMethodReference(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        boolean primitive = ElementType.PRIMITIVE_TYPE_BIT_SET.contains(builder.getTokenType());
        if (this.myParser.getReferenceParser().parseType(builder, 0) == null) {
            expr.drop();
            return null;
        }
        PsiBuilder.Marker result2 = this.parseClassAccessOrMethodReference(builder, expr, primitive);
        if (result2 == null) {
            expr.rollbackTo();
        }
        return result2;
    }

    @Nullable
    private PsiBuilder.Marker parseClassAccessOrMethodReference(PsiBuilder builder, PsiBuilder.Marker expr, boolean optionalClassKeyword) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType == JavaTokenType.DOT) {
            return ExpressionParser.parseClassObjectAccess(builder, expr, optionalClassKeyword);
        }
        if (tokenType == JavaTokenType.DOUBLE_COLON) {
            return this.parseMethodReference(builder, expr);
        }
        return null;
    }

    @Nullable
    private static PsiBuilder.Marker parseClassObjectAccess(PsiBuilder builder, PsiBuilder.Marker expr, boolean optionalClassKeyword) {
        PsiBuilder.Marker mark = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == JavaTokenType.CLASS_KEYWORD) {
            mark.drop();
            builder.advanceLexer();
        } else {
            if (!optionalClassKeyword) {
                return null;
            }
            mark.rollbackTo();
            builder.error(".class expected");
        }
        expr.done(JavaElementType.CLASS_OBJECT_ACCESS_EXPRESSION);
        return expr;
    }

    @NotNull
    private PsiBuilder.Marker parseMethodReference(PsiBuilder builder, PsiBuilder.Marker start) {
        builder.advanceLexer();
        this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, false);
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER) && !PsiBuilderUtil.expect(builder, JavaTokenType.NEW_KEYWORD)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
        }
        start.done(JavaElementType.METHOD_REF_EXPRESSION);
        PsiBuilder.Marker marker = start;
        if (marker == null) {
            ExpressionParser.$$$reportNull$$$0(15);
        }
        return marker;
    }

    @Nullable
    private PsiBuilder.Marker parseLambdaAfterParenth(PsiBuilder builder) {
        boolean isTyped;
        boolean isLambda;
        IElementType nextToken1 = builder.lookAhead(1);
        IElementType nextToken2 = builder.lookAhead(2);
        if (nextToken1 == JavaTokenType.RPARENTH && nextToken2 == JavaTokenType.ARROW) {
            isLambda = true;
            isTyped = false;
        } else if (nextToken1 == JavaTokenType.AT || ElementType.MODIFIER_BIT_SET.contains(nextToken1) || ElementType.PRIMITIVE_TYPE_BIT_SET.contains(nextToken1)) {
            isLambda = true;
            isTyped = true;
        } else if (nextToken1 == JavaTokenType.IDENTIFIER) {
            if (nextToken2 == JavaTokenType.COMMA || nextToken2 == JavaTokenType.RPARENTH && builder.lookAhead(3) == JavaTokenType.ARROW) {
                isLambda = true;
                isTyped = false;
            } else if (nextToken2 == JavaTokenType.ARROW) {
                isLambda = false;
                isTyped = false;
            } else {
                IElementType t;
                boolean lambda2 = false;
                PsiBuilder.Marker marker = builder.mark();
                builder.advanceLexer();
                ReferenceParser.TypeInfo typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder, 7);
                if (typeInfo != null && ((t = builder.getTokenType()) == JavaTokenType.IDENTIFIER || t == JavaTokenType.THIS_KEYWORD || t == JavaTokenType.RPARENTH && builder.lookAhead(1) == JavaTokenType.ARROW)) {
                    lambda2 = true;
                }
                marker.rollbackTo();
                isLambda = lambda2;
                isTyped = true;
            }
        } else {
            isLambda = false;
            isTyped = false;
        }
        return isLambda ? this.parseLambdaExpression(builder, isTyped) : null;
    }

    @Nullable
    private PsiBuilder.Marker parseLambdaExpression(PsiBuilder builder, boolean typed) {
        PsiBuilder.Marker start = builder.mark();
        this.myParser.getDeclarationParser().parseLambdaParameterList(builder, typed);
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.ARROW)) {
            start.rollbackTo();
            return null;
        }
        PsiBuilder.Marker body2 = builder.getTokenType() == JavaTokenType.LBRACE ? this.myParser.getStatementParser().parseCodeBlock(builder) : this.parse(builder);
        if (body2 == null) {
            builder.error(JavaErrorMessages.message("expected.lbrace", new Object[0]));
        }
        start.done(JavaElementType.LAMBDA_EXPRESSION);
        return start;
    }

    @NotNull
    public PsiBuilder.Marker parseArgumentList(PsiBuilder builder) {
        PsiBuilder.Marker list2 = builder.mark();
        builder.advanceLexer();
        boolean first2 = true;
        while (true) {
            IElementType tokenType = builder.getTokenType();
            if (first2 && (ARGS_LIST_END.contains(tokenType) || builder.eof()) || !first2 && !ARGS_LIST_CONTINUE.contains(tokenType)) break;
            boolean hasError = false;
            if (!first2) {
                if (builder.getTokenType() == JavaTokenType.COMMA) {
                    builder.advanceLexer();
                } else {
                    hasError = true;
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.comma.or.rparen", new Object[0]));
                    ExpressionParser.emptyExpression(builder);
                }
            }
            first2 = false;
            PsiBuilder.Marker arg = this.parse(builder);
            if (arg != null) continue;
            if (!hasError) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
                ExpressionParser.emptyExpression(builder);
            }
            if (!ARGS_LIST_CONTINUE.contains(builder.getTokenType())) break;
            if (builder.getTokenType() == JavaTokenType.COMMA || builder.eof()) continue;
            builder.advanceLexer();
        }
        boolean closed = JavaParserUtil.expectOrError(builder, JavaTokenType.RPARENTH, "expected.rparen");
        list2.done(JavaElementType.EXPRESSION_LIST);
        if (!closed) {
            list2.setCustomEdgeTokenBinders(null, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        PsiBuilder.Marker marker = list2;
        if (marker == null) {
            ExpressionParser.$$$reportNull$$$0(16);
        }
        return marker;
    }

    private static void emptyExpression(PsiBuilder builder) {
        JavaParserUtil.emptyElement(builder, JavaElementType.EMPTY_EXPRESSION);
    }

    @Nullable
    private static IElementType getGtTokenType(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType != JavaTokenType.GT) {
            return tokenType;
        }
        if (builder.rawLookup(1) == JavaTokenType.GT) {
            tokenType = builder.rawLookup(2) == JavaTokenType.GT ? (builder.rawLookup(3) == JavaTokenType.EQ ? JavaTokenType.GTGTGTEQ : JavaTokenType.GTGTGT) : (builder.rawLookup(2) == JavaTokenType.EQ ? JavaTokenType.GTGTEQ : JavaTokenType.GTGT);
        } else if (builder.rawLookup(1) == JavaTokenType.EQ) {
            tokenType = JavaTokenType.GE;
        }
        return tokenType;
    }

    private static void advanceGtToken(PsiBuilder builder, IElementType type2) {
        PsiBuilder.Marker gtToken = builder.mark();
        if (type2 == JavaTokenType.GTGTGTEQ) {
            PsiBuilderUtil.advance(builder, 4);
        } else if (type2 == JavaTokenType.GTGTGT || type2 == JavaTokenType.GTGTEQ) {
            PsiBuilderUtil.advance(builder, 3);
        } else if (type2 == JavaTokenType.GTGT || type2 == JavaTokenType.GE) {
            PsiBuilderUtil.advance(builder, 2);
        } else {
            gtToken.drop();
            builder.advanceLexer();
            return;
        }
        gtToken.collapse(type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/parser/ExpressionParser";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementParser";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missingElementKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/parser/ExpressionParser";
                break;
            }
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseArrayInitializer";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "parseNew";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMethodReference";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "parseArgumentList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseCaseLabel";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseArrayInitializer";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum BreakPoint {
        P1,
        P2,
        P4;

    }

    private static enum ExprType {
        CONDITIONAL_OR,
        CONDITIONAL_AND,
        OR,
        XOR,
        AND,
        EQUALITY,
        RELATIONAL,
        SHIFT,
        ADDITIVE,
        MULTIPLICATIVE,
        UNARY,
        TYPE;

    }
}

