/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.builder;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.builder.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclarationKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"collectClassNames", "", "javaFileStub", "Lcom/intellij/psi/impl/java/stubs/PsiJavaFileStub;", "findDelegate", "Lcom/intellij/psi/PsiClass;", "classFqName", "Lorg/jetbrains/kotlin/name/FqName;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "light-classes"})
public final class LightClassDataHolderKt {
    @NotNull
    public static final PsiClass findDelegate(@NotNull PsiJavaFileStub $this$findDelegate, @NotNull KtClassOrObject classOrObject) {
        String string2;
        Intrinsics.checkParameterIsNotNull($this$findDelegate, "$this$findDelegate");
        Intrinsics.checkParameterIsNotNull(classOrObject, "classOrObject");
        PsiClass psiClass = LightClassUtil.INSTANCE.findClass($this$findDelegate, new Function1<PsiClassStub<?>, Boolean>(classOrObject){
            final /* synthetic */ KtClassOrObject $classOrObject;

            public final boolean invoke(@NotNull PsiClassStub<?> it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return Intrinsics.areEqual(ClsWrapperStubPsiFactory.getOriginalElement(it), this.$classOrObject);
            }
            {
                this.$classOrObject = ktClassOrObject;
                super(1);
            }
        });
        if (psiClass != null) {
            PsiClass psiClass2 = psiClass;
            boolean bl = false;
            boolean bl2 = false;
            PsiClass it = psiClass2;
            boolean bl3 = false;
            return it;
        }
        KtClassOrObject outermostClassOrObject = KtLightClassForSourceDeclarationKt.getOutermostClassOrObject(classOrObject);
        try {
            PsiFile psiFile = outermostClassOrObject.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull(psiFile, "outermostClassOrObject.containingFile");
            string2 = psiFile.getText();
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw (Throwable)e;
            }
            string2 = "Can't get text for outermost class";
        }
        String ktFileText = string2;
        String string3 = DebugUtil.stubTreeToString($this$findDelegate);
        Intrinsics.checkExpressionValueIsNotNull(string3, "DebugUtil.stubTreeToString(this)");
        String stubFileText = string3;
        KotlinExceptionWithAttachments kotlinExceptionWithAttachments = new KotlinExceptionWithAttachments("Couldn't get delegate for class");
        String string4 = classOrObject.getName();
        if (string4 == null) {
            string4 = "unnamed class or object";
        }
        Intrinsics.checkExpressionValueIsNotNull(string4, "classOrObject.name ?: \"unnamed class or object\"");
        throw (Throwable)kotlinExceptionWithAttachments.withAttachment(string4, DebugTextUtilKt.getDebugText(classOrObject)).withAttachment("file.kt", ktFileText).withAttachment("stub text", stubFileText);
    }

    @NotNull
    public static final PsiClass findDelegate(@NotNull PsiJavaFileStub $this$findDelegate, @NotNull FqName classFqName) {
        Intrinsics.checkParameterIsNotNull($this$findDelegate, "$this$findDelegate");
        Intrinsics.checkParameterIsNotNull(classFqName, "classFqName");
        PsiClass psiClass = LightClassUtil.INSTANCE.findClass($this$findDelegate, new Function1<PsiClassStub<?>, Boolean>(classFqName){
            final /* synthetic */ FqName $classFqName;

            public final boolean invoke(@NotNull PsiClassStub<?> it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return Intrinsics.areEqual(this.$classFqName.asString(), it.getQualifiedName());
            }
            {
                this.$classFqName = fqName2;
                super(1);
            }
        });
        if (psiClass == null) {
            throw (Throwable)new IllegalStateException("Facade class " + classFqName + " not found; classes in Java file stub: " + LightClassDataHolderKt.collectClassNames($this$findDelegate));
        }
        return psiClass;
    }

    private static final String collectClassNames(PsiJavaFileStub javaFileStub) {
        boolean bl = false;
        List names2 = new ArrayList();
        LightClassUtil.INSTANCE.findClass(javaFileStub, new Function1<PsiClassStub<?>, Boolean>(names2){
            final /* synthetic */ List $names;

            public final boolean invoke(@NotNull PsiClassStub<?> cls) {
                Intrinsics.checkParameterIsNotNull(cls, "cls");
                String string2 = cls.getQualifiedName();
                if (string2 == null) {
                    string2 = "<null>";
                }
                Intrinsics.checkExpressionValueIsNotNull(string2, "cls.qualifiedName ?: \"<null>\"");
                this.$names.add(string2);
                return false;
            }
            {
                this.$names = list2;
                super(1);
            }
        });
        return CollectionsKt.joinToString$default(names2, null, "[", "]", 0, null, null, 57, null);
    }
}

