/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.ForLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.IterableHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.LoopReplacement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrWhileLoopImpl;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016JB\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/IterableLoopHeader;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopHeader;", "headerInfo", "Lorg/jetbrains/kotlin/backend/common/lower/loops/IterableHeaderInfo;", "(Lorg/jetbrains/kotlin/backend/common/lower/loops/IterableHeaderInfo;)V", "consumesLoopVariableComponents", "", "getConsumesLoopVariableComponents", "()Z", "loopInitStatements", "", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "getLoopInitStatements", "()Ljava/util/List;", "buildLoop", "Lorg/jetbrains/kotlin/backend/common/lower/loops/LoopReplacement;", "builder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "oldLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "newBody", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "initializeIteration", "Lorg/jetbrains/kotlin/ir/IrStatement;", "loopVariable", "loopVariableComponents", "", "", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "ir.backend.common"})
public final class IterableLoopHeader
implements ForLoopHeader {
    @NotNull
    private final List<IrVariable> loopInitStatements;
    private final boolean consumesLoopVariableComponents = false;
    private final IterableHeaderInfo headerInfo;

    @NotNull
    public List<IrVariable> getLoopInitStatements() {
        return this.loopInitStatements;
    }

    @Override
    public boolean getConsumesLoopVariableComponents() {
        return this.consumesLoopVariableComponents;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<IrStatement> initializeIteration(@Nullable IrVariable loopVariable, @NotNull Map<Integer, ? extends IrVariable> loopVariableComponents, @NotNull Symbols<? extends CommonBackendContext> symbols2, @NotNull DeclarationIrBuilder builder) {
        Object element$iv2;
        IrBuilderWithScope irBuilderWithScope;
        Object object;
        DeclarationIrBuilder $this$with;
        block3: {
            void $this$first$iv;
            Intrinsics.checkParameterIsNotNull(loopVariableComponents, "loopVariableComponents");
            Intrinsics.checkParameterIsNotNull(symbols2, "symbols");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            boolean bl = false;
            boolean bl2 = false;
            $this$with = builder;
            boolean bl3 = false;
            IrClass irClass = IrTypesKt.getClass(this.headerInfo.getIteratorVariable().getType());
            if (irClass == null) {
                Intrinsics.throwNpe();
            }
            IrClass iteratorClass = irClass;
            object = IrUtilsKt.getFunctions(iteratorClass);
            irBuilderWithScope = $this$with;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv2;
                boolean bl4 = false;
                if (!(Intrinsics.areEqual(it.getName(), OperatorNameConventions.NEXT) && it.getValueParameters().isEmpty())) continue;
                break block3;
            }
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        Object t = element$iv2;
        object = ExpressionHelpersKt.irCall(irBuilderWithScope, (IrFunction)t);
        boolean bl = false;
        boolean bl5 = false;
        Object $this$apply = object;
        boolean bl6 = false;
        $this$apply.setDispatchReceiver(ExpressionHelpersKt.irGet($this$with, this.headerInfo.getIteratorVariable()));
        Object next = object;
        IrVariable irVariable2 = loopVariable;
        if (irVariable2 != null) {
            irVariable2.setInitializer((IrExpression)next);
        }
        IrVariable irVariable3 = loopVariable;
        return CollectionsKt.listOf(irVariable3 != null ? (IrStatement)irVariable3 : (IrStatement)IrUtilsKt.coerceToUnitIfNeeded((IrExpression)next, next.getType(), $this$with.getContext().getIrBuiltIns()));
    }

    @Override
    @NotNull
    public LoopReplacement buildLoop(@NotNull DeclarationIrBuilder builder, @NotNull IrLoop oldLoop, @Nullable IrExpression newBody) {
        Object element$iv;
        IrFunctionAccessExpression $this$first$iv;
        IrBuilderWithScope irBuilderWithScope;
        DeclarationIrBuilder $this$with;
        block2: {
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            Intrinsics.checkParameterIsNotNull(oldLoop, "oldLoop");
            boolean bl = false;
            boolean bl2 = false;
            $this$with = builder;
            boolean bl3 = false;
            IrClass irClass = IrTypesKt.getClass(this.headerInfo.getIteratorVariable().getType());
            if (irClass == null) {
                Intrinsics.throwNpe();
            }
            IrClass iteratorClass = irClass;
            Sequence<IrSimpleFunction> sequence2 = IrUtilsKt.getFunctions(iteratorClass);
            irBuilderWithScope = $this$with;
            boolean $i$f$first = false;
            Iterator iterator2 = $this$first$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl4 = false;
                if (!(Intrinsics.areEqual(it.getName(), OperatorNameConventions.HAS_NEXT) && it.getValueParameters().isEmpty())) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        Object t = element$iv;
        $this$first$iv = ExpressionHelpersKt.irCall(irBuilderWithScope, (IrFunction)t);
        boolean bl = false;
        boolean bl5 = false;
        IrFunctionAccessExpression $this$apply = $this$first$iv;
        boolean bl6 = false;
        $this$apply.setDispatchReceiver(ExpressionHelpersKt.irGet($this$with, this.headerInfo.getIteratorVariable()));
        IrFunctionAccessExpression hasNext = $this$first$iv;
        IrWhileLoopImpl irWhileLoopImpl = new IrWhileLoopImpl(oldLoop.getStartOffset(), oldLoop.getEndOffset(), oldLoop.getType(), oldLoop.getOrigin());
        bl5 = false;
        boolean bl7 = false;
        IrWhileLoopImpl $this$apply2 = irWhileLoopImpl;
        boolean bl8 = false;
        $this$apply2.setLabel(oldLoop.getLabel());
        $this$apply2.setCondition(hasNext);
        $this$apply2.setBody(newBody);
        IrWhileLoopImpl newLoop = irWhileLoopImpl;
        return new LoopReplacement(newLoop, newLoop);
    }

    public IterableLoopHeader(@NotNull IterableHeaderInfo headerInfo) {
        Intrinsics.checkParameterIsNotNull(headerInfo, "headerInfo");
        this.headerInfo = headerInfo;
        this.loopInitStatements = CollectionsKt.listOf(this.headerInfo.getIteratorVariable());
    }
}

