/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa.contracts;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.contracts.description.ConeBinaryLogicExpression;
import org.jetbrains.kotlin.fir.contracts.description.ConeBooleanConstantReference;
import org.jetbrains.kotlin.fir.contracts.description.ConeConditionalEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeConstantReference;
import org.jetbrains.kotlin.fir.contracts.description.ConeContractDescriptionVisitor;
import org.jetbrains.kotlin.fir.contracts.description.ConeIsInstancePredicate;
import org.jetbrains.kotlin.fir.contracts.description.ConeIsNullPredicate;
import org.jetbrains.kotlin.fir.contracts.description.ConeLogicalNot;
import org.jetbrains.kotlin.fir.contracts.description.ConeValueParameterReference;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirConstKind;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.impl.FirBinaryLogicExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirConstExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirFunctionCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirOperatorCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirTypeOperatorCallImpl;
import org.jetbrains.kotlin.fir.references.impl.FirSimpleNamedReference;
import org.jetbrains.kotlin.fir.types.impl.FirResolvedTypeRefImpl;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\f\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J&\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003H\u0016J&\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003H\u0016J&\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003H\u0016J&\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003H\u0016J&\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003H\u0016J&\u0010\u0018\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003H\u0016J&\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003H\u0016\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/contracts/ConeConditionalEffectToFirVisitor;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeContractDescriptionVisitor;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "", "", "()V", "createConstNull", "Lorg/jetbrains/kotlin/fir/expressions/FirConstExpression;", "visitConditionalEffectDeclaration", "conditionalEffect", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeConditionalEffectDeclaration;", "data", "visitConstantDescriptor", "constantReference", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeConstantReference;", "visitIsInstancePredicate", "isInstancePredicate", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeIsInstancePredicate;", "visitIsNullPredicate", "isNullPredicate", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeIsNullPredicate;", "visitLogicalBinaryOperationContractExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeBinaryLogicExpression;", "visitLogicalNot", "logicalNot", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeLogicalNot;", "visitValueParameterReference", "valueParameterReference", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeValueParameterReference;", "resolve"})
final class ConeConditionalEffectToFirVisitor
extends ConeContractDescriptionVisitor<FirExpression, Map<Integer, ? extends FirExpression>> {
    public static final ConeConditionalEffectToFirVisitor INSTANCE;

    @Override
    @Nullable
    public FirExpression visitConditionalEffectDeclaration(@NotNull ConeConditionalEffectDeclaration conditionalEffect, @NotNull Map<Integer, ? extends FirExpression> data) {
        Intrinsics.checkParameterIsNotNull(conditionalEffect, "conditionalEffect");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return (FirExpression)conditionalEffect.getCondition().accept(this, data);
    }

    @Override
    @Nullable
    public FirExpression visitConstantDescriptor(@NotNull ConeConstantReference constantReference, @NotNull Map<Integer, ? extends FirExpression> data) {
        Intrinsics.checkParameterIsNotNull(constantReference, "constantReference");
        Intrinsics.checkParameterIsNotNull(data, "data");
        ConeConstantReference coneConstantReference = constantReference;
        return Intrinsics.areEqual(coneConstantReference, ConeBooleanConstantReference.Companion.getTRUE()) ? (FirConstExpression)new FirConstExpressionImpl<Boolean>(null, FirConstKind.Boolean.INSTANCE, true) : (Intrinsics.areEqual(coneConstantReference, ConeBooleanConstantReference.Companion.getFALSE()) ? (FirConstExpression)new FirConstExpressionImpl<Boolean>(null, FirConstKind.Boolean.INSTANCE, false) : (Intrinsics.areEqual(coneConstantReference, ConeConstantReference.Companion.getNULL()) ? this.createConstNull() : null));
    }

    @Override
    @Nullable
    public FirExpression visitLogicalBinaryOperationContractExpression(@NotNull ConeBinaryLogicExpression binaryLogicExpression, @NotNull Map<Integer, ? extends FirExpression> data) {
        Intrinsics.checkParameterIsNotNull(binaryLogicExpression, "binaryLogicExpression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        FirExpression firExpression2 = (FirExpression)binaryLogicExpression.getLeft().accept(this, data);
        if (firExpression2 == null) {
            return null;
        }
        FirExpression leftExpression = firExpression2;
        FirExpression firExpression3 = (FirExpression)binaryLogicExpression.getRight().accept(this, data);
        if (firExpression3 == null) {
            return null;
        }
        FirExpression rightExpression = firExpression3;
        return new FirBinaryLogicExpressionImpl(null, leftExpression, rightExpression, binaryLogicExpression.getKind());
    }

    @Override
    @Nullable
    public FirExpression visitLogicalNot(@NotNull ConeLogicalNot logicalNot, @NotNull Map<Integer, ? extends FirExpression> data) {
        Intrinsics.checkParameterIsNotNull(logicalNot, "logicalNot");
        Intrinsics.checkParameterIsNotNull(data, "data");
        FirExpression firExpression2 = (FirExpression)logicalNot.getArg().accept(this, data);
        if (firExpression2 == null) {
            return null;
        }
        FirExpression explicitReceiver = firExpression2;
        FirFunctionCallImpl firFunctionCallImpl = new FirFunctionCallImpl(null);
        boolean bl = false;
        boolean bl2 = false;
        FirFunctionCallImpl $this$apply = firFunctionCallImpl;
        boolean bl3 = false;
        $this$apply.setCalleeReference(new FirSimpleNamedReference(null, OperatorNameConventions.NOT, null));
        $this$apply.setExplicitReceiver(explicitReceiver);
        return firFunctionCallImpl;
    }

    @Override
    @Nullable
    public FirExpression visitIsInstancePredicate(@NotNull ConeIsInstancePredicate isInstancePredicate, @NotNull Map<Integer, ? extends FirExpression> data) {
        Intrinsics.checkParameterIsNotNull(isInstancePredicate, "isInstancePredicate");
        Intrinsics.checkParameterIsNotNull(data, "data");
        FirOperation operation = isInstancePredicate.isNegated() ? FirOperation.NOT_IS : FirOperation.IS;
        return new FirTypeOperatorCallImpl(null, operation, new FirResolvedTypeRefImpl(null, isInstancePredicate.getType()));
    }

    @Override
    @Nullable
    public FirExpression visitIsNullPredicate(@NotNull ConeIsNullPredicate isNullPredicate, @NotNull Map<Integer, ? extends FirExpression> data) {
        Intrinsics.checkParameterIsNotNull(isNullPredicate, "isNullPredicate");
        Intrinsics.checkParameterIsNotNull(data, "data");
        FirConstExpression<?> firConstExpression = (FirConstExpression<?>)isNullPredicate.getArg().accept(this, data);
        if (firConstExpression == null) {
            return null;
        }
        FirConstExpression<?> argument = firConstExpression;
        FirOperation operation = isNullPredicate.isNegated() ? FirOperation.NOT_EQ : FirOperation.EQ;
        FirOperatorCallImpl firOperatorCallImpl = new FirOperatorCallImpl(null, operation);
        boolean bl = false;
        boolean bl2 = false;
        FirOperatorCallImpl $this$apply = firOperatorCallImpl;
        boolean bl3 = false;
        Collection collection = $this$apply.getArguments();
        FirConstExpression<?> firConstExpression2 = argument;
        boolean bl4 = false;
        collection.add(firConstExpression2);
        collection = $this$apply.getArguments();
        firConstExpression2 = INSTANCE.createConstNull();
        bl4 = false;
        collection.add(firConstExpression2);
        return firOperatorCallImpl;
    }

    @Override
    @Nullable
    public FirExpression visitValueParameterReference(@NotNull ConeValueParameterReference valueParameterReference, @NotNull Map<Integer, ? extends FirExpression> data) {
        Intrinsics.checkParameterIsNotNull(valueParameterReference, "valueParameterReference");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return data.get(valueParameterReference.getParameterIndex());
    }

    private final FirConstExpression<?> createConstNull() {
        return new FirConstExpressionImpl<Object>(null, FirConstKind.Null.INSTANCE, null);
    }

    private ConeConditionalEffectToFirVisitor() {
    }

    static {
        ConeConditionalEffectToFirVisitor coneConditionalEffectToFirVisitor;
        INSTANCE = coneConditionalEffectToFirVisitor = new ConeConditionalEffectToFirVisitor();
    }
}

