/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import git4idea.DialogManager;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.AbstractGithubUrlGroupingAction;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.ui.GithubChooseAccountDialog;
import org.jetbrains.plugins.github.util.GithubAccountsMigrationHelper;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J8\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H$J0\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0019H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0003H\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/github/AbstractAuthenticatingGithubUrlGroupingAction;", "Lorg/jetbrains/plugins/github/AbstractGithubUrlGroupingAction;", "text", "", "description", "icon", "Ljavax/swing/Icon;", "(Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "remoteUrl", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "chooseAccount", "authenticationManager", "Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "accounts", "", "getAccount", "intellij.vcs.github"})
public abstract class AbstractAuthenticatingGithubUrlGroupingAction
extends AbstractGithubUrlGroupingAction {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Project project, @NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String remoteUrl) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)remote, (String)"remote");
        Intrinsics.checkParameterIsNotNull((Object)remoteUrl, (String)"remoteUrl");
        boolean $i$f$service = false;
        Object object = ApplicationManager.getApplication().getService(GithubAccountsMigrationHelper.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
        if (!GithubAccountsMigrationHelper.migrate$default((GithubAccountsMigrationHelper)object, project, null, 2, null)) {
            return;
        }
        GithubAccount githubAccount = this.getAccount(project, remoteUrl);
        if (githubAccount == null) {
            return;
        }
        GithubAccount account = githubAccount;
        this.actionPerformed(e, project, repository, remote, remoteUrl, account);
    }

    /*
     * WARNING - void declaration
     */
    private final GithubAccount getAccount(Project project, String remoteUrl) {
        GithubAccount githubAccount;
        void $this$filterTo$iv$iv;
        boolean $i$f$service = false;
        Object object = ApplicationManager.getApplication().getService(GithubAuthenticationManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
        GithubAuthenticationManager authenticationManager = (GithubAuthenticationManager)object;
        Iterable $this$filter$iv = authenticationManager.getAccounts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GithubAccount it = (GithubAccount)element$iv$iv;
            boolean bl = false;
            if (!it.getServer().matches(remoteUrl)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List accounts = (List)destination$iv$iv;
        if (accounts.isEmpty()) {
            if (!GithubServerPath.DEFAULT_SERVER.matches(remoteUrl)) {
                throw (Throwable)new IllegalArgumentException("Remote " + remoteUrl + " does not match " + GithubServerPath.DEFAULT_SERVER);
            }
            GithubServerPath githubServerPath = GithubServerPath.DEFAULT_SERVER;
            Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"GithubServerPath.DEFAULT_SERVER");
            return GithubAuthenticationManager.requestNewAccountForServer$default(authenticationManager, githubServerPath, project, null, 4, null);
        }
        GithubAccount githubAccount2 = (GithubAccount)CollectionsKt.singleOrNull((List)accounts);
        if (githubAccount2 == null) {
            Iterator iterator;
            block6: {
                Iterable iterable2 = accounts;
                boolean bl = false;
                iterable = iterable2;
                boolean bl2 = false;
                for (Iterator iterator2 : iterable) {
                    GithubAccount it = (GithubAccount)((Object)iterator2);
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)authenticationManager.getDefaultAccount(project))) continue;
                    iterator = iterator2;
                    break block6;
                }
                iterator = null;
            }
            githubAccount2 = githubAccount = (GithubAccount)((Object)iterator);
        }
        if (githubAccount2 == null) {
            githubAccount = this.chooseAccount(project, authenticationManager, remoteUrl, accounts);
        }
        return githubAccount;
    }

    private final GithubAccount chooseAccount(Project project, GithubAuthenticationManager authenticationManager, String remoteUrl, List<? extends GithubAccount> accounts) {
        GithubChooseAccountDialog dialog2 = new GithubChooseAccountDialog(project, null, accounts, "Choose GitHub account for: " + remoteUrl, false, true, null, null, 192, null);
        DialogManager.show((DialogWrapper)dialog2);
        if (!dialog2.isOK()) {
            return null;
        }
        GithubAccount account = dialog2.getAccount();
        if (dialog2.getSetDefault()) {
            authenticationManager.setDefaultAccount(project, account);
        }
        return account;
    }

    protected abstract void actionPerformed(@NotNull AnActionEvent var1, @NotNull Project var2, @NotNull GitRepository var3, @NotNull GitRemote var4, @NotNull String var5, @NotNull GithubAccount var6);

    public AbstractAuthenticatingGithubUrlGroupingAction(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }
}

