/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.dvcs.hosting.RepositoryListLoader;
import com.intellij.dvcs.hosting.RepositoryListLoadingException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import git4idea.remote.GitHttpAuthDataProvider;
import git4idea.remote.GitRepositoryHostingService;
import git4idea.remote.InteractiveGitHttpAuthDataProvider;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubRepoBasic;
import org.jetbrains.plugins.github.api.util.GithubApiPagesLoader;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubMissingTokenException;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.extensions.GithubHttpAuthDataProvider;
import org.jetbrains.plugins.github.extensions.InteractiveCreateGithubAccountHttpAuthDataProvider;
import org.jetbrains.plugins.github.extensions.InteractiveSelectGithubAccountHttpAuthDataProvider;
import org.jetbrains.plugins.github.util.GithubAccountsMigrationHelper;
import org.jetbrains.plugins.github.util.GithubGitHelper;

final class GithubRepositoryHostingService
extends GitRepositoryHostingService {
    @NotNull
    private final GithubAuthenticationManager myAuthenticationManager = GithubAuthenticationManager.getInstance();
    @NotNull
    private final GithubApiRequestExecutorManager myExecutorManager = GithubApiRequestExecutorManager.getInstance();
    @NotNull
    private final GithubGitHelper myGitHelper = GithubGitHelper.getInstance();
    @NotNull
    private final GithubHttpAuthDataProvider myAuthDataProvider = (GithubHttpAuthDataProvider)GitHttpAuthDataProvider.EP_NAME.findExtensionOrFail(GithubHttpAuthDataProvider.class);

    @NotNull
    public String getServiceDisplayName() {
        return "GitHub";
    }

    @NotNull
    public RepositoryListLoader getRepositoryListLoader(final @NotNull Project project) {
        if (project == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(0);
        }
        return new RepositoryListLoader(){
            @NotNull
            private final Map<GithubAccount, GithubApiRequestExecutor> myExecutors = new HashMap<GithubAccount, GithubApiRequestExecutor>();

            public boolean isEnabled() {
                for (GithubAccount account : GithubRepositoryHostingService.this.myAuthenticationManager.getAccounts()) {
                    try {
                        this.myExecutors.put(account, GithubRepositoryHostingService.this.myExecutorManager.getExecutor(account));
                    }
                    catch (GithubMissingTokenException githubMissingTokenException) {}
                }
                return !this.myExecutors.isEmpty();
            }

            public boolean enable(@Nullable Component parentComponent) {
                if (!GithubAccountsMigrationHelper.getInstance().migrate(project, parentComponent)) {
                    return false;
                }
                if (!GithubRepositoryHostingService.this.myAuthenticationManager.ensureHasAccounts(project, parentComponent)) {
                    return false;
                }
                boolean atLeastOneHasToken = false;
                for (GithubAccount account : GithubRepositoryHostingService.this.myAuthenticationManager.getAccounts()) {
                    GithubApiRequestExecutor.WithTokenAuth executor = GithubRepositoryHostingService.this.myExecutorManager.getExecutor(account, project);
                    if (executor == null) continue;
                    this.myExecutors.put(account, executor);
                    atLeastOneHasToken = true;
                }
                return atLeastOneHasToken;
            }

            @NotNull
            public RepositoryListLoader.Result getAvailableRepositoriesFromMultipleSources(@NotNull ProgressIndicator progressIndicator) {
                if (progressIndicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                ArrayList urls = new ArrayList();
                ArrayList<RepositoryListLoadingException> exceptions = new ArrayList<RepositoryListLoadingException>();
                for (Map.Entry<GithubAccount, GithubApiRequestExecutor> entry : this.myExecutors.entrySet()) {
                    GithubServerPath server = entry.getKey().getServer();
                    GithubApiRequestExecutor executor = entry.getValue();
                    try {
                        Stream streamAssociated = GithubApiPagesLoader.loadAll(executor, progressIndicator, GithubApiRequests.CurrentUser.Repos.pages(server)).stream();
                        Object streamWatched = StreamEx.empty();
                        try {
                            streamWatched = GithubApiPagesLoader.loadAll(executor, progressIndicator, GithubApiRequests.CurrentUser.RepoSubs.pages(server)).stream();
                        }
                        catch (GithubAuthenticationException | GithubStatusCodeException iOException) {
                            // empty catch block
                        }
                        urls.addAll(Stream.concat(streamAssociated, streamWatched).sorted(Comparator.comparing(GithubRepoBasic::getUserName).thenComparing(GithubRepoBasic::getName)).map(repo -> GithubRepositoryHostingService.this.myGitHelper.getRemoteUrl(server, repo.getUserName(), repo.getName())).collect(Collectors.toList()));
                    }
                    catch (Exception e) {
                        exceptions.add(new RepositoryListLoadingException("Cannot load repositories from GitHub", (Throwable)e));
                    }
                }
                return new RepositoryListLoader.Result(urls, exceptions);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "org/jetbrains/plugins/github/extensions/GithubRepositoryHostingService$1", "getAvailableRepositoriesFromMultipleSources"));
            }
        };
    }

    @Nullable
    public InteractiveGitHttpAuthDataProvider getInteractiveAuthDataProvider(@NotNull Project project, @NotNull String url) {
        if (project == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(1);
        }
        if (url == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(2);
        }
        return this.getProvider(project, url, null);
    }

    @Nullable
    public InteractiveGitHttpAuthDataProvider getInteractiveAuthDataProvider(@NotNull Project project, @NotNull String url, @NotNull String login) {
        if (project == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(3);
        }
        if (url == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(4);
        }
        if (login == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(5);
        }
        return this.getProvider(project, url, login);
    }

    @Nullable
    private InteractiveGitHttpAuthDataProvider getProvider(@NotNull Project project, @NotNull String url, @Nullable String login) {
        Set<GithubAccount> potentialAccounts;
        if (project == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(6);
        }
        if (url == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(7);
        }
        if (!(potentialAccounts = this.myAuthDataProvider.getSuitableAccounts(project, url, login)).isEmpty()) {
            return new InteractiveSelectGithubAccountHttpAuthDataProvider(project, potentialAccounts, this.myAuthenticationManager);
        }
        if (GithubServerPath.DEFAULT_SERVER.matches(url)) {
            return new InteractiveCreateGithubAccountHttpAuthDataProvider(project, this.myAuthenticationManager, GithubServerPath.DEFAULT_SERVER, login);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "login";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/github/extensions/GithubRepositoryHostingService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getRepositoryListLoader";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getInteractiveAuthDataProvider";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

