/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.changes;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.EventDispatcher;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHCommit;
import org.jetbrains.plugins.github.api.data.GHGitActor;
import org.jetbrains.plugins.github.pullrequest.ui.SimpleEventListener;
import org.jetbrains.plugins.github.pullrequest.ui.changes.GHPRChangesModel;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002#$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R4\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010RL\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\t2\u001a\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R!\u0010\u0016\u001a\u0015\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00180\u00180\u0017\u00a2\u0006\u0002\b\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRChangesModelImpl;", "Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRChangesModel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "_changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "_commits", "", "Lorg/jetbrains/plugins/github/api/data/GHCommit;", "value", "changes", "getChanges", "()Ljava/util/List;", "setChanges", "(Ljava/util/List;)V", "commits", "getCommits", "()Ljava/util/Map;", "setCommits", "(Ljava/util/Map;)V", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/github/pullrequest/ui/SimpleEventListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "addStateChangesListener", "", "listener", "Lkotlin/Function0;", "buildChangesTree", "Ljavax/swing/tree/DefaultTreeModel;", "grouping", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "CommitTagBrowserNode", "MyTreeModelBuilder", "intellij.vcs.github"})
public final class GHPRChangesModelImpl
implements GHPRChangesModel {
    private final EventDispatcher<SimpleEventListener> eventDispatcher;
    private Map<GHCommit, ? extends List<? extends Change>> _commits;
    private List<? extends Change> _changes;
    private final Project project;

    @Override
    @Nullable
    public Map<GHCommit, List<Change>> getCommits() {
        return this._commits;
    }

    @Override
    public void setCommits(@Nullable Map<GHCommit, ? extends List<? extends Change>> value) {
        this._commits = value;
        this._changes = null;
        ((SimpleEventListener)this.eventDispatcher.getMulticaster()).eventOccurred();
    }

    @Override
    @Nullable
    public List<Change> getChanges() {
        return this._changes;
    }

    @Override
    public void setChanges(@Nullable List<? extends Change> value) {
        this._changes = value;
        this._commits = null;
        ((SimpleEventListener)this.eventDispatcher.getMulticaster()).eventOccurred();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DefaultTreeModel buildChangesTree(@NotNull ChangesGroupingPolicyFactory grouping) {
        Intrinsics.checkParameterIsNotNull((Object)grouping, (String)"grouping");
        MyTreeModelBuilder builder = new MyTreeModelBuilder(this.project, grouping);
        if (this.getChanges() != null) {
            List<Change> list2 = this.getChanges();
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)builder.setChanges(list2, null), (String)"builder.setChanges(changes!!, null)");
        } else if (this.getCommits() != null) {
            Map<GHCommit, List<Change>> map2 = this.getCommits();
            if (map2 == null) {
                Intrinsics.throwNpe();
            }
            Object object = map2;
            boolean bl = false;
            Iterator<Map.Entry<GHCommit, List<Change>>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void commit;
                Map.Entry<GHCommit, List<Change>> entry;
                Map.Entry<GHCommit, List<Change>> entry2 = entry = iterator.next();
                boolean bl2 = false;
                object = entry2.getKey();
                entry2 = entry;
                bl2 = false;
                List<Change> changes = entry2.getValue();
                builder.addCommit((GHCommit)commit, changes);
            }
        }
        DefaultTreeModel defaultTreeModel = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)defaultTreeModel, (String)"builder.build()");
        return defaultTreeModel;
    }

    @Override
    public void addStateChangesListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        SimpleEventListener.Companion.addListener(this.eventDispatcher, listener);
    }

    public GHPRChangesModelImpl(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        EventDispatcher eventDispatcher = EventDispatcher.create(SimpleEventListener.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)eventDispatcher, (String)"EventDispatcher.create(S\u2026ventListener::class.java)");
        this.eventDispatcher = eventDispatcher;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRChangesModelImpl$MyTreeModelBuilder;", "Lcom/intellij/openapi/vcs/changes/ui/TreeModelBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "grouping", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;)V", "addCommit", "", "commit", "Lorg/jetbrains/plugins/github/api/data/GHCommit;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "intellij.vcs.github"})
    private static final class MyTreeModelBuilder
    extends TreeModelBuilder {
        public final void addCommit(@NotNull GHCommit commit, @NotNull List<? extends Change> changes) {
            Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
            Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
            CommitTagBrowserNode parentNode = new CommitTagBrowserNode(commit);
            parentNode.markAsHelperNode();
            MutableTreeNode mutableTreeNode = (MutableTreeNode)((Object)parentNode);
            MutableTreeNode mutableTreeNode2 = (MutableTreeNode)this.myRoot;
            ChangesBrowserNode changesBrowserNode = this.myRoot;
            Intrinsics.checkExpressionValueIsNotNull((Object)changesBrowserNode, (String)"myRoot");
            this.myModel.insertNodeInto(mutableTreeNode, mutableTreeNode2, changesBrowserNode.getChildCount());
            for (Change change : changes) {
                this.insertChangeNode(change, parentNode, this.createChangeNode(change, null));
            }
        }

        public MyTreeModelBuilder(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)grouping, (String)"grouping");
            super(project, grouping);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u0013\u0010\u0012\u001a\u00070\t\u00a2\u0006\u0002\b\u0013*\u0004\u0018\u00010\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\t*\u0004\u0018\u00010\u0014H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRChangesModelImpl$CommitTagBrowserNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "", "commit", "Lorg/jetbrains/plugins/github/api/data/GHCommit;", "(Lorg/jetbrains/plugins/github/api/data/GHCommit;)V", "getCommit", "()Lorg/jetbrains/plugins/github/api/data/GHCommit;", "getTextPresentation", "", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "getDate", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/plugins/github/api/data/GHGitActor;", "getName", "intellij.vcs.github"})
    private static final class CommitTagBrowserNode
    extends ChangesBrowserNode<Object> {
        @NotNull
        private final GHCommit commit;

        public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
            Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
            renderer.setIcon(AllIcons.Vcs.CommitNode);
            renderer.append(this.commit.getMessageHeadlineHTML(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            renderer.append(" by " + this.getName(this.commit.getAuthor()) + ' ' + "on " + this.getDate(this.commit.getAuthor()), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            String tooltip = "commit " + this.commit.getOid() + '\n' + "Author: " + this.getName(this.commit.getAuthor()) + '\n' + "Date: " + this.getDate(this.commit.getAuthor()) + "\n\n" + this.commit.getMessageHeadlineHTML() + "\n\n" + this.commit.getMessageBodyHTML();
            renderer.setToolTipText(XmlStringUtil.escapeString((String)tooltip));
        }

        private final String getName(@Nullable GHGitActor $this$getName) {
            Object object = $this$getName;
            if (object == null || (object = ((GHGitActor)object).getName()) == null) {
                object = "unknown";
            }
            return object;
        }

        private final String getDate(@Nullable GHGitActor $this$getDate) {
            Object object;
            block3: {
                block2: {
                    object = $this$getDate;
                    if (object == null || (object = ((GHGitActor)object).getDate()) == null) break block2;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    object = DateFormatUtil.formatDateTime((Date)it);
                    if (object != null) break block3;
                }
                object = "unknown";
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this?.date?.let { DateFo\u2026teTime(it) } ?: \"unknown\"");
            return object;
        }

        @NotNull
        public String getTextPresentation() {
            return this.commit.getMessageHeadlineHTML();
        }

        @NotNull
        public final GHCommit getCommit() {
            return this.commit;
        }

        public CommitTagBrowserNode(@NotNull GHCommit commit) {
            Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
            super((Object)commit);
            this.commit = commit;
        }
    }
}

