/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui.cloneDialog;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogExtension;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogExtensionComponent;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogExtensionStatusLine;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountInformationProvider;
import org.jetbrains.plugins.github.ui.cloneDialog.GHCloneDialogExtensionComponent;
import org.jetbrains.plugins.github.util.CachingGithubUserAvatarLoader;
import org.jetbrains.plugins.github.util.GithubImageResizer;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/ui/cloneDialog/GHCloneDialogExtension;", "Lcom/intellij/openapi/vcs/ui/cloneDialog/VcsCloneDialogExtension;", "()V", "authenticationManager", "Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "createMainComponent", "Lcom/intellij/openapi/vcs/ui/cloneDialog/VcsCloneDialogExtensionComponent;", "project", "Lcom/intellij/openapi/project/Project;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "getAdditionalStatusLines", "", "Lcom/intellij/openapi/vcs/ui/cloneDialog/VcsCloneDialogExtensionStatusLine;", "getIcon", "Ljavax/swing/Icon;", "getName", "", "intellij.vcs.github"})
public final class GHCloneDialogExtension
implements VcsCloneDialogExtension {
    private final GithubAuthenticationManager authenticationManager = GithubAuthenticationManager.Companion.getInstance();

    @NotNull
    public String getName() {
        return "GitHub";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Vcs.Vendors.Github;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.Vcs.Vendors.Github");
        return icon;
    }

    @NotNull
    public List<VcsCloneDialogExtensionStatusLine> getAdditionalStatusLines() {
        if (!this.authenticationManager.hasAccounts()) {
            return CollectionsKt.listOf((Object)VcsCloneDialogExtensionStatusLine.Companion.greyText("No accounts"));
        }
        ArrayList<VcsCloneDialogExtensionStatusLine> list2 = new ArrayList<VcsCloneDialogExtensionStatusLine>();
        for (GithubAccount account : this.authenticationManager.getAccounts()) {
            String string;
            GithubServerPath githubServerPath = account.getServer();
            Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"account.server");
            if (githubServerPath.isGithubDotCom()) {
                string = account.getName();
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                GithubServerPath githubServerPath2 = account.getServer();
                Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath2, (String)"account.server");
                string = stringBuilder.append(githubServerPath2.getHost()).append('/').append(account.getName()).toString();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (account.server.isGit\u2026r.host}/${account.name}\")");
            String accName = string;
            list2.add(VcsCloneDialogExtensionStatusLine.Companion.greyText(accName));
        }
        return list2;
    }

    @NotNull
    public VcsCloneDialogExtensionComponent createMainComponent(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        throw (Throwable)((Object)new AssertionError((Object)"Shouldn't be called"));
    }

    @NotNull
    public VcsCloneDialogExtensionComponent createMainComponent(@NotNull Project project, @NotNull ModalityState modalityState) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modalityState, (String)"modalityState");
        return new GHCloneDialogExtensionComponent(project, GithubAuthenticationManager.Companion.getInstance(), GithubApiRequestExecutorManager.Companion.getInstance(), GithubApiRequestExecutor.Factory.Companion.getInstance(), GithubAccountInformationProvider.Companion.getInstance(), CachingGithubUserAvatarLoader.Companion.getInstance(), GithubImageResizer.Companion.getInstance());
    }

    @Nls
    @Nullable
    public String getTooltip() {
        return VcsCloneDialogExtension.DefaultImpls.getTooltip((VcsCloneDialogExtension)this);
    }
}

