/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.detector.ngram.impl;

import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.intellij.grazie.detector.model.Language;
import com.intellij.grazie.detector.ngram.profiles.LanguageProfile;
import com.intellij.grazie.detector.utils.collections.array.OneOptimizedFloatArray;
import com.intellij.grazie.detector.utils.collections.array.OptimizedFloatArray;
import com.intellij.grazie.detector.utils.collections.ngram.NgramArray;
import com.intellij.grazie.detector.utils.collections.ngram.NgramArrayKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B'\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0011\u001a\u00020\u0012R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/grazie/detector/ngram/impl/NgramFrequencies;", "", "probabilities", "Lcom/carrotsearch/hppc/ObjectObjectHashMap;", "Lcom/intellij/grazie/detector/utils/collections/ngram/NgramArray;", "Lcom/intellij/grazie/detector/utils/collections/array/OptimizedFloatArray;", "languages", "", "Lcom/intellij/grazie/detector/model/Language;", "(Lcom/carrotsearch/hppc/ObjectObjectHashMap;Ljava/util/List;)V", "getLanguages", "()Ljava/util/List;", "getLanguage", "pos", "", "getProbabilities", "kotlin.jvm.PlatformType", "ngram", "", "Companion", "language-detector"})
public final class NgramFrequencies {
    private final ObjectObjectHashMap<NgramArray, OptimizedFloatArray> probabilities;
    @NotNull
    private final List<Language> languages;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Language getLanguage(int pos) {
        return this.languages.get(pos);
    }

    public final OptimizedFloatArray getProbabilities(@NotNull String ngram) {
        Intrinsics.checkParameterIsNotNull((Object)ngram, (String)"ngram");
        return (OptimizedFloatArray)this.probabilities.get((Object)NgramArrayKt.toNgramArray(ngram));
    }

    @NotNull
    public final List<Language> getLanguages() {
        return this.languages;
    }

    public NgramFrequencies(@NotNull ObjectObjectHashMap<NgramArray, OptimizedFloatArray> probabilities, @NotNull List<? extends Language> languages) {
        Intrinsics.checkParameterIsNotNull(probabilities, (String)"probabilities");
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        this.probabilities = probabilities;
        this.languages = languages;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u00a8\u0006\n"}, d2={"Lcom/intellij/grazie/detector/ngram/impl/NgramFrequencies$Companion;", "", "()V", "create", "Lcom/intellij/grazie/detector/ngram/impl/NgramFrequencies;", "profiles", "", "Lcom/intellij/grazie/detector/ngram/profiles/LanguageProfile;", "gramLengths", "", "language-detector"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NgramFrequencies create(@NotNull Collection<? extends LanguageProfile> profiles, @NotNull Collection<Integer> gramLengths) {
            Collection<Language> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void key;
            Intrinsics.checkParameterIsNotNull(profiles, (String)"profiles");
            Intrinsics.checkParameterIsNotNull(gramLengths, (String)"gramLengths");
            Collection<? extends LanguageProfile> collection2 = profiles;
            boolean bl = false;
            boolean bl2 = !collection2.isEmpty();
            bl = false;
            boolean bl3 = false;
            if (!bl2) {
                boolean bl4 = false;
                String string = "No language profiles provided!";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Collection<Integer> collection3 = gramLengths;
            bl = false;
            boolean bl5 = !collection3.isEmpty();
            bl = false;
            bl3 = false;
            if (!bl5) {
                boolean bl6 = false;
                String string = "No gram lengths provided!";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            HashMap probabilities = new HashMap();
            bl = false;
            for (LanguageProfile profile : (Iterable)profiles) {
                void index;
                Iterator<Integer> iterator = gramLengths.iterator();
                while (iterator.hasNext()) {
                    int gramLength = ((Number)iterator.next()).intValue();
                    boolean bl7 = profile.getGramLengths().contains(gramLength);
                    boolean bl8 = false;
                    boolean bl9 = false;
                    if (!bl7) {
                        boolean bl10 = false;
                        String string = "The language profile for " + (Object)((Object)profile.getLocale()) + " does not contain " + gramLength + "-grams!";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    Iterator<Map.Entry<String, Integer>> iterator2 = profile.iterateGrams(gramLength).iterator();
                    while (iterator2.hasNext()) {
                        void ngram;
                        Map.Entry<String, Integer> entry;
                        Map.Entry<String, Integer> entry2 = entry = iterator2.next();
                        boolean bl11 = false;
                        String string = entry2.getKey();
                        entry2 = entry;
                        bl11 = false;
                        int frequency = ((Number)entry2.getValue()).intValue();
                        float prob = (float)frequency / (float)profile.getNumGramOccurrences(ngram.length());
                        OneOptimizedFloatArray oneOptimizedFloatArray = probabilities.getOrDefault(ngram, new OneOptimizedFloatArray());
                        Intrinsics.checkExpressionValueIsNotNull((Object)oneOptimizedFloatArray, (String)"probabilities.getOrDefau\u2026OneOptimizedFloatArray())");
                        OptimizedFloatArray arr = oneOptimizedFloatArray;
                        arr = arr.set((int)index, prob, (byte)profiles.size());
                        ((Map)probabilities).put(ngram, arr);
                    }
                }
                ++index;
            }
            ObjectObjectHashMap optimized = new ObjectObjectHashMap(profiles.size(), 0.99);
            Object gramLength = probabilities;
            boolean bl12 = false;
            Iterator<Object> bl6 = gramLength.entrySet().iterator();
            while (bl6.hasNext()) {
                Map.Entry profile;
                Map.Entry entry = profile = (Map.Entry)bl6.next();
                boolean bl13 = false;
                gramLength = (String)entry.getKey();
                entry = profile;
                bl13 = false;
                OptimizedFloatArray value = (OptimizedFloatArray)entry.getValue();
                optimized.put((Object)NgramArrayKt.toNgramArray((String)key), (Object)value);
            }
            optimized.ensureCapacity(profiles.size());
            Iterable profile = profiles;
            ObjectObjectHashMap objectObjectHashMap = optimized;
            boolean $i$f$map = false;
            key = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LanguageProfile frequency = (LanguageProfile)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl14 = false;
                Language language = it.getLocale();
                collection.add(language);
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            ObjectObjectHashMap objectObjectHashMap2 = objectObjectHashMap;
            return new NgramFrequencies((ObjectObjectHashMap<NgramArray, OptimizedFloatArray>)objectObjectHashMap2, list);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

