/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css2;

import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;

public class CssClip
extends org.w3c.css.properties.css.CssClip {
    public static final CssIdent auto = CssIdent.getIdent("auto");

    public CssClip() {
    }

    public CssClip(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssValue val = expression.getValue();
        switch (val.getType()) {
            case 11: {
                CssFunction func = (CssFunction)val;
                String funcname = func.getName().toLowerCase();
                if (!funcname.equals("rect")) {
                    throw new InvalidParamException("shape", val, this.getPropertyName(), ac);
                }
                CssClip.checkShape(ac, func.getParameters(), this);
                this.value = val;
                break;
            }
            case 0: {
                if (inherit.equals(val)) {
                    this.value = inherit;
                    break;
                }
                if (auto.equals(val)) {
                    this.value = auto;
                    break;
                }
            }
            default: {
                throw new InvalidParamException("value", val, this.getPropertyName(), ac);
            }
        }
        expression.next();
    }

    public CssClip(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static void checkShape(ApplContext ac, CssExpression expression, CssProperty caller) throws InvalidParamException {
        if (expression.getCount() < 4) {
            throw new InvalidParamException("few-value", caller.getPropertyName(), ac);
        }
        if (expression.getCount() > 4) {
            throw new InvalidParamException("unrecognize", ac);
        }
        char firstop = expression.getOperator();
        if (firstop == ' ') {
            ac.getFrame().addWarning("shape-separator");
        }
        for (int i = 0; i < 4; ++i) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    val.getLength();
                }
                case 6: {
                    break;
                }
                case 0: {
                    if (auto.equals(val)) break;
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
            }
            expression.next();
            if (op == firstop && (op == ',' || op == ' ') || expression.end()) continue;
            throw new InvalidParamException("shape-separator", new Character(op).toString(), ac);
        }
    }
}

