/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt;

import ca.odell.glazedlists.impl.adt.SparseListNode;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;

public final class SparseList
extends AbstractList {
    private SparseListNode root = null;
    private int size = 0;
    private int treeSize = 0;

    public int size() {
        return this.size;
    }

    public void add(int index, Object value) {
        if (value == null) {
            this.addNulls(index, 1);
        } else if (this.root != null) {
            if (index >= this.treeSize) {
                int movingNulls = index - this.treeSize;
                this.size -= movingNulls;
                this.root.insertAtEnd(value, movingNulls);
                this.treeSizeChanged();
            } else {
                this.root.insert(index, value);
                this.treeSizeChanged();
            }
        } else {
            this.root = new SparseListNode(this, null, value, index);
            this.treeSize = index + 1;
            ++this.size;
        }
    }

    public void addNulls(int index, int length) {
        this.size += length;
        if (this.root != null && index < this.treeSize) {
            this.root.insertEmptySpace(index, length);
            this.treeSize += length;
        }
    }

    public Object get(int index) {
        SparseListNode node = this.getNode(index);
        if (node == null) {
            return null;
        }
        return node.getValue();
    }

    public SparseListNode getNode(int index) {
        if (this.root != null && index < this.treeSize) {
            return this.root.getNode(index);
        }
        return null;
    }

    public Object set(int index, Object value) {
        if (this.root != null && index < this.treeSize) {
            Object returnValue = this.root.set(index, value);
            this.treeSizeChanged();
            return returnValue;
        }
        if (value == null) {
            return null;
        }
        --this.size;
        this.add(index, value);
        return null;
    }

    public Object remove(int index) {
        if (this.root != null && index < this.treeSize) {
            Object returnValue = this.root.remove(index);
            this.treeSizeChanged();
            return returnValue;
        }
        --this.size;
        return null;
    }

    public void clear() {
        this.size = 0;
        this.root = null;
    }

    void setRootNode(SparseListNode root) {
        this.root = root;
        if (root == null) {
            this.size -= this.treeSize;
            this.treeSize = 0;
        }
    }

    void treeSizeChanged() {
        this.size -= this.treeSize;
        this.treeSize = this.root != null ? this.root.size() : 0;
        this.size += this.treeSize;
    }

    public Iterator iterator() {
        if (this.size == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new SparseListNode.SparseListIterator(this, this.root);
    }

    public void printDebug() {
        System.out.println(this.root.toString());
    }
}

