/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.ProtocolMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HandshakeMessageSerializer<T extends HandshakeMessage>
extends ProtocolMessageSerializer<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final T msg;

    public HandshakeMessageSerializer(T message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    private void writeType() {
        this.appendByte((Byte)((HandshakeMessage)this.msg).getType().getValue());
        LOGGER.debug("Type: " + ((HandshakeMessage)this.msg).getType().getValue());
    }

    private void writeLength() {
        this.appendInt((Integer)((HandshakeMessage)this.msg).getLength().getValue(), 3);
        LOGGER.debug("Length: " + ((HandshakeMessage)this.msg).getLength().getValue());
    }

    @Override
    public final byte[] serializeProtocolMessageContent() {
        this.writeType();
        this.writeLength();
        this.serializeHandshakeMessageContent();
        return this.getAlreadySerialized();
    }

    public abstract byte[] serializeHandshakeMessageContent();

    protected boolean hasExtensionLengthField() {
        return ((HandshakeMessage)this.msg).getExtensionsLength() != null;
    }

    protected void writeExtensionLength() {
        this.appendInt((Integer)((HandshakeMessage)this.msg).getExtensionsLength().getValue(), 2);
        LOGGER.debug("ExtensionLength: " + ((HandshakeMessage)this.msg).getExtensionsLength().getValue());
    }

    protected boolean hasExtensions() {
        return ((HandshakeMessage)this.msg).getExtensionBytes() != null;
    }

    protected void writeExtensionBytes() {
        this.appendBytes((byte[])((HandshakeMessage)this.msg).getExtensionBytes().getValue());
        LOGGER.debug("ExtensionBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])((HandshakeMessage)this.msg).getExtensionBytes().getValue())));
    }
}

