/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.util.CheckEmptyTagInspection;
import com.intellij.xml.util.CollapseTagIntention;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CheckTagEmptyBodyInspection
extends XmlSuppressableInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CheckTagEmptyBodyInspection.$$$reportNull$$$0(0);
        }
        return new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                ASTNode node;
                ASTNode child;
                if (!CheckEmptyTagInspection.isTagWithEmptyEndNotAllowed(tag) && (child = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode())) != null && (node = child.getTreeNext()) != null && node.getElementType() == XmlTokenType.XML_END_TAG_START) {
                    holder.registerProblem((PsiElement)tag, XmlAnalysisBundle.message((String)"xml.inspections.tag.empty.body", (Object[])new Object[0]), new LocalQuickFix[]{CheckTagEmptyBodyInspection.isCollapsibleTag(tag) ? new Fix(tag) : null});
                }
            }
        };
    }

    static boolean isCollapsibleTag(XmlTag tag) {
        String name = StringUtil.toLowerCase((String)tag.getName());
        return tag.getLanguage() == XMLLanguage.INSTANCE || "link".equals(name) || "br".equals(name) || "meta".equals(name) || "img".equals(name) || "input".equals(name) || "hr".equals(name) || XmlExtension.isCollapsible(tag);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "CheckTagEmptyBody";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/xml/util/CheckTagEmptyBodyInspection", "buildVisitor"));
    }

    public static class Fix
    extends CollapseTagIntention {
        private final SmartPsiElementPointer<XmlTag> myPointer;

        public Fix(XmlTag tag) {
            this.myPointer = SmartPointerManager.getInstance((Project)tag.getProject()).createSmartPsiElementPointer((PsiElement)tag);
        }

        @Override
        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            XmlTag tag;
            if (project == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if ((tag = (XmlTag)this.myPointer.getElement()) == null) {
                return;
            }
            Fix.applyFix(project, (PsiElement)tag);
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                Fix.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/xml/util/CheckTagEmptyBodyInspection$Fix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invoke";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

