/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.validations;

import com.intellij.json.JsonBundle;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaAnnotatorChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonValidationError;

public class NumericValidation
implements JsonSchemaValidation {
    public static final NumericValidation INSTANCE = new NumericValidation();

    private static void checkNumber(PsiElement propValue, JsonSchemaObject schema, JsonSchemaType schemaType, JsonValidationHost consumer) {
        double leftOver;
        Number multipleOf;
        Number value;
        String valueText = JsonSchemaAnnotatorChecker.getValue(propValue, schema);
        if (valueText == null) {
            return;
        }
        if (JsonSchemaType._integer.equals((Object)schemaType)) {
            value = JsonSchemaType.getIntegerValue(valueText);
            if (value == null) {
                consumer.error(JsonBundle.message("schema.validation.integer.expected", new Object[0]), propValue, JsonValidationError.FixableIssueKind.TypeMismatch, new JsonValidationError.TypeMismatchIssueData(new JsonSchemaType[]{schemaType}), JsonErrorPriority.TYPE_MISMATCH);
                return;
            }
        } else {
            try {
                value = Double.valueOf(valueText);
            }
            catch (NumberFormatException e) {
                if (!JsonSchemaType._string_number.equals((Object)schemaType)) {
                    consumer.error(JsonBundle.message("schema.validation.number.expected", new Object[0]), propValue, JsonValidationError.FixableIssueKind.TypeMismatch, new JsonValidationError.TypeMismatchIssueData(new JsonSchemaType[]{schemaType}), JsonErrorPriority.TYPE_MISMATCH);
                }
                return;
            }
        }
        if ((multipleOf = schema.getMultipleOf()) != null && (leftOver = value.doubleValue() % multipleOf.doubleValue()) > 1.0E-6) {
            String multipleOfValue = String.valueOf(Math.abs(multipleOf.doubleValue() - (double)multipleOf.intValue()) < 1.0E-6 ? (Number)multipleOf.intValue() : (Number)multipleOf);
            consumer.error(JsonBundle.message("schema.validation.not.multiple.of", multipleOfValue), propValue, JsonErrorPriority.LOW_PRIORITY);
            return;
        }
        NumericValidation.checkMinimum(schema, value, propValue, consumer);
        NumericValidation.checkMaximum(schema, value, propValue, consumer);
    }

    private static void checkMaximum(JsonSchemaObject schema, Number value, PsiElement propertyValue, JsonValidationHost consumer) {
        Number maximum;
        Number exclusiveMaximumNumber = schema.getExclusiveMaximumNumber();
        if (exclusiveMaximumNumber != null) {
            double doubleValue = exclusiveMaximumNumber.doubleValue();
            if (value.doubleValue() >= doubleValue) {
                consumer.error(JsonBundle.message("schema.validation.greater.than.exclusive.maximum", exclusiveMaximumNumber), propertyValue, JsonErrorPriority.LOW_PRIORITY);
            }
        }
        if ((maximum = schema.getMaximum()) == null) {
            return;
        }
        boolean isExclusive = Boolean.TRUE.equals(schema.isExclusiveMaximum());
        double doubleValue = maximum.doubleValue();
        if (isExclusive) {
            if (value.doubleValue() >= doubleValue) {
                consumer.error(JsonBundle.message("schema.validation.greater.than.exclusive.maximum", maximum), propertyValue, JsonErrorPriority.LOW_PRIORITY);
            }
        } else if (value.doubleValue() > doubleValue) {
            consumer.error(JsonBundle.message("schema.validation.greater.than.maximum", maximum), propertyValue, JsonErrorPriority.LOW_PRIORITY);
        }
    }

    private static void checkMinimum(JsonSchemaObject schema, Number value, PsiElement propertyValue, JsonValidationHost consumer) {
        Number minimum;
        Number exclusiveMinimumNumber = schema.getExclusiveMinimumNumber();
        if (exclusiveMinimumNumber != null) {
            double doubleValue = exclusiveMinimumNumber.doubleValue();
            if (value.doubleValue() <= doubleValue) {
                consumer.error(JsonBundle.message("schema.validation.less.than.exclusive.minimum", exclusiveMinimumNumber), propertyValue, JsonErrorPriority.LOW_PRIORITY);
            }
        }
        if ((minimum = schema.getMinimum()) == null) {
            return;
        }
        boolean isExclusive = Boolean.TRUE.equals(schema.isExclusiveMinimum());
        double doubleValue = minimum.doubleValue();
        if (isExclusive) {
            if (value.doubleValue() <= doubleValue) {
                consumer.error(JsonBundle.message("schema.validation.less.than.exclusive.minimum", minimum), propertyValue, JsonErrorPriority.LOW_PRIORITY);
            }
        } else if (value.doubleValue() < doubleValue) {
            consumer.error(JsonBundle.message("schema.validation.less.than.minimum", minimum), propertyValue, JsonErrorPriority.LOW_PRIORITY);
        }
    }

    @Override
    public void validate(JsonValueAdapter propValue, JsonSchemaObject schema, JsonSchemaType schemaType, JsonValidationHost consumer, JsonComplianceCheckerOptions options) {
        NumericValidation.checkNumber(propValue.getDelegate(), schema, schemaType, consumer);
    }
}

