/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/editorconfig/language/codeinsight/completion/EditorConfigAppendInsertionHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "suffix", "", "shouldMoveCaret", "", "shouldAutopopup", "(Ljava/lang/String;ZZ)V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "intellij.editorconfig"})
public final class EditorConfigAppendInsertionHandler
implements InsertHandler<LookupElement> {
    private final String suffix;
    private final boolean shouldMoveCaret;
    private final boolean shouldAutopopup;

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Document document = context.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"context.document");
        Document document2 = document;
        Editor editor = context.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"context.editor");
        Editor editor2 = editor;
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        CaretModel caretModel2 = caretModel;
        int caretOffset = caretModel2.getOffset();
        document2.insertString(caretOffset, (CharSequence)this.suffix);
        if (this.shouldMoveCaret) {
            caretModel2.moveToOffset(caretOffset + this.suffix.length());
            editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
        editor2.getSelectionModel().removeSelection();
        if (this.shouldAutopopup) {
            Project project = editor2.getProject();
            if (project == null) {
                Intrinsics.throwNpe();
            }
            AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor2);
        }
    }

    public EditorConfigAppendInsertionHandler(@NotNull String suffix, boolean shouldMoveCaret, boolean shouldAutopopup) {
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        this.suffix = suffix;
        this.shouldMoveCaret = shouldMoveCaret;
        this.shouldAutopopup = shouldAutopopup;
    }

    public /* synthetic */ EditorConfigAppendInsertionHandler(String string, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        this(string, bl, bl2);
    }
}

