/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.generic.GenericRepository;
import com.intellij.tasks.generic.GenericTask;
import com.intellij.tasks.generic.HighlightedSelectorsTable;
import com.intellij.tasks.generic.ResponseHandler;
import com.intellij.tasks.generic.Selector;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.XCollection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SelectorBasedResponseHandler
extends ResponseHandler {
    private static final Logger LOG = Logger.getInstance(SelectorBasedResponseHandler.class);
    @NonNls
    protected static final String TASKS = "tasks";
    @NonNls
    protected static final String SUMMARY = "summary";
    @NonNls
    protected static final String DESCRIPTION = "description";
    @NonNls
    protected static final String ISSUE_URL = "issueUrl";
    @NonNls
    protected static final String CLOSED = "closed";
    @NonNls
    protected static final String UPDATED = "updated";
    @NonNls
    protected static final String CREATED = "created";
    @NonNls
    protected static final String SINGLE_TASK_ID = "singleTask-id";
    @NonNls
    protected static final String SINGLE_TASK_SUMMARY = "singleTask-summary";
    @NonNls
    protected static final String SINGLE_TASK_DESCRIPTION = "singleTask-description";
    @NonNls
    protected static final String SINGLE_TASK_ISSUE_URL = "singleTask-issueUrl";
    @NonNls
    protected static final String SINGLE_TASK_CLOSED = "singleTask-closed";
    @NonNls
    protected static final String SINGLE_TASK_UPDATED = "singleTask-updated";
    @NonNls
    protected static final String SINGLE_TASK_CREATED = "singleTask-created";
    @NonNls
    protected static final String ID = "id";
    protected LinkedHashMap<String, Selector> mySelectors = new LinkedHashMap();

    protected SelectorBasedResponseHandler() {
    }

    protected SelectorBasedResponseHandler(GenericRepository repository) {
        super(repository);
        this.setSelectors(ContainerUtil.newArrayList((Object[])new Selector[]{new Selector(TASKS), new Selector(ID), new Selector(SUMMARY), new Selector(DESCRIPTION), new Selector(UPDATED), new Selector(CREATED), new Selector(CLOSED), new Selector(ISSUE_URL), new Selector(SINGLE_TASK_ID), new Selector(SINGLE_TASK_SUMMARY), new Selector(SINGLE_TASK_DESCRIPTION), new Selector(SINGLE_TASK_UPDATED), new Selector(SINGLE_TASK_CREATED), new Selector(SINGLE_TASK_CLOSED), new Selector(SINGLE_TASK_ISSUE_URL)}));
    }

    @XCollection(propertyElementName="selectors")
    @NotNull
    public List<Selector> getSelectors() {
        return new ArrayList<Selector>(this.mySelectors.values());
    }

    public void setSelectors(@NotNull List<Selector> selectors) {
        if (selectors == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(0);
        }
        this.mySelectors.clear();
        for (Selector selector : selectors) {
            this.mySelectors.put(selector.getName(), selector);
        }
    }

    @NotNull
    protected Selector getSelector(@NotNull String name) {
        if (name == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(1);
        }
        Selector selector = this.mySelectors.get(name);
        if (selector == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(2);
        }
        return selector;
    }

    @NotNull
    protected String getSelectorPath(@NotNull String name) {
        if (name == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(3);
        }
        Selector s = this.getSelector(name);
        String string = s.getPath();
        if (string == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public JComponent getConfigurationComponent(@NotNull Project project) {
        if (project == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(5);
        }
        FileType fileType = this.getResponseType().getSelectorFileType();
        HighlightedSelectorsTable table = new HighlightedSelectorsTable(fileType, project, this.getSelectors());
        return new JBScrollPane((Component)((Object)table));
    }

    @Override
    public SelectorBasedResponseHandler clone() {
        SelectorBasedResponseHandler clone = (SelectorBasedResponseHandler)super.clone();
        clone.mySelectors = new LinkedHashMap(this.mySelectors.size());
        for (Selector selector : this.mySelectors.values()) {
            clone.mySelectors.put(selector.getName(), selector.clone());
        }
        return clone;
    }

    @Override
    public boolean isConfigured() {
        Selector idSelector = this.getSelector(ID);
        if (StringUtil.isEmpty((String)idSelector.getPath())) {
            return false;
        }
        Selector summarySelector = this.getSelector(SUMMARY);
        return !StringUtil.isEmpty((String)summarySelector.getPath()) || this.myRepository.getDownloadTasksInSeparateRequests();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SelectorBasedResponseHandler)) {
            return false;
        }
        SelectorBasedResponseHandler handler = (SelectorBasedResponseHandler)o;
        return this.mySelectors.equals(handler.mySelectors);
    }

    public int hashCode() {
        return this.mySelectors.hashCode();
    }

    @Override
    public final Task @NotNull [] parseIssues(@NotNull String response, int max) throws Exception {
        if (response == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmpty((String)this.getSelectorPath(TASKS)) || StringUtil.isEmpty((String)this.getSelectorPath(ID)) || StringUtil.isEmpty((String)this.getSelectorPath(SUMMARY)) && !this.myRepository.getDownloadTasksInSeparateRequests()) {
            throw new Exception("Selectors 'tasks', 'id' and 'summary' are mandatory");
        }
        List<Object> tasks = this.selectTasksList(response, max);
        LOG.debug(String.format("Total %d tasks extracted from response", tasks.size()));
        ArrayList<GenericTask> result = new ArrayList<GenericTask>(tasks.size());
        for (Object context : tasks) {
            GenericTask task;
            String id = this.selectString(this.getSelector(ID), context);
            if (this.myRepository.getDownloadTasksInSeparateRequests()) {
                task = new GenericTask(id, "", (TaskRepository)this.myRepository);
            } else {
                Date created;
                Date updated;
                Boolean closed;
                String issueUrl;
                String summary = this.selectString(this.getSelector(SUMMARY), context);
                assert (id != null && summary != null);
                task = new GenericTask(id, summary, (TaskRepository)this.myRepository);
                String description = this.selectString(this.getSelector(DESCRIPTION), context);
                if (description != null) {
                    task.setDescription(description);
                }
                if ((issueUrl = this.selectString(this.getSelector(ISSUE_URL), context)) != null) {
                    task.setIssueUrl(issueUrl);
                }
                if ((closed = this.selectBoolean(this.getSelector(CLOSED), context)) != null) {
                    task.setClosed(closed);
                }
                if ((updated = this.selectDate(this.getSelector(UPDATED), context)) != null) {
                    task.setUpdated(updated);
                }
                if ((created = this.selectDate(this.getSelector(CREATED), context)) != null) {
                    task.setCreated(created);
                }
            }
            result.add(task);
        }
        Task[] taskArray = result.toArray(Task.EMPTY_ARRAY);
        if (taskArray == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(7);
        }
        return taskArray;
    }

    @Nullable
    private Date selectDate(@NotNull Selector selector, @NotNull Object context) throws Exception {
        String s;
        if (selector == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(8);
        }
        if (context == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(9);
        }
        if ((s = this.selectString(selector, context)) == null) {
            return null;
        }
        return TaskUtil.parseDate((String)s);
    }

    @Nullable
    protected Boolean selectBoolean(@NotNull Selector selector, @NotNull Object context) throws Exception {
        String s;
        if (selector == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(10);
        }
        if (context == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(11);
        }
        if ((s = this.selectString(selector, context)) == null) {
            return null;
        }
        if ((s = StringUtil.toLowerCase((String)s.trim())).equals("true")) {
            return true;
        }
        if (s.equals("false")) {
            return false;
        }
        throw new Exception(String.format("Expression '%s' should match boolean value. Got '%s' instead", selector.getName(), s));
    }

    @NotNull
    protected abstract List<Object> selectTasksList(@NotNull String var1, int var2) throws Exception;

    @Nullable
    protected abstract String selectString(@NotNull Selector var1, @NotNull Object var2) throws Exception;

    @Override
    @Nullable
    public final Task parseIssue(@NotNull String response) throws Exception {
        Date created;
        Date updated;
        Boolean closed;
        String issueUrl;
        if (response == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(12);
        }
        if (StringUtil.isEmpty((String)this.getSelectorPath(SINGLE_TASK_ID)) || StringUtil.isEmpty((String)this.getSelectorPath(SINGLE_TASK_SUMMARY))) {
            throw new Exception("Selectors 'singleTask-id' and 'singleTask-summary' are mandatory");
        }
        String id = this.selectString(this.getSelector(SINGLE_TASK_ID), response);
        String summary = this.selectString(this.getSelector(SINGLE_TASK_SUMMARY), response);
        assert (id != null && summary != null);
        GenericTask task = new GenericTask(id, summary, (TaskRepository)this.myRepository);
        String description = this.selectString(this.getSelector(SINGLE_TASK_DESCRIPTION), response);
        if (description != null) {
            task.setDescription(description);
        }
        if ((issueUrl = this.selectString(this.getSelector(SINGLE_TASK_ISSUE_URL), response)) != null) {
            task.setIssueUrl(issueUrl);
        }
        if ((closed = this.selectBoolean(this.getSelector(SINGLE_TASK_CLOSED), response)) != null) {
            task.setClosed(closed);
        }
        if ((updated = this.selectDate(this.getSelector(SINGLE_TASK_UPDATED), response)) != null) {
            task.setUpdated(updated);
        }
        if ((created = this.selectDate(this.getSelector(SINGLE_TASK_CREATED), response)) != null) {
            task.setCreated(created);
        }
        return task;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectors";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/generic/SelectorBasedResponseHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/generic/SelectorBasedResponseHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectorPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parseIssues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSelectors";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSelector";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSelectorPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseIssues";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "selectDate";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "selectBoolean";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseIssue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

