/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.application.options.colors.ColorAndFontDescriptionPanel;
import com.intellij.application.options.colors.CompositeColorDescriptionPanel;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.application.options.colors.RainbowAttributeDescriptor;
import com.intellij.application.options.colors.RainbowDescriptionPanel;
import com.intellij.application.options.colors.SimpleEditorPreview;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.RainbowColorSettingsPage;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CustomizedSwitcherPanel
extends CompositeColorDescriptionPanel {
    private final ColorSettingsPage myPage;
    private final PreviewPanel myPreviewPanel;

    CustomizedSwitcherPanel(@Nullable PreviewPanel previewPanel, @Nullable ColorSettingsPage page) {
        this.myPage = page;
        this.myPreviewPanel = previewPanel;
        this.addDescriptionPanel(new ColorAndFontDescriptionPanel(), (Condition<EditorSchemeAttributeDescriptor>)((Condition)it -> it instanceof ColorAndFontDescription));
        this.addDescriptionPanel(new RainbowDescriptionPanel(), (Condition<EditorSchemeAttributeDescriptor>)((Condition)it -> it instanceof RainbowAttributeDescriptor));
    }

    @Override
    public void reset(@NotNull EditorSchemeAttributeDescriptor descriptor2) {
        if (descriptor2 == null) {
            CustomizedSwitcherPanel.$$$reportNull$$$0(0);
        }
        super.reset(descriptor2);
        this.updatePreviewPanel(descriptor2);
    }

    @Override
    public void apply(@NotNull EditorSchemeAttributeDescriptor descriptor2, EditorColorsScheme scheme) {
        if (descriptor2 == null) {
            CustomizedSwitcherPanel.$$$reportNull$$$0(1);
        }
        super.apply(descriptor2, scheme);
        this.updatePreviewPanel(descriptor2);
    }

    protected void updatePreviewPanel(@NotNull EditorSchemeAttributeDescriptor descriptor2) {
        if (descriptor2 == null) {
            CustomizedSwitcherPanel.$$$reportNull$$$0(2);
        }
        if (!(this.myPreviewPanel instanceof SimpleEditorPreview) || !(this.myPage instanceof RainbowColorSettingsPage)) {
            return;
        }
        UIUtil.invokeAndWaitIfNeeded(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            SimpleEditorPreview simpleEditorPreview = (SimpleEditorPreview)this.myPreviewPanel;
            simpleEditorPreview.setupRainbow(descriptor2.getScheme(), (RainbowColorSettingsPage)this.myPage);
            simpleEditorPreview.updateView();
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "descriptor";
        objectArray2[1] = "com/intellij/application/options/colors/CustomizedSwitcherPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePreviewPanel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

