/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.PlatformIcons;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserSelector {
    private final ComboboxWithBrowseButton myBrowserComboWithBrowse;
    private MutableCollectionComboBoxModel<WebBrowser> myModel;

    public BrowserSelector() {
        this(true);
    }

    public BrowserSelector(boolean allowDefaultBrowser) {
        this((Condition<WebBrowser>)((Condition)browser2 -> allowDefaultBrowser || browser2 != null));
    }

    public BrowserSelector(@NotNull Condition<WebBrowser> browserCondition) {
        if (browserCondition == null) {
            BrowserSelector.$$$reportNull$$$0(0);
        }
        this.myModel = BrowserSelector.createBrowsersComboModel(browserCondition);
        this.myBrowserComboWithBrowse = new ComboboxWithBrowseButton((JComboBox)new ComboBox(this.myModel));
        this.myBrowserComboWithBrowse.addActionListener(e -> {
            WebBrowserManager browserManager = WebBrowserManager.getInstance();
            long modificationCount = browserManager.getModificationCount();
            ShowSettingsUtil.getInstance().editConfigurable((Component)this.myBrowserComboWithBrowse, (Configurable)new BrowserSettings());
            WebBrowser selectedItem = this.getSelected();
            if (modificationCount != browserManager.getModificationCount()) {
                this.myModel = BrowserSelector.createBrowsersComboModel(browserCondition);
                this.myBrowserComboWithBrowse.getComboBox().setModel(this.myModel);
            }
            if (selectedItem != null) {
                this.setSelected(selectedItem);
            }
        });
        this.myBrowserComboWithBrowse.getComboBox().setRenderer(SimpleListCellRenderer.create((label2, value2, index) -> {
            WebBrowser firstBrowser;
            Icon baseIcon = value2 == null ? ((firstBrowser = WebBrowserManager.getInstance().getFirstActiveBrowser()) == null ? PlatformIcons.WEB_ICON : firstBrowser.getIcon()) : value2.getIcon();
            label2.setIcon(this.myBrowserComboWithBrowse.isEnabled() ? baseIcon : IconLoader.getDisabledIcon((Icon)baseIcon));
            label2.setText(value2 != null ? value2.getName() : IdeBundle.message((String)"default", (Object[])new Object[0]));
        }));
    }

    public JComponent getMainComponent() {
        return this.myBrowserComboWithBrowse;
    }

    private static MutableCollectionComboBoxModel<WebBrowser> createBrowsersComboModel(@NotNull Condition<WebBrowser> browserCondition) {
        if (browserCondition == null) {
            BrowserSelector.$$$reportNull$$$0(1);
        }
        ArrayList<WebBrowser> list2 = new ArrayList<WebBrowser>();
        if (browserCondition.value(null)) {
            list2.add(null);
        }
        list2.addAll(WebBrowserManager.getInstance().getBrowsers(browserCondition));
        return new MutableCollectionComboBoxModel(list2);
    }

    @Nullable
    public WebBrowser getSelected() {
        return (WebBrowser)this.myModel.getSelected();
    }

    @Nullable
    public String getSelectedBrowserId() {
        WebBrowser browser2 = this.getSelected();
        return browser2 != null ? browser2.getId().toString() : null;
    }

    public void setSelected(@Nullable WebBrowser selectedItem) {
        this.myBrowserComboWithBrowse.getComboBox().setSelectedItem(selectedItem);
    }

    public boolean addAndSelect(@NotNull WebBrowser browser2) {
        if (browser2 == null) {
            BrowserSelector.$$$reportNull$$$0(2);
        }
        if (this.myModel.contains((Object)browser2)) {
            return false;
        }
        this.myModel.addItem((Object)browser2);
        return true;
    }

    public int getSize() {
        return this.myModel.getSize();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browserCondition";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/browsers/BrowserSelector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createBrowsersComboModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addAndSelect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

