/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.StubItem;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.actionSystem.impl.actionholder.ActionRef;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.JBMenu;
import com.intellij.ui.mac.foundation.NSDefaults;
import com.intellij.ui.plaf.beg.IdeaMenuUI;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.jetbrains.annotations.NotNull;

public final class ActionMenu
extends JBMenu {
    private static final boolean KEEP_MENU_HIERARCHY = SystemInfo.isMacSystemMenu && Registry.is((String)"keep.menu.hierarchy", (boolean)false);
    private final String myPlace;
    private DataContext myContext;
    private final ActionRef<ActionGroup> myGroup;
    private final PresentationFactory myPresentationFactory;
    private final Presentation myPresentation;
    private boolean myMnemonicEnabled;
    private MenuItemSynchronizer myMenuItemSynchronizer;
    private StubItem myStubItem;
    private final boolean myUseDarkIcons;
    private Disposable myDisposable;
    private JPopupMenu mySpecialMenu;

    public ActionMenu(DataContext context, @NotNull String place, ActionGroup group, PresentationFactory presentationFactory, boolean enableMnemonics, boolean useDarkIcons) {
        if (place == null) {
            ActionMenu.$$$reportNull$$$0(0);
        }
        this.myContext = context;
        this.myPlace = place;
        this.myGroup = ActionRef.fromAction(group);
        this.myPresentationFactory = presentationFactory;
        this.myPresentation = this.myPresentationFactory.getPresentation((AnAction)group);
        this.myMnemonicEnabled = enableMnemonics;
        this.myUseDarkIcons = useDarkIcons;
        this.updateUI();
        this.init();
        if (SystemInfo.isMacSystemMenu) {
            this.installSynchronizer();
        }
        this.getPopupMenu();
    }

    protected Graphics getComponentGraphics(Graphics graphics) {
        if (!(this.getParent() instanceof JMenuBar)) {
            return super.getComponentGraphics(graphics);
        }
        return JBSwingUtilities.runGlobalCGTransform((JComponent)((Object)this), (Graphics)super.getComponentGraphics(graphics));
    }

    public void updateContext(DataContext context) {
        this.myContext = context;
    }

    public AnAction getAnAction() {
        return this.myGroup.getAction();
    }

    public void addNotify() {
        super.addNotify();
        this.installSynchronizer();
    }

    private void installSynchronizer() {
        if (this.myMenuItemSynchronizer == null) {
            this.myMenuItemSynchronizer = new MenuItemSynchronizer();
            this.myGroup.getAction().addPropertyChangeListener((PropertyChangeListener)this.myMenuItemSynchronizer);
            this.myPresentation.addPropertyChangeListener((PropertyChangeListener)this.myMenuItemSynchronizer);
        }
    }

    public void removeNotify() {
        this.uninstallSynchronizer();
        super.removeNotify();
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
            this.myDisposable = null;
        }
    }

    private void uninstallSynchronizer() {
        if (this.myMenuItemSynchronizer != null) {
            this.myGroup.getAction().removePropertyChangeListener((PropertyChangeListener)this.myMenuItemSynchronizer);
            this.myPresentation.removePropertyChangeListener((PropertyChangeListener)this.myMenuItemSynchronizer);
            this.myMenuItemSynchronizer = null;
        }
    }

    public JPopupMenu getPopupMenu() {
        if (this.mySpecialMenu == null) {
            this.mySpecialMenu = new JBPopupMenu();
            this.mySpecialMenu.setInvoker((Component)((Object)this));
            this.popupListener = this.createWinListener(this.mySpecialMenu);
            ReflectionUtil.setField(JMenu.class, (Object)((Object)this), JPopupMenu.class, (String)"popupMenu", (Object)this.mySpecialMenu);
        }
        return super.getPopupMenu();
    }

    public void updateUI() {
        this.setUI(IdeaMenuUI.createUI((JComponent)((Object)this)));
        this.setFont(UIUtil.getMenuFont());
        JPopupMenu popupMenu = this.getPopupMenu();
        if (popupMenu != null) {
            popupMenu.updateUI();
        }
    }

    private void init() {
        boolean macSystemMenu = SystemInfo.isMacSystemMenu && this.myPlace.equals("MainMenu");
        this.myStubItem = macSystemMenu ? null : new StubItem();
        this.addStubItem();
        this.addMenuListener(new MenuListenerImpl());
        this.setBorderPainted(false);
        this.setVisible(this.myPresentation.isVisible());
        this.setEnabled(this.myPresentation.isEnabled());
        this.setText(this.myPresentation.getText());
        this.updateIcon();
        this.setMnemonicEnabled(this.myMnemonicEnabled);
    }

    private void addStubItem() {
        if (this.myStubItem != null) {
            this.add(this.myStubItem);
        }
    }

    public void setMnemonicEnabled(boolean enable) {
        this.myMnemonicEnabled = enable;
        this.setMnemonic(this.myPresentation.getMnemonic());
        this.setDisplayedMnemonicIndex(this.myPresentation.getDisplayedMnemonicIndex());
    }

    public void setDisplayedMnemonicIndex(int index) throws IllegalArgumentException {
        super.setDisplayedMnemonicIndex(this.myMnemonicEnabled ? index : -1);
    }

    public void setMnemonic(int mnemonic) {
        super.setMnemonic(this.myMnemonicEnabled ? mnemonic : 0);
    }

    private void updateIcon() {
        UISettings settings = UISettings.getInstanceOrNull();
        if (settings != null && settings.getShowIconsInMenus()) {
            Presentation presentation2 = this.myPresentation;
            Icon icon2 = presentation2.getIcon();
            if (SystemInfo.isMacSystemMenu && "MainMenu".equals(this.myPlace) && icon2 != null) {
                icon2 = IconLoader.getMenuBarIcon((Icon)icon2, (boolean)this.myUseDarkIcons);
            }
            this.setIcon(icon2);
            if (presentation2.getDisabledIcon() != null) {
                this.setDisabledIcon(presentation2.getDisabledIcon());
            } else {
                this.setDisabledIcon(icon2 == null ? null : IconLoader.getDisabledIcon((Icon)icon2));
            }
        }
    }

    public void menuSelectionChanged(boolean isIncluded) {
        super.menuSelectionChanged(isIncluded);
        ActionMenu.showDescriptionInStatusBar(isIncluded, (Component)((Object)this), this.myPresentation.getDescription());
    }

    public static void showDescriptionInStatusBar(boolean isIncluded, Component component2, String description) {
        StatusBar statusBar;
        IdeFrame frame = (IdeFrame)(component2 instanceof IdeFrame ? component2 : SwingUtilities.getAncestorOfClass(IdeFrame.class, component2));
        if (frame != null && (statusBar = frame.getStatusBar()) != null) {
            statusBar.setInfo(isIncluded ? description : null);
        }
    }

    public void clearItems() {
        if (SystemInfo.isMacSystemMenu && this.myPlace.equals("MainMenu")) {
            for (Component menuComponent : this.getMenuComponents()) {
                if (menuComponent instanceof ActionMenu) {
                    ((ActionMenu)((Object)menuComponent)).clearItems();
                    ((ActionMenu)((Object)menuComponent)).uninstallSynchronizer();
                    continue;
                }
                if (!(menuComponent instanceof ActionMenuItem) || SystemInfo.isMac) continue;
                ((ActionMenuItem)((Object)menuComponent)).setAccelerator(KeyStroke.getKeyStroke(61451, 0));
            }
        }
        this.removeAll();
        this.validate();
    }

    public void fillMenu() {
        DataContext context;
        if (this.myContext != null) {
            context = this.myContext;
        } else {
            DataManager dataManager = DataManager.getInstance();
            DataContext contextFromFocus = dataManager.getDataContext();
            context = contextFromFocus;
            if (PlatformDataKeys.CONTEXT_COMPONENT.getData(context) == null) {
                IdeFrame frame = (IdeFrame)ComponentUtil.getParentOfType(IdeFrame.class, (Component)((Object)this));
                context = dataManager.getDataContext(IdeFocusManager.getGlobalInstance().getLastFocusedFor((Window)frame));
            }
        }
        boolean isDarkMenu = SystemInfo.isMacSystemMenu && NSDefaults.isDarkMenuBar();
        Utils.fillMenu(this.myGroup.getAction(), (JComponent)((Object)this), this.myMnemonicEnabled, this.myPresentationFactory, context, this.myPlace, true, LaterInvocator.isInModalContext(), isDarkMenu);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/actionSystem/impl/ActionMenu", "<init>"));
    }

    private static class UsabilityHelper
    implements IdeEventQueue.EventDispatcher,
    AWTEventListener,
    Disposable {
        private Component myComponent;
        private Point myLastMousePoint;
        private Point myUpperTargetPoint;
        private Point myLowerTargetPoint;
        private SingleAlarm myCallbackAlarm = new SingleAlarm(() -> {
            Disposer.dispose((Disposable)this.myCallbackAlarm);
            this.myCallbackAlarm = null;
            if (this.myEventToRedispatch != null) {
                IdeEventQueue.getInstance().dispatchEvent(this.myEventToRedispatch);
            }
        }, 50, ModalityState.any(), (Disposable)this);
        private MouseEvent myEventToRedispatch;
        private long myLastEventTime = 0L;
        private boolean myInBounds = false;
        private SingleAlarm myCheckAlarm = new SingleAlarm(() -> {
            if (this.myLastEventTime > 0L && System.currentTimeMillis() - this.myLastEventTime > 1500L && !this.myInBounds && this.myCallbackAlarm != null && !this.myCallbackAlarm.isDisposed()) {
                this.myCallbackAlarm.request();
            }
            this.myCheckAlarm.request();
        }, 100, ModalityState.any(), (Disposable)this);

        private UsabilityHelper(Component component2) {
            this.myComponent = component2;
            PointerInfo info = MouseInfo.getPointerInfo();
            Point point = this.myLastMousePoint = info != null ? info.getLocation() : null;
            if (this.myLastMousePoint != null) {
                Toolkit.getDefaultToolkit().addAWTEventListener(this, 1L);
                IdeEventQueue.getInstance().addDispatcher(this, this);
            }
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            ComponentEvent componentEvent;
            Component component2;
            JPopupMenu popup2;
            if (event instanceof ComponentEvent && (popup2 = (JPopupMenu)ComponentUtil.getParentOfType(JPopupMenu.class, (Component)(component2 = (componentEvent = (ComponentEvent)event).getComponent()))) != null && popup2.getInvoker() == this.myComponent && popup2.isShowing()) {
                Rectangle bounds2 = popup2.getBounds();
                if (bounds2.isEmpty()) {
                    return;
                }
                bounds2.setLocation(popup2.getLocationOnScreen());
                if (this.myLastMousePoint.x < bounds2.x) {
                    this.myUpperTargetPoint = new Point(bounds2.x, bounds2.y);
                    this.myLowerTargetPoint = new Point(bounds2.x, bounds2.y + bounds2.height);
                }
                if (this.myLastMousePoint.x > bounds2.x + bounds2.width) {
                    this.myUpperTargetPoint = new Point(bounds2.x + bounds2.width, bounds2.y);
                    this.myLowerTargetPoint = new Point(bounds2.x + bounds2.width, bounds2.y + bounds2.height);
                }
            }
        }

        @Override
        public boolean dispatch(@NotNull AWTEvent e) {
            if (e == null) {
                UsabilityHelper.$$$reportNull$$$0(0);
            }
            if (e instanceof MouseEvent && this.myUpperTargetPoint != null && this.myLowerTargetPoint != null && this.myCallbackAlarm != null) {
                if (e.getID() == 501 || e.getID() == 502 || e.getID() == 500) {
                    return false;
                }
                Point point = ((MouseEvent)e).getLocationOnScreen();
                Rectangle bounds2 = this.myComponent.getBounds();
                bounds2.setLocation(this.myComponent.getLocationOnScreen());
                this.myInBounds = bounds2.contains(point);
                boolean isMouseMovingTowardsSubmenu = this.myInBounds || new Polygon(new int[]{this.myLastMousePoint.x, this.myUpperTargetPoint.x, this.myLowerTargetPoint.x}, new int[]{this.myLastMousePoint.y, this.myUpperTargetPoint.y, this.myLowerTargetPoint.y}, 3).contains(point);
                this.myEventToRedispatch = (MouseEvent)e;
                this.myLastEventTime = System.currentTimeMillis();
                if (!isMouseMovingTowardsSubmenu) {
                    this.myCallbackAlarm.request();
                } else {
                    this.myCallbackAlarm.cancel();
                }
                this.myLastMousePoint = point;
                return true;
            }
            return false;
        }

        public void dispose() {
            this.myComponent = null;
            this.myEventToRedispatch = null;
            this.myLowerTargetPoint = null;
            this.myUpperTargetPoint = null;
            this.myLastMousePoint = null;
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/impl/ActionMenu$UsabilityHelper", "dispatch"));
        }
    }

    private class MenuItemSynchronizer
    implements PropertyChangeListener {
        private MenuItemSynchronizer() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("visible".equals(name)) {
                ActionMenu.this.setVisible(ActionMenu.this.myPresentation.isVisible());
                if (SystemInfo.isMacSystemMenu && ActionMenu.this.myPlace.equals("MainMenu")) {
                    ActionMenu.this.validate();
                }
            } else if ("enabled".equals(name)) {
                ActionMenu.this.setEnabled(ActionMenu.this.myPresentation.isEnabled());
            } else if ("mnemonicKey".equals(name)) {
                ActionMenu.this.setMnemonic(ActionMenu.this.myPresentation.getMnemonic());
            } else if ("mnemonicIndex".equals(name)) {
                ActionMenu.this.setDisplayedMnemonicIndex(ActionMenu.this.myPresentation.getDisplayedMnemonicIndex());
            } else if ("text".equals(name)) {
                ActionMenu.this.setText(ActionMenu.this.myPresentation.getText());
            } else if ("icon".equals(name) || "disabledIcon".equals(name)) {
                ActionMenu.this.updateIcon();
            }
        }
    }

    private class MenuListenerImpl
    implements MenuListener {
        boolean myIsHidden = false;

        private MenuListenerImpl() {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
            this.onMenuHidden();
        }

        @Override
        public void menuDeselected(MenuEvent e) {
            if (ActionMenu.this.myDisposable != null) {
                Disposer.dispose((Disposable)ActionMenu.this.myDisposable);
                ActionMenu.this.myDisposable = null;
            }
            this.onMenuHidden();
        }

        private void onMenuHidden() {
            if (KEEP_MENU_HIERARCHY) {
                return;
            }
            Runnable clearSelf = () -> {
                ActionMenu.this.clearItems();
                ActionMenu.this.addStubItem();
            };
            if (SystemInfo.isMacSystemMenu && ActionMenu.this.myPlace.equals("MainMenu")) {
                Disposable listenerHolder = Disposer.newDisposable();
                Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)listenerHolder);
                IdeEventQueue.getInstance().addDispatcher(e -> {
                    if (e instanceof KeyEvent) {
                        if (this.myIsHidden) {
                            clearSelf.run();
                        }
                        ApplicationManager.getApplication().invokeLater(() -> Disposer.dispose((Disposable)listenerHolder));
                    }
                    return false;
                }, listenerHolder);
                this.myIsHidden = true;
            } else {
                clearSelf.run();
            }
        }

        @Override
        public void menuSelected(MenuEvent e) {
            UsabilityHelper helper = new UsabilityHelper((Component)((Object)ActionMenu.this));
            if (ActionMenu.this.myDisposable == null) {
                ActionMenu.this.myDisposable = Disposer.newDisposable();
            }
            Disposer.register((Disposable)ActionMenu.this.myDisposable, (Disposable)helper);
            if (KEEP_MENU_HIERARCHY || this.myIsHidden) {
                ActionMenu.this.clearItems();
            }
            this.myIsHidden = false;
            ActionMenu.this.fillMenu();
        }
    }
}

