/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.impl.ProjectExImplKt;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.project.impl.ProjectStoreFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectStoreOwner;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.TimedReference;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.impl.MessageBusEx;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001a\u001a\u00020\u0006H\u0007J\u0014\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2\u0006\u0010\u001e\u001a\u00020\u0006H\u0002J\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020 J\b\u0010\"\u001a\u0004\u0018\u00010#J\u0006\u0010$\u001a\u00020\u0006J\b\u0010%\u001a\u00020\u0014H\u0007J\b\u0010&\u001a\u00020\u0006H\u0016J\n\u0010'\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010(\u001a\u0004\u0018\u00010#J\u0010\u0010)\u001a\f0\u0006\u00a2\u0006\u0002\b*\u00a2\u0006\u0002\b\u0011J\b\u0010+\u001a\u00020\tH\u0004J\b\u0010,\u001a\u0004\u0018\u00010#J\u0006\u0010-\u001a\u00020\u0016J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010.\u001a\u00020 2\u0006\u0010\b\u001a\u00020\u0016J\u0006\u0010/\u001a\u00020\u0006R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0019\u0010\u000f\u001a\r\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00060"}, d2={"Lcom/intellij/openapi/project/impl/ProjectExImpl;", "Lcom/intellij/openapi/project/impl/ProjectImpl;", "Lcom/intellij/project/ProjectStoreOwner;", "filePath", "Ljava/nio/file/Path;", "projectName", "", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "value", "Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "componentStore", "getComponentStore", "()Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "setComponentStore", "(Lcom/intellij/openapi/components/impl/stores/IProjectStore;)V", "componentStoreValue", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Lorg/jetbrains/annotations/NotNull;", "earlyDisposable", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/Disposable;", "isLight", "", "<set-?>", "isTemporarilyDisposed", "()Z", "activityNamePrefix", "createEarlyDisposableError", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "error", "dispose", "", "disposeEarlyDisposable", "getBaseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBasePath", "getEarlyDisposable", "getLocationHash", "getPresentableUrl", "getProjectFile", "getProjectFilePath", "Lorg/jetbrains/annotations/SystemIndependent;", "getStateStore", "getWorkspaceFile", "isDisposed", "setTemporarilyDisposed", "toString", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public class ProjectExImpl
extends ProjectImpl
implements ProjectStoreOwner {
    private final AtomicReference<Disposable> earlyDisposable;
    private volatile boolean isTemporarilyDisposed;
    private final boolean isLight;
    private SynchronizedClearableLazy<IProjectStore> componentStoreValue;

    public final boolean isTemporarilyDisposed() {
        return this.isTemporarilyDisposed;
    }

    @Override
    @NotNull
    public final IProjectStore getComponentStore() {
        Object object = this.componentStoreValue.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"componentStoreValue.value");
        return (IProjectStore)object;
    }

    @Override
    public final void setComponentStore(@NotNull IProjectStore value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        if (this.componentStoreValue.isInitialized()) {
            throw (Throwable)new IllegalStateException("store is already initialized");
        }
        this.componentStoreValue.setValue((Object)value2);
    }

    @Override
    @NotNull
    protected final IProjectStore getStateStore() {
        return this.getComponentStore();
    }

    @NotNull
    public final String getProjectFilePath() {
        String string = this.getComponentStore().getProjectFilePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"componentStore.projectFilePath");
        return string;
    }

    @Nullable
    public final VirtualFile getProjectFile() {
        return LocalFileSystem.getInstance().findFileByPath(this.getComponentStore().getProjectFilePath());
    }

    @Nullable
    public final VirtualFile getBaseDir() {
        return LocalFileSystem.getInstance().findFileByNioFile(this.getComponentStore().getProjectBasePath());
    }

    @NotNull
    public final String getBasePath() {
        Path path = this.getComponentStore().getProjectBasePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"componentStore.projectBasePath");
        return PathKt.getSystemIndependentPath((Path)path);
    }

    @Nullable
    public String getPresentableUrl() {
        String string;
        IProjectStore store = this.getComponentStore();
        if (store.getStorageScheme() == StorageScheme.DIRECTORY_BASED) {
            Path path = store.getProjectBasePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"store.projectBasePath");
            string = PathKt.getSystemIndependentPath((Path)path);
        } else {
            string = store.getProjectFilePath();
        }
        return string;
    }

    @NotNull
    public String getLocationHash() {
        String string;
        if (this.getComponentStore().getStorageScheme() == StorageScheme.DIRECTORY_BASED) {
            string = "";
        } else {
            String string2 = this.getName();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
        }
        String prefix = string;
        StringBuilder stringBuilder = new StringBuilder().append(prefix);
        String string3 = this.getPresentableUrl();
        if (string3 == null) {
            String string4 = this.getName();
            string3 = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"name");
        }
        return stringBuilder.append(Integer.toHexString(string3.hashCode())).toString();
    }

    @Nullable
    public final VirtualFile getWorkspaceFile() {
        String string = this.getComponentStore().getWorkspaceFilePath();
        if (string == null) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByPath(string);
    }

    @Override
    public final boolean isLight() {
        return this.isLight;
    }

    @ApiStatus.Internal
    @NotNull
    public final String activityNamePrefix() {
        return "project ";
    }

    public final void setTemporarilyDisposed(boolean value2) {
        if (this.isTemporarilyDisposed == value2) {
            return;
        }
        if (value2 && super.isDisposed()) {
            throw (Throwable)new IllegalStateException("Project was already disposed, flag temporarilyDisposed cannot be set to `true`");
        }
        if (!value2) {
            Disposable disposable2 = Disposer.newDisposable();
            Intrinsics.checkExpressionValueIsNotNull((Object)disposable2, (String)"Disposer.newDisposable()");
            Disposable newDisposable = disposable2;
            if (!this.earlyDisposable.compareAndSet(null, newDisposable)) {
                throw (Throwable)new IllegalStateException("earlyDisposable must be null on second opening of light project");
            }
        }
        MessageBus messageBus = this.getMessageBus();
        if (messageBus == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.messages.impl.MessageBusEx");
        }
        ((MessageBusEx)messageBus).clearAllSubscriberCache();
        this.isTemporarilyDisposed = value2;
    }

    @Override
    @ApiStatus.Experimental
    @ApiStatus.Internal
    @NotNull
    public final Disposable getEarlyDisposable() {
        if (this.isDisposed()) {
            throw (Throwable)new AlreadyDisposedException(this + " is disposed already");
        }
        Disposable disposable2 = this.earlyDisposable.get();
        if (disposable2 == null) {
            throw (Throwable)this.createEarlyDisposableError("earlyDisposable is null for");
        }
        return disposable2;
    }

    public final void disposeEarlyDisposable() {
        block6: {
            block5: {
                Logger logger = ProjectImpl.LOG;
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
                if (logger.isDebugEnabled()) break block5;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isUnitTestMode()) break block6;
            }
            ProjectImpl.LOG.debug("dispose early disposable: " + this.toString());
        }
        Disposable disposable2 = this.earlyDisposable.getAndSet(null);
        if (disposable2 == null) {
            throw (Throwable)this.createEarlyDisposableError("earlyDisposable was already disposed");
        }
        Disposable disposable3 = disposable2;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            this.putUserData(ProjectExImplKt.access$getDISPOSE_EARLY_DISPOSABLE_TRACE$p(), ExceptionUtil.currentStackTrace());
        }
        Disposer.dispose((Disposable)disposable3);
    }

    private final RuntimeException createEarlyDisposableError(String error) {
        return new IllegalStateException(error + " for " + this.toString() + "\n---begin of dispose trace--" + (String)this.getUserData(ProjectExImplKt.access$getDISPOSE_EARLY_DISPOSABLE_TRACE$p()) + "}---end of dispose trace---\n");
    }

    public final boolean isDisposed() {
        return super.isDisposed() || this.isTemporarilyDisposed;
    }

    public final synchronized void dispose() {
        Application app = ApplicationManager.getApplication();
        app.assertWriteAccessAllowed();
        ProjectManager projectManager = ProjectManager.getInstance();
        if (projectManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.project.impl.ProjectManagerImpl");
        }
        ProjectManagerImpl projectManager2 = (ProjectManagerImpl)projectManager;
        if (projectManager2.isProjectOpened(this)) {
            throw (Throwable)new IllegalStateException("Must call .dispose() for a closed project only. See ProjectManager.closeProject() or ProjectUtil.closeAndDispose().");
        }
        super.dispose();
        IProjectStore iProjectStore = (IProjectStore)this.componentStoreValue.getValueIfInitialized();
        if (iProjectStore != null) {
            iProjectStore.release();
        }
        Application application = app;
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
        if (!application.isDisposed()) {
            ((ProjectLifecycleListener)app.getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).afterProjectClosed((Project)this);
        }
        projectManager2.updateTheOnlyProjectField();
        TimedReference.disposeTimed();
        LaterInvocator.purgeExpiredItems();
    }

    @NotNull
    public final String toString() {
        String string;
        IProjectStore store = (IProjectStore)this.componentStoreValue.getValueIfInitialized();
        StringBuilder stringBuilder = new StringBuilder().append("Project(name=").append(this.myName).append(", containerState=").append(this.isTemporarilyDisposed ? "disposed temporarily" : this.getContainerStateName()).append(", componentStore=");
        if (store == null) {
            string = "<not initialized>";
        } else if (store.getStorageScheme() == StorageScheme.DIRECTORY_BASED) {
            string = ((Object)store.getProjectBasePath()).toString();
        } else {
            String string2 = store.getProjectFilePath();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"store.projectFilePath");
        }
        return stringBuilder.append(string).append(")").toString();
    }

    public ProjectExImpl(@NotNull Path filePath, @Nullable String projectName) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.serviceContainer.ComponentManagerImpl");
        }
        super((ComponentManagerImpl)application);
        this.earlyDisposable = new AtomicReference<Disposable>(Disposer.newDisposable());
        this.componentStoreValue = new SynchronizedClearableLazy((Function0)new Function0<IProjectStore>(this){
            final /* synthetic */ ProjectExImpl this$0;

            @NotNull
            public final IProjectStore invoke() {
                return ((ProjectStoreFactory)ApplicationManager.getApplication().getService(ProjectStoreFactory.class)).createStore(this.this$0);
            }
            {
                this.this$0 = projectExImpl;
                super(0);
            }
        });
        this.putUserData(ProjectImpl.CREATION_TIME, System.nanoTime());
        this.registerServiceInstance(Project.class, this, (PluginDescriptor)ComponentManagerImpl.Companion.getFakeCorePluginDescriptor());
        this.myName = projectName;
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"ApplicationManager.getApplication()");
        this.isLight = application2.isUnitTestMode() && StringsKt.contains$default((CharSequence)((Object)filePath).toString(), (CharSequence)"light_temp", (boolean)false, (int)2, null);
    }
}

