/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;

class CommonButtonUI
extends BasicButtonUI {
    private final MouseAdapter myAdapter = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            CommonButtonUI.this.myHover = true;
            e.getComponent().repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            CommonButtonUI.this.myHover = false;
            e.getComponent().repaint();
        }
    };
    private boolean myHover;

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setOpaque(false);
        Border border = b.getBorder();
        if (border == null || border instanceof UIResource) {
            b.setBorder(BorderFactory.createEmptyBorder(JBUIScale.scale((int)4), JBUIScale.scale((int)4), JBUIScale.scale((int)4), JBUIScale.scale((int)4)));
        }
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addMouseListener(this.myAdapter);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        b.removeMouseListener(this.myAdapter);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        if (this.myHover && b.isEnabled() || b.isSelected() || b.isFocusOwner()) {
            this.paintBackground(g, c);
        }
        super.paint(g, c);
    }

    void paintBackground(Graphics g2, JComponent component2) {
        Graphics2D g = (Graphics2D)g2;
        Dimension size = component2.getSize();
        GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g);
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(1.0, 1.0, size.width - 3, size.height - 3, 4.0, 4.0);
        if (UIUtil.isUnderDefaultMacTheme()) {
            g.setColor((Color)Gray.xE0);
            g.fill(rect);
            g.setColor((Color)Gray.xCA);
            g.draw(rect);
        } else {
            g.setColor((Color)new JBColor((Color)Gray.xE8, new Color(4606541)));
            g.fill(rect);
            g.setColor((Color)new JBColor((Color)Gray.xCC, new Color(7699328)));
            g.draw(rect);
        }
        config2.restore();
    }
}

