/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.docking.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.VerticalBox;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockContainerFactory;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.docking.DragSession;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DockManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$"), @Storage(value="$WORKSPACE_FILE$", deprecated=true)})
public final class DockManagerImpl
extends DockManager
implements PersistentStateComponent<Element> {
    private final Project myProject;
    private final Map<String, DockContainerFactory> myFactories;
    private final Set<DockContainer> myContainers;
    private final Map<DockContainer, DockWindow> containerToWindow;
    private MyDragSession myCurrentDragSession;
    private final BusyObject.Impl myBusyObject;
    private int myWindowIdCounter;
    private Element myLoadedState;

    public DockManagerImpl(@NotNull Project project) {
        if (project == null) {
            DockManagerImpl.$$$reportNull$$$0(0);
        }
        this.myFactories = new HashMap<String, DockContainerFactory>();
        this.myContainers = new HashSet<DockContainer>();
        this.containerToWindow = new HashMap<DockContainer, DockWindow>();
        this.myBusyObject = new BusyObject.Impl(){

            public boolean isReady() {
                return DockManagerImpl.this.myCurrentDragSession == null;
            }
        };
        this.myWindowIdCounter = 1;
        this.myProject = project;
    }

    public void register(@NotNull DockContainer container2) {
        if (container2 == null) {
            DockManagerImpl.$$$reportNull$$$0(1);
        }
        if (container2 instanceof Disposable) {
            this.register(container2, (Disposable)container2);
        } else {
            this.myContainers.add(container2);
        }
    }

    public void register(final @NotNull DockContainer container2, @NotNull Disposable parentDisposable) {
        if (container2 == null) {
            DockManagerImpl.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            DockManagerImpl.$$$reportNull$$$0(3);
        }
        this.myContainers.add(container2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                DockManagerImpl.this.myContainers.remove(container2);
            }
        });
    }

    public void register(final @NotNull String id2, @NotNull DockContainerFactory factory2, @NotNull Disposable parentDisposable) {
        if (id2 == null) {
            DockManagerImpl.$$$reportNull$$$0(4);
        }
        if (factory2 == null) {
            DockManagerImpl.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            DockManagerImpl.$$$reportNull$$$0(6);
        }
        this.myFactories.put(id2, factory2);
        if (parentDisposable != this.myProject) {
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    DockManagerImpl.this.myFactories.remove(id2);
                }
            });
        }
        this.readStateFor(id2);
    }

    public void readState() {
        for (String id2 : this.myFactories.keySet()) {
            this.readStateFor(id2);
        }
    }

    @NotNull
    public Set<DockContainer> getContainers() {
        HashSet<DockContainer> result2 = new HashSet<DockContainer>(this.myContainers.size() + this.containerToWindow.size());
        result2.addAll(this.myContainers);
        result2.addAll(this.containerToWindow.keySet());
        Set<DockContainer> set = Collections.unmodifiableSet(result2);
        if (set == null) {
            DockManagerImpl.$$$reportNull$$$0(7);
        }
        return set;
    }

    public IdeFrame getIdeFrame(@NotNull DockContainer container2) {
        Component parent;
        if (container2 == null) {
            DockManagerImpl.$$$reportNull$$$0(8);
        }
        return (parent = UIUtil.findUltimateParent((Component)container2.getContainerComponent())) instanceof IdeFrame ? (IdeFrame)parent : null;
    }

    public String getDimensionKeyForFocus(@NotNull String key) {
        Component owner;
        if (key == null) {
            DockManagerImpl.$$$reportNull$$$0(9);
        }
        if ((owner = IdeFocusManager.getInstance((Project)this.myProject).getFocusOwner()) == null) {
            return key;
        }
        DockWindow window = this.containerToWindow.get(this.getContainerFor(owner));
        return window != null ? key + "#" + window.myId : key;
    }

    public DockContainer getContainerFor(Component c) {
        if (c == null) {
            return null;
        }
        for (DockContainer eachContainer : this.getAllContainers()) {
            if (!SwingUtilities.isDescendingFrom(c, eachContainer.getContainerComponent())) continue;
            return eachContainer;
        }
        Component parent = UIUtil.findUltimateParent((Component)c);
        for (DockContainer eachContainer : this.getAllContainers()) {
            if (parent != UIUtil.findUltimateParent((Component)eachContainer.getContainerComponent())) continue;
            return eachContainer;
        }
        return null;
    }

    public DragSession createDragSession(MouseEvent mouseEvent, @NotNull DockableContent content2) {
        if (content2 == null) {
            DockManagerImpl.$$$reportNull$$$0(10);
        }
        this.stopCurrentDragSession();
        for (DockContainer each : this.getAllContainers()) {
            DockWindow window;
            if (!each.isEmpty() || !each.isDisposeWhenEmpty() || (window = this.containerToWindow.get(each)) == null) continue;
            window.setTransparent(true);
        }
        this.myCurrentDragSession = new MyDragSession(mouseEvent, content2);
        return this.myCurrentDragSession;
    }

    public void stopCurrentDragSession() {
        if (this.myCurrentDragSession != null) {
            this.myCurrentDragSession.cancelSession();
            this.myCurrentDragSession = null;
            this.myBusyObject.onReady();
            for (DockContainer each : this.getAllContainers()) {
                DockWindow window;
                if (each.isEmpty() || (window = this.containerToWindow.get(each)) == null) continue;
                window.setTransparent(false);
            }
        }
    }

    private ActionCallback getReady() {
        return this.myBusyObject.getReady((Object)this);
    }

    @Nullable
    private DockContainer findContainerFor(RelativePoint point, @NotNull DockableContent<?> content2) {
        Window window;
        RelativeRectangle rec;
        if (content2 == null) {
            DockManagerImpl.$$$reportNull$$$0(11);
        }
        DockContainer candidate = null;
        for (DockContainer each : this.getContainers()) {
            rec = each.getAcceptArea();
            if (!rec.contains(point) || !each.getContentResponse(content2, point).canAccept()) continue;
            window = UIUtil.getWindow((Component)each.getContainerComponent());
            if (window != null && window.isActive()) {
                return each;
            }
            if (candidate != null && !Comparing.equal((Object)candidate, (Object)this.myCurrentDragSession.myStartDragContainer)) continue;
            candidate = each;
        }
        for (DockContainer each : this.getContainers()) {
            rec = each.getAcceptAreaFallback();
            if (!rec.contains(point) || !each.getContentResponse(content2, point).canAccept()) continue;
            window = UIUtil.getWindow((Component)each.getContainerComponent());
            if (window != null && window.isActive()) {
                return candidate;
            }
            if (candidate != null && !Comparing.equal((Object)candidate, (Object)this.myCurrentDragSession.myStartDragContainer)) continue;
            candidate = each;
        }
        return candidate;
    }

    private DockContainerFactory getFactory(String type) {
        assert (this.myFactories.containsKey(type)) : "No factory for content type=" + type;
        return this.myFactories.get(type);
    }

    public void createNewDockContainerFor(@NotNull DockableContent<?> content2, @NotNull RelativePoint point) {
        if (content2 == null) {
            DockManagerImpl.$$$reportNull$$$0(12);
        }
        if (point == null) {
            DockManagerImpl.$$$reportNull$$$0(13);
        }
        DockContainer container2 = this.getFactory(content2.getDockContainerType()).createContainer(content2);
        DockWindow window = this.createWindowFor(null, container2);
        Dimension size = content2.getPreferredSize();
        Point showPoint = point.getScreenPoint();
        showPoint.x -= size.width / 2;
        showPoint.y -= size.height / 2;
        Rectangle target2 = new Rectangle(showPoint, size);
        ScreenUtil.moveRectangleToFitTheScreen((Rectangle)target2);
        ScreenUtil.cropRectangleToFitTheScreen((Rectangle)target2);
        window.setLocation(target2.getLocation());
        window.myDockContentUiContainer.setPreferredSize(target2.getSize());
        window.show(false);
        window.getFrame().pack();
        container2.add(content2, new RelativePoint(target2.getLocation()));
        SwingUtilities.invokeLater(() -> window.myUiContainer.setPreferredSize(null));
    }

    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> createNewDockContainerFor(@NotNull VirtualFile file2, @NotNull FileEditorManagerImpl fileEditorManager) {
        if (file2 == null) {
            DockManagerImpl.$$$reportNull$$$0(14);
        }
        if (fileEditorManager == null) {
            DockManagerImpl.$$$reportNull$$$0(15);
        }
        DockContainer container2 = this.getFactory("file-editors").createContainer(null);
        DockWindow window = this.createWindowFor(null, container2);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            window.show(true);
        }
        EditorWindow editorWindow = ((DockableEditorTabbedContainer)container2).getSplitters().getOrCreateCurrentWindow(file2);
        Pair<FileEditor[], FileEditorProvider[]> result2 = fileEditorManager.openFileImpl2(editorWindow, file2, true);
        container2.add((DockableContent)EditorTabbedContainer.createDockableEditor(this.myProject, null, file2, new Presentation(file2.getName()), editorWindow), null);
        SwingUtilities.invokeLater(() -> window.myUiContainer.setPreferredSize(null));
        Pair<FileEditor[], FileEditorProvider[]> pair = result2;
        if (pair == null) {
            DockManagerImpl.$$$reportNull$$$0(16);
        }
        return pair;
    }

    @NotNull
    private DockWindow createWindowFor(@Nullable String id2, @NotNull DockContainer container2) {
        if (container2 == null) {
            DockManagerImpl.$$$reportNull$$$0(17);
        }
        String windowId = id2 != null ? id2 : Integer.toString(this.myWindowIdCounter++);
        DockWindow window = new DockWindow(windowId, this.myProject, container2, container2 instanceof DockContainer.Dialog);
        this.containerToWindow.put(container2, window);
        DockWindow dockWindow = window;
        if (dockWindow == null) {
            DockManagerImpl.$$$reportNull$$$0(18);
        }
        return dockWindow;
    }

    public Element getState() {
        Element root = new Element("state");
        for (DockContainer each : this.getAllContainers()) {
            DockWindow eachWindow = this.containerToWindow.get(each);
            if (eachWindow == null || !(each instanceof DockContainer.Persistent)) continue;
            DockContainer.Persistent eachContainer = (DockContainer.Persistent)each;
            Element eachWindowElement = new Element("window");
            eachWindowElement.setAttribute("id", eachWindow.myId);
            Element content2 = new Element("content");
            content2.setAttribute("type", eachContainer.getDockContainerType());
            content2.addContent(eachContainer.getState());
            eachWindowElement.addContent(content2);
            root.addContent(eachWindowElement);
        }
        return root;
    }

    @NotNull
    private Iterable<DockContainer> getAllContainers() {
        Iterable iterable = ContainerUtil.concat(this.myContainers, this.containerToWindow.keySet());
        if (iterable == null) {
            DockManagerImpl.$$$reportNull$$$0(19);
        }
        return iterable;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            DockManagerImpl.$$$reportNull$$$0(20);
        }
        this.myLoadedState = state;
    }

    private void readStateFor(@NotNull String type) {
        if (type == null) {
            DockManagerImpl.$$$reportNull$$$0(21);
        }
        if (this.myLoadedState == null) {
            return;
        }
        for (Element windowElement : this.myLoadedState.getChildren("window")) {
            DockContainerFactory factory2;
            String eachType;
            Element eachContent = windowElement.getChild("content");
            if (eachContent == null || !type.equals(eachType = eachContent.getAttributeValue("type")) || !this.myFactories.containsKey(eachType) || !((factory2 = this.myFactories.get(eachType)) instanceof DockContainerFactory.Persistent)) continue;
            DockContainer container2 = ((DockContainerFactory.Persistent)factory2).loadContainerFrom(eachContent);
            DockWindow window = this.createWindowFor(windowElement.getAttributeValue("id"), container2);
            UIUtil.invokeLaterIfNeeded(window::show);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 16: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 16: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 7: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/docking/impl/DockManagerImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorManager";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/docking/impl/DockManagerImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainers";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewDockContainerFor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createWindowFor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllContainers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 7: 
            case 16: 
            case 18: 
            case 19: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIdeFrame";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDimensionKeyForFocus";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDragSession";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findContainerFor";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createNewDockContainerFor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createWindowFor";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "readStateFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 16: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class DockWindow
    extends FrameWrapper
    implements IdeEventQueue.EventDispatcher {
        private final String myId;
        private final DockContainer myContainer;
        private final VerticalBox myNorthPanel;
        private final Map<String, IdeRootPaneNorthExtension> myNorthExtensions;
        private final NonOpaquePanel myUiContainer;
        private final JPanel myDockContentUiContainer;

        private DockWindow(@NotNull String id2, Project project, DockContainer container2, boolean isDialog) {
            Window frame;
            StatusBar statusBar;
            if (project == null) {
                DockWindow.$$$reportNull$$$0(0);
            }
            super(project, "dock-window-" + id2, isDialog);
            this.myNorthPanel = new VerticalBox();
            this.myNorthExtensions = new LinkedHashMap<String, IdeRootPaneNorthExtension>();
            this.myId = id2;
            this.myContainer = container2;
            this.setProject(project);
            if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !(container2 instanceof DockContainer.Dialog) && (statusBar = WindowManager.getInstance().getStatusBar(project)) != null && (frame = this.getFrame()) instanceof IdeFrame) {
                this.setStatusBar(statusBar.createChild((IdeFrame)frame));
            }
            this.myUiContainer = new NonOpaquePanel((LayoutManager)new BorderLayout());
            JPanel center = new JPanel(new BorderLayout(0, 2));
            center.setOpaque(false);
            center.add((Component)this.myNorthPanel, "North");
            this.myDockContentUiContainer = new JPanel(new BorderLayout());
            this.myDockContentUiContainer.setOpaque(false);
            this.myDockContentUiContainer.add((Component)this.myContainer.getContainerComponent(), "Center");
            center.add((Component)this.myDockContentUiContainer, "Center");
            this.myUiContainer.add((Component)center, (Object)"Center");
            StatusBar statusBar2 = this.getStatusBar();
            if (statusBar2 != null) {
                this.myUiContainer.add((Component)statusBar2.getComponent(), (Object)"South");
            }
            this.setComponent((JComponent)this.myUiContainer);
            IdeEventQueue.getInstance().addPostprocessor(this, this);
            this.myContainer.addListener(new DockContainer.Listener(){

                public void contentRemoved(Object key) {
                    DockManagerImpl.this.getReady().doWhenDone(() -> {
                        if (DockWindow.this.myContainer.isEmpty()) {
                            DockWindow.this.close();
                            DockManagerImpl.this.myContainers.remove(DockWindow.this.myContainer);
                        }
                    });
                }
            }, (Disposable)this);
            project.getMessageBus().connect((Disposable)this).subscribe(UISettingsListener.TOPIC, uiSettings -> this.updateNorthPanel());
            this.updateNorthPanel();
        }

        @Override
        protected IdeRootPaneNorthExtension getNorthExtension(String key) {
            return this.myNorthExtensions.get(key);
        }

        private void updateNorthPanel() {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            this.myNorthPanel.setVisible(UISettings.getInstance().getShowNavigationBar() && !(this.myContainer instanceof DockContainer.Dialog) && !UISettings.getInstance().getPresentationMode());
            HashSet<String> processedKeys = new HashSet<String>();
            for (Object each : IdeRootPaneNorthExtension.EP_NAME.getExtensionList((AreaInstance)DockManagerImpl.this.myProject)) {
                processedKeys.add(each.getKey());
                if (this.myNorthExtensions.containsKey(each.getKey())) continue;
                IdeRootPaneNorthExtension toInstall = each.copy();
                this.myNorthExtensions.put(toInstall.getKey(), toInstall);
                this.myNorthPanel.add((Component)toInstall.getComponent());
            }
            Iterator<String> existing = this.myNorthExtensions.keySet().iterator();
            while (existing.hasNext()) {
                Object each;
                each = existing.next();
                if (processedKeys.contains(each)) continue;
                IdeRootPaneNorthExtension toRemove2 = this.myNorthExtensions.get(each);
                this.myNorthPanel.remove((Component)toRemove2.getComponent());
                existing.remove();
                if (!(toRemove2 instanceof Disposable)) continue;
                Disposer.dispose((Disposable)((Disposable)toRemove2));
            }
            this.myNorthPanel.revalidate();
            this.myNorthPanel.repaint();
        }

        public void setTransparent(boolean transparent) {
            if (transparent) {
                WindowManagerEx.getInstanceEx().setAlphaModeEnabled(this.getFrame(), true);
                WindowManagerEx.getInstanceEx().setAlphaModeRatio(this.getFrame(), 0.5f);
            } else {
                WindowManagerEx.getInstanceEx().setAlphaModeEnabled(this.getFrame(), true);
                WindowManagerEx.getInstanceEx().setAlphaModeRatio(this.getFrame(), 0.0f);
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            DockManagerImpl.this.containerToWindow.remove(this.myContainer);
            for (IdeRootPaneNorthExtension each : this.myNorthExtensions.values()) {
                if (!(each instanceof Disposable)) continue;
                Disposer.dispose((Disposable)((Disposable)each));
            }
            this.myNorthExtensions.clear();
        }

        @Override
        public boolean dispatch(@NotNull AWTEvent e) {
            if (e == null) {
                DockWindow.$$$reportNull$$$0(1);
            }
            if (e instanceof KeyEvent && DockManagerImpl.this.myCurrentDragSession != null) {
                DockManagerImpl.this.stopCurrentDragSession();
            }
            return false;
        }

        @Override
        @NotNull
        protected JFrame createJFrame(@NotNull IdeFrame parent) {
            if (parent == null) {
                DockWindow.$$$reportNull$$$0(2);
            }
            JFrame frame = super.createJFrame(parent);
            this.installListeners(frame);
            JFrame jFrame = frame;
            if (jFrame == null) {
                DockWindow.$$$reportNull$$$0(3);
            }
            return jFrame;
        }

        @Override
        @NotNull
        protected JDialog createJDialog(@NotNull IdeFrame parent) {
            if (parent == null) {
                DockWindow.$$$reportNull$$$0(4);
            }
            JDialog frame = super.createJDialog(parent);
            this.installListeners(frame);
            JDialog jDialog = frame;
            if (jDialog == null) {
                DockWindow.$$$reportNull$$$0(5);
            }
            return jDialog;
        }

        private void installListeners(@NotNull Window frame) {
            if (frame == null) {
                DockWindow.$$$reportNull$$$0(6);
            }
            final UiNotifyConnector uiNotifyConnector = this.myContainer instanceof Activatable ? new UiNotifyConnector((Component)((RootPaneContainer)((Object)frame)).getContentPane(), (Activatable)this.myContainer) : null;
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    DockWindow.this.myContainer.closeAll();
                    if (uiNotifyConnector != null) {
                        Disposer.dispose((Disposable)uiNotifyConnector);
                    }
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/docking/impl/DockManagerImpl$DockWindow";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/docking/impl/DockManagerImpl$DockWindow";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createJFrame";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createJDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "dispatch";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createJFrame";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createJDialog";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "installListeners";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class MyDragSession
    implements DragSession {
        private final JDialog myWindow;
        private Image myDragImage;
        private final Image myDefaultDragImage;
        @NotNull
        private final DockableContent myContent;
        private DockContainer myStartDragContainer;
        private DockContainer myCurrentOverContainer;
        private final JLabel myImageContainer;

        private MyDragSession(@NotNull MouseEvent me, DockableContent content2) {
            if (content2 == null) {
                MyDragSession.$$$reportNull$$$0(0);
            }
            this.myWindow = new JDialog(UIUtil.getWindow((Component)me.getComponent()));
            this.myWindow.setUndecorated(true);
            this.myContent = content2;
            this.myStartDragContainer = DockManagerImpl.this.getContainerFor(me.getComponent());
            Image previewImage = content2.getPreviewImage();
            double requiredSize2 = 220.0;
            double width = previewImage.getWidth(null);
            double height = previewImage.getHeight(null);
            double ratio = width > height ? requiredSize2 / width : requiredSize2 / height;
            BufferedImage buffer = UIUtil.createImage((Component)this.myWindow, (int)((int)width), (int)((int)height), (int)2);
            buffer.createGraphics().drawImage(previewImage, 0, 0, (int)width, (int)height, null);
            this.myDragImage = this.myDefaultDragImage = buffer.getScaledInstance((int)(width * ratio), (int)(height * ratio), 4);
            this.myWindow.getContentPane().setLayout(new BorderLayout());
            this.myImageContainer = new JLabel((Icon)IconUtil.createImageIcon((Image)this.myDragImage));
            this.myImageContainer.setBorder(new LineBorder((Color)JBColor.LIGHT_GRAY));
            this.myWindow.getContentPane().add((Component)this.myImageContainer, "Center");
            this.setLocationFrom(me);
            this.myWindow.setVisible(true);
            WindowManagerEx windowManager = WindowManagerEx.getInstanceEx();
            windowManager.setAlphaModeEnabled(this.myWindow, true);
            windowManager.setAlphaModeRatio(this.myWindow, 0.1f);
            this.myWindow.getRootPane().putClientProperty("Window.shadow", Boolean.FALSE);
        }

        private void setLocationFrom(MouseEvent me) {
            Point showPoint = me.getPoint();
            SwingUtilities.convertPointToScreen(showPoint, me.getComponent());
            Dimension size = this.myImageContainer.getSize();
            showPoint.x -= size.width / 2;
            showPoint.y -= size.height / 2;
            this.myWindow.setBounds(new Rectangle(showPoint, size));
        }

        @NotNull
        public DockContainer.ContentResponse getResponse(MouseEvent e) {
            RelativePoint point = new RelativePoint(e);
            for (DockContainer each : DockManagerImpl.this.getAllContainers()) {
                DockContainer.ContentResponse response;
                RelativeRectangle rec = each.getAcceptArea();
                if (!rec.contains(point) || !(response = each.getContentResponse(this.myContent, point)).canAccept()) continue;
                DockContainer.ContentResponse contentResponse = response;
                if (contentResponse == null) {
                    MyDragSession.$$$reportNull$$$0(1);
                }
                return contentResponse;
            }
            DockContainer.ContentResponse contentResponse = DockContainer.ContentResponse.DENY;
            if (contentResponse == null) {
                MyDragSession.$$$reportNull$$$0(2);
            }
            return contentResponse;
        }

        public void process(MouseEvent e) {
            RelativePoint point = new RelativePoint(e);
            Image img = null;
            if (e.getID() == 506) {
                DockContainer over = DockManagerImpl.this.findContainerFor(point, this.myContent);
                if (this.myCurrentOverContainer != null && this.myCurrentOverContainer != over) {
                    this.myCurrentOverContainer.resetDropOver(this.myContent);
                    this.myCurrentOverContainer = null;
                }
                if (this.myCurrentOverContainer == null && over != null) {
                    this.myCurrentOverContainer = over;
                    img = this.myCurrentOverContainer.startDropOver(this.myContent, point);
                }
                if (this.myCurrentOverContainer != null) {
                    img = this.myCurrentOverContainer.processDropOver(this.myContent, point);
                }
                if (img == null) {
                    img = this.myDefaultDragImage;
                }
                if (img != this.myDragImage) {
                    this.myDragImage = img;
                    this.myImageContainer.setIcon((Icon)IconUtil.createImageIcon((Image)this.myDragImage));
                    this.myWindow.pack();
                }
                this.setLocationFrom(e);
            } else if (e.getID() == 502) {
                if (this.myCurrentOverContainer == null) {
                    DockManagerImpl.this.createNewDockContainerFor(this.myContent, point);
                } else {
                    this.myCurrentOverContainer.add(this.myContent, point);
                }
                DockManagerImpl.this.stopCurrentDragSession();
            }
        }

        public void cancel() {
            DockManagerImpl.this.stopCurrentDragSession();
        }

        private void cancelSession() {
            this.myWindow.dispose();
            if (this.myCurrentOverContainer != null) {
                this.myCurrentOverContainer.resetDropOver(this.myContent);
                this.myCurrentOverContainer = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/docking/impl/DockManagerImpl$MyDragSession";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/docking/impl/DockManagerImpl$MyDragSession";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResponse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

