/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.FileContentUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import org.intellij.plugins.intelliLang.InjectionsSettingsUI;
import org.intellij.plugins.intelliLang.IntelliLangBundle;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.jetbrains.annotations.NotNull;

public class EditInjectionSettingsAction
implements IntentionAction,
LowPriorityAction {
    public static final String EDIT_INJECTION_TITLE = "Language Injection Settings";

    @NotNull
    public String getText() {
        return EDIT_INJECTION_TITLE;
    }

    @NotNull
    public String getFamilyName() {
        String string = IntelliLangBundle.message("intention.family.name.edit.injection.settings", new Object[0]);
        if (string == null) {
            EditInjectionSettingsAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        int offset;
        PsiFile psiFile;
        if (project == null) {
            EditInjectionSettingsAction.$$$reportNull$$$0(1);
        }
        if ((psiFile = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)file, (int)(offset = editor.getCaretModel().getOffset()))) == null) {
            return false;
        }
        LanguageInjectionSupport support = (LanguageInjectionSupport)psiFile.getUserData(LanguageInjectionSupport.SETTINGS_EDITOR);
        return support != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            EditInjectionSettingsAction.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().runReadAction(() -> EditInjectionSettingsAction.invokeImpl(project, editor, file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeImpl(@NotNull Project project, Editor editor, PsiFile file) {
        PsiFile psiFile;
        if (project == null) {
            EditInjectionSettingsAction.$$$reportNull$$$0(3);
        }
        if ((psiFile = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)file, (int)editor.getCaretModel().getOffset())) == null) {
            return;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)project).getInjectionHost((PsiElement)psiFile);
        if (host == null) {
            return;
        }
        LanguageInjectionSupport support = (LanguageInjectionSupport)psiFile.getUserData(LanguageInjectionSupport.SETTINGS_EDITOR);
        if (support == null) {
            return;
        }
        try {
            if (!support.editInjectionInPlace(host)) {
                ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new InjectionsSettingsUI(project));
            }
        }
        finally {
            FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/EditInjectionSettingsAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/EditInjectionSettingsAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invokeImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

