/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.sorting;

import com.intellij.codeInsight.completion.CompletionFinalSorter;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.completion.ml.common.PrefixMatchingUtil;
import com.intellij.completion.settings.CompletionMLRankingSettings;
import com.intellij.completion.sorting.ItemRankInfo;
import com.intellij.completion.sorting.PositionDiffArrowInitializer;
import com.intellij.completion.sorting.RankingFeatures;
import com.intellij.completion.sorting.RankingModelWrapper;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.stats.PerformanceTracker;
import com.intellij.stats.completion.LookupExtensionsKt;
import com.intellij.stats.completion.RelevanceUtil;
import com.intellij.stats.personalization.session.SessionFactorsUtils;
import com.intellij.stats.storage.factors.MutableLookupStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001d\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0010\u0018\u0000 <2\u00020\u0001:\u0005<=>?@B\u0005\u00a2\u0006\u0002\u0010\u0002JL\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u00042\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J9\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u001fJh\u0010 \u001a\u00020\f2\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00042\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120%2\u0006\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\"\u0010,\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J4\u0010-\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0.0#0%2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050/H\u0016J\u0016\u00100\u001a\u00020\b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000501H\u0002J\u0016\u00102\u001a\u00020\b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000501H\u0002J&\u00103\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0005012\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050/2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016JN\u00104\u001a\b\u0012\u0004\u0012\u00020\u0005012\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050#2\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00190%2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120%2\u0006\u0010*\u001a\u00020+H\u0002J4\u00105\u001a\u00020\f2\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00042\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050#2\u0006\u0010&\u001a\u00020\u0012H\u0002J4\u00106\u001a\b\u0012\u0004\u0012\u00020\u000501*\b\u0012\u0004\u0012\u00020\u0005012\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120%2\u0006\u00107\u001a\u00020\u0012H\u0002J6\u00108\u001a\b\u0012\u0004\u0012\u00020\u000501*\b\u0012\u0004\u0012\u00020\u0005012\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00190%2\u0006\u00109\u001a\u00020\u0012H\u0002J\u0014\u0010:\u001a\u00020\f*\u00020\u00052\u0006\u0010;\u001a\u00020\u0012H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/intellij/completion/sorting/MLSorter;", "Lcom/intellij/codeInsight/completion/CompletionFinalSorter;", "()V", "cachedScore", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "Lcom/intellij/completion/sorting/ItemRankInfo;", "reorderOnlyTopItems", "", "sortingRestrictions", "Lcom/intellij/completion/sorting/MLSorter$SortingRestriction;", "calculateAdditionalFeaturesTo", "", "additionalMap", "", "", "lookupElement", "oldQueryLength", "", "prefixLength", "position", "itemsCount", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "calculateElementScore", "", "ranker", "Lcom/intellij/completion/sorting/RankingModelWrapper;", "element", "features", "Lcom/intellij/completion/sorting/RankingFeatures;", "(Lcom/intellij/completion/sorting/RankingModelWrapper;Lcom/intellij/codeInsight/lookup/LookupElement;ILcom/intellij/completion/sorting/RankingFeatures;I)Ljava/lang/Double;", "calculateScores", "element2score", "items", "", "positionsBefore", "", "queryLength", "prefix", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "lookupStorage", "Lcom/intellij/stats/storage/factors/MutableLookupStorage;", "getCachedRankInfo", "getRelevanceObjects", "Lcom/intellij/openapi/util/Pair;", "", "hasUnknownFeatures", "", "isCacheValid", "sort", "sortByMlScores", "tryFillFromCache", "addDiagnosticsIfNeeded", "reordered", "reorderByMLScores", "toReorder", "updateDiffValue", "newValue", "Companion", "ModelTimeTracker", "SortAll", "SortOnlyWithRecommendersScore", "SortingRestriction", "intellij.statsCollector"})
public final class MLSorter
extends CompletionFinalSorter {
    private final Map<LookupElement, ItemRankInfo> cachedScore = new IdentityHashMap();
    private SortingRestriction sortingRestrictions;
    private final boolean reorderOnlyTopItems = Registry.is((String)"completion.ml.reorder.only.top.items", (boolean)true);
    private static final Logger LOG;
    private static final int REORDER_ONLY_TOP_K = 5;
    @Deprecated
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<LookupElement, List<com.intellij.openapi.util.Pair<String, Object>>> getRelevanceObjects(@NotNull Iterable<? extends LookupElement> items) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        if (this.cachedScore.isEmpty()) {
            void $this$associateTo$iv$iv;
            Iterable<? extends LookupElement> $this$associate$iv = items;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
            Iterable<? extends LookupElement> iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object t : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                LookupElement it = (LookupElement)t;
                boolean bl = false;
                it = TuplesKt.to((Object)it, (Object)CollectionsKt.listOf((Object)com.intellij.openapi.util.Pair.create((Object)"ml_rank", (Object)"NONE")));
                bl = false;
                map.put(it.getFirst(), it.getSecond());
            }
            return destination$iv$iv;
        }
        if (this.hasUnknownFeatures(items)) {
            Iterable<? extends LookupElement> $this$associate$iv = items;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
            Iterable<? extends LookupElement> $this$associateTo$iv$iv = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (LookupElement lookupElement : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                LookupElement it = lookupElement;
                boolean bl = false;
                it = TuplesKt.to((Object)it, (Object)CollectionsKt.listOf((Object)com.intellij.openapi.util.Pair.create((Object)"ml_rank", (Object)"UNDEFINED")));
                bl = false;
                map.put(it.getFirst(), it.getSecond());
            }
            return destination$iv$iv;
        }
        if (!this.isCacheValid(items)) {
            Iterable<? extends LookupElement> $this$associate$iv = items;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
            Iterable<? extends LookupElement> $this$associateTo$iv$iv = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (LookupElement lookupElement : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                LookupElement it = lookupElement;
                boolean bl = false;
                it = TuplesKt.to((Object)it, (Object)CollectionsKt.listOf((Object)com.intellij.openapi.util.Pair.create((Object)"ml_rank", (Object)"INVALID_CACHE")));
                bl = false;
                map.put(it.getFirst(), it.getSecond());
            }
            return destination$iv$iv;
        }
        Iterable<? extends LookupElement> $this$associate$iv = items;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
        Iterable<? extends LookupElement> $this$associateTo$iv$iv = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (LookupElement lookupElement : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            LookupElement it = lookupElement;
            boolean bl = false;
            boolean bl2 = false;
            List result = new ArrayList();
            ItemRankInfo cached = this.cachedScore.get(it);
            if (cached != null) {
                com.intellij.openapi.util.Pair pair = com.intellij.openapi.util.Pair.create((Object)"ml_rank", (Object)cached.getMlRank());
                Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.create(FeatureUtils.ML_RANK, cached.mlRank)");
                result.add(pair);
                com.intellij.openapi.util.Pair pair2 = com.intellij.openapi.util.Pair.create((Object)"before_rerank_order", (Object)cached.getPositionBefore());
                Intrinsics.checkExpressionValueIsNotNull((Object)pair2, (String)"Pair.create(FeatureUtils\u2026R, cached.positionBefore)");
                result.add(pair2);
            }
            Pair pair = TuplesKt.to((Object)it, (Object)result);
            boolean bl3 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCacheValid(Iterable<? extends LookupElement> items) {
        void $this$mapTo$iv$iv;
        Iterable<? extends LookupElement> $this$map$iv = items;
        boolean $i$f$map = false;
        Iterable<? extends LookupElement> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LookupElement lookupElement = (LookupElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ItemRankInfo itemRankInfo = this.cachedScore.get(it);
            Integer n = itemRankInfo != null ? Integer.valueOf(itemRankInfo.getPrefixLength()) : null;
            collection.add(n);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv)).size() == 1;
    }

    private final boolean hasUnknownFeatures(Iterable<? extends LookupElement> items) {
        boolean bl;
        block3: {
            Iterable<? extends LookupElement> $this$any$iv = items;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator<? extends LookupElement> iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    ItemRankInfo score2;
                    LookupElement element$iv;
                    LookupElement it = element$iv = iterator.next();
                    boolean bl2 = false;
                    ItemRankInfo itemRankInfo = score2 = this.cachedScore.get(it);
                    boolean bl3 = (itemRankInfo != null ? itemRankInfo.getMlRank() : null) == null;
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<LookupElement> sort(@NotNull Iterable<? extends LookupElement> items, @NotNull CompletionParameters parameters) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        LookupEx lookupEx = LookupManager.getActiveLookup((Editor)parameters.getEditor());
        if (!(lookupEx instanceof LookupImpl)) {
            lookupEx = null;
        }
        LookupImpl lookupImpl = (LookupImpl)lookupEx;
        if (lookupImpl == null) {
            return items;
        }
        LookupImpl lookup = lookupImpl;
        MutableLookupStorage mutableLookupStorage = MutableLookupStorage.Companion.get(lookup);
        if (mutableLookupStorage == null) {
            return items;
        }
        MutableLookupStorage lookupStorage = mutableLookupStorage;
        if (!lookupStorage.shouldComputeFeatures()) {
            return items;
        }
        long startedTimestamp = System.currentTimeMillis();
        int queryLength = LookupExtensionsKt.queryLength(lookup);
        String prefix = LookupExtensionsKt.prefix((Lookup)lookup);
        if (this.sortingRestrictions == null) {
            this.sortingRestrictions = SortingRestriction.Companion.forLanguage(lookupStorage.getLanguage());
        }
        boolean bl = false;
        Map element2score = new LinkedHashMap();
        List elements = CollectionsKt.toList(items);
        Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)elements);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            IndexedValue it = (IndexedValue)element$iv$iv;
            boolean bl2 = false;
            Pair pair = TuplesKt.to((Object)it.getValue(), (Object)it.getIndex());
            boolean bl3 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map positionsBefore = destination$iv$iv;
        this.tryFillFromCache(element2score, elements, queryLength);
        List itemsForScoring = element2score.size() == elements.size() ? CollectionsKt.emptyList() : elements;
        this.calculateScores(element2score, itemsForScoring, positionsBefore, queryLength, prefix, lookup, lookupStorage, parameters);
        Iterable<LookupElement> finalRanking = this.sortByMlScores(elements, element2score, positionsBefore, lookupStorage);
        lookupStorage.getPerformanceTracker().sortingPerformed(itemsForScoring.size(), System.currentTimeMillis() - startedTimestamp);
        return finalRanking;
    }

    /*
     * WARNING - void declaration
     */
    private final void tryFillFromCache(Map<LookupElement, Double> element2score, List<? extends LookupElement> items, int queryLength) {
        boolean bl = false;
        for (LookupElement element : (Iterable)items) {
            void position;
            ItemRankInfo cachedInfo = this.getCachedRankInfo(element, queryLength, (int)position);
            if (cachedInfo == null) {
                return;
            }
            element2score.put(element, cachedInfo.getMlRank());
            ++position;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateScores(Map<LookupElement, Double> element2score, List<? extends LookupElement> items, Map<LookupElement, Integer> positionsBefore, int queryLength, String prefix, LookupImpl lookup, MutableLookupStorage lookupStorage, CompletionParameters parameters) {
        if (items.isEmpty()) {
            return;
        }
        RankingModelWrapper rankingModel = lookupStorage.getModel();
        Project project = lookup.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"lookup.project");
        lookupStorage.initUserFactors(project);
        Map<String, Object> commonSessionFactors = SessionFactorsUtils.INSTANCE.updateSessionFactors(lookupStorage, items);
        Map<String, String> contextFactors = lookupStorage.getContextFactors();
        RankingFeatures features2 = new RankingFeatures(lookupStorage.getUserFactors(), contextFactors, commonSessionFactors);
        Map map = lookup.getRelevanceObjects((Iterable)items, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"lookup.getRelevanceObjects(items, false)");
        Map relevanceObjects = map;
        ModelTimeTracker tracker = new ModelTimeTracker();
        for (LookupElement lookupElement : items) {
            void relevance;
            int position = ((Number)MapsKt.getValue(positionsBefore, (Object)lookupElement)).intValue();
            List list = relevanceObjects.getOrDefault(lookupElement, CollectionsKt.emptyList());
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"relevanceObjects.getOrDe\u2026ult(element, emptyList())");
            Pair<Map<String, Object>, Map<String, Object>> pair = RelevanceUtil.INSTANCE.asRelevanceMaps(list);
            Map map2 = (Map)pair.component1();
            Map additional = (Map)pair.component2();
            SessionFactorsUtils.INSTANCE.saveElementFactorsTo(additional, lookupStorage, lookupElement);
            this.calculateAdditionalFeaturesTo(additional, lookupElement, queryLength, prefix.length(), position, items.size(), parameters);
            lookupStorage.getPerformanceTracker().trackElementFeaturesCalculation("prefix", (Function0)new Function0<Unit>(lookupElement, prefix, additional){
                final /* synthetic */ LookupElement $element;
                final /* synthetic */ String $prefix;
                final /* synthetic */ Map $additional;

                public final void invoke() {
                    PrefixMatchingUtil.INSTANCE.calculateFeatures(this.$element, this.$prefix, this.$additional);
                }
                {
                    this.$element = lookupElement;
                    this.$prefix = string;
                    this.$additional = map;
                    super(0);
                }
            });
            Double score2 = tracker.measure((Function0<Double>)((Function0)new Function0<Double>(this, features2, (Map)relevance, additional, rankingModel, lookupElement, position, queryLength){
                final /* synthetic */ MLSorter this$0;
                final /* synthetic */ RankingFeatures $features;
                final /* synthetic */ Map $relevance;
                final /* synthetic */ Map $additional;
                final /* synthetic */ RankingModelWrapper $rankingModel;
                final /* synthetic */ LookupElement $element;
                final /* synthetic */ int $position;
                final /* synthetic */ int $queryLength;

                @Nullable
                public final Double invoke() {
                    RankingFeatures elementFeatures = this.$features.withElementFeatures(this.$relevance, this.$additional);
                    Double score2 = MLSorter.access$calculateElementScore(this.this$0, this.$rankingModel, this.$element, this.$position, elementFeatures, this.$queryLength);
                    MLSorter.access$getSortingRestrictions$p(this.this$0).itemScored(elementFeatures);
                    return score2;
                }
                {
                    this.this$0 = mLSorter;
                    this.$features = rankingFeatures;
                    this.$relevance = map;
                    this.$additional = map2;
                    this.$rankingModel = rankingModelWrapper;
                    this.$element = lookupElement;
                    this.$position = n;
                    this.$queryLength = n2;
                    super(0);
                }
            }));
            element2score.put(lookupElement, score2);
            additional.putAll(relevance);
            lookupStorage.fireElementScored(lookupElement, additional, score2);
        }
        tracker.finished(lookupStorage.getPerformanceTracker());
    }

    /*
     * Unable to fully structure code
     */
    private final Iterable<LookupElement> sortByMlScores(List<? extends LookupElement> items, Map<LookupElement, Double> element2score, Map<LookupElement, Integer> positionsBefore, MutableLookupStorage lookupStorage) {
        block8: {
            $this$none$iv = element2score.values();
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                v0 = true;
            } else {
                for (T element$iv : $this$none$iv) {
                    it = (Double)element$iv;
                    $i$a$-none-MLSorter$sortByMlScores$mlScoresUsed$1 = false;
                    if (!(it == null)) continue;
                    v0 = false;
                    break block8;
                }
                v0 = true;
            }
        }
        if (!v0) ** GOTO lbl-1000
        v1 = this.sortingRestrictions;
        if (v1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sortingRestrictions");
        }
        if (v1.shouldSort()) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = mlScoresUsed = false;
        }
        if (MLSorter.LOG.isDebugEnabled()) {
            MLSorter.LOG.debug("ML sorting in completion used=" + mlScoresUsed + " for language=" + lookupStorage.getLanguage().getID());
        }
        if (mlScoresUsed) {
            lookupStorage.fireReorderedUsingMLScores();
            topItemsCount = this.reorderOnlyTopItems != false ? 5 : 0x7FFFFFFF;
            return this.addDiagnosticsIfNeeded(this.reorderByMLScores((Iterable<? extends LookupElement>)items, element2score, topItemsCount), positionsBefore, topItemsCount);
        }
        return items;
    }

    private final void calculateAdditionalFeaturesTo(Map<String, Object> additionalMap, LookupElement lookupElement, int oldQueryLength, int prefixLength, int position, int itemsCount, CompletionParameters parameters) {
        additionalMap.put("position", position);
        additionalMap.put("relative_position", (double)position / (double)itemsCount);
        additionalMap.put("query_length", oldQueryLength);
        additionalMap.put("prefix_length", prefixLength);
        additionalMap.put("result_length", lookupElement.getLookupString().length());
        additionalMap.put("auto_popup", parameters.isAutoPopup());
        additionalMap.put("completion_type", parameters.getCompletionType().toString());
        additionalMap.put("invocation_count", parameters.getInvocationCount());
    }

    private final Iterable<LookupElement> reorderByMLScores(@NotNull Iterable<? extends LookupElement> $this$reorderByMLScores, Map<LookupElement, Double> element2score, int toReorder) {
        Iterable<? extends LookupElement> $this$sortedByDescending$iv = $this$reorderByMLScores;
        boolean $i$f$sortedByDescending = false;
        Iterable<? extends LookupElement> iterable = $this$sortedByDescending$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(element2score){
            final /* synthetic */ Map $element2score$inlined;
            {
                this.$element2score$inlined = map;
            }

            public final int compare(T a, T b) {
                boolean bl = false;
                LookupElement it = (LookupElement)b;
                boolean bl2 = false;
                Comparable comparable = (Double)MapsKt.getValue((Map)this.$element2score$inlined, (Object)it);
                it = (LookupElement)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = (Double)MapsKt.getValue((Map)this.$element2score$inlined, (Object)it);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        };
        Iterable iterable2 = CollectionsKt.take((Iterable)CollectionsKt.sortedWith(iterable, (Comparator)comparator), (int)toReorder);
        boolean bl2 = false;
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        LinkedHashSet result = (LinkedHashSet)CollectionsKt.toCollection((Iterable)iterable2, (Collection)linkedHashSet);
        CollectionsKt.addAll((Collection)result, $this$reorderByMLScores);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<LookupElement> addDiagnosticsIfNeeded(@NotNull Iterable<? extends LookupElement> $this$addDiagnosticsIfNeeded, Map<LookupElement, Integer> positionsBefore, int reordered) {
        CompletionMLRankingSettings completionMLRankingSettings = CompletionMLRankingSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)completionMLRankingSettings, (String)"CompletionMLRankingSettings.getInstance()");
        if (completionMLRankingSettings.isShowDiffEnabled()) {
            Iterable<LookupElement> $this$forEachIndexed$iv = $this$addDiagnosticsIfNeeded;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (LookupElement item$iv : $this$forEachIndexed$iv) {
                void element;
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                LookupElement lookupElement = item$iv;
                int position = n2;
                boolean bl2 = false;
                int before = ((Number)MapsKt.getValue(positionsBefore, (Object)element)).intValue();
                if (before >= reordered && position >= reordered) continue;
                this.updateDiffValue((LookupElement)element, position - before);
            }
        }
        return $this$addDiagnosticsIfNeeded;
    }

    private final ItemRankInfo getCachedRankInfo(LookupElement element, int prefixLength, int position) {
        ItemRankInfo cached = this.cachedScore.get(element);
        if (cached != null && prefixLength == cached.getPrefixLength() && cached.getPositionBefore() == position) {
            return cached;
        }
        return null;
    }

    private final Double calculateElementScore(RankingModelWrapper ranker, LookupElement element, int position, RankingFeatures features2, int prefixLength) {
        Double mlRank = ranker != null && ranker.canScore(features2) ? ranker.score(features2) : null;
        ItemRankInfo info = new ItemRankInfo(position, mlRank, prefixLength);
        this.cachedScore.put(element, info);
        return info.getMlRank();
    }

    private final void updateDiffValue(@NotNull LookupElement $this$updateDiffValue, int newValue) {
        AtomicInteger atomicInteger = (AtomicInteger)$this$updateDiffValue.getUserData(PositionDiffArrowInitializer.Companion.getPOSITION_DIFF_KEY());
        if (atomicInteger == null) {
            AtomicInteger atomicInteger2 = new AtomicInteger();
            boolean bl = false;
            boolean bl2 = false;
            AtomicInteger $this$apply = atomicInteger2;
            boolean bl3 = false;
            $this$updateDiffValue.putUserData(PositionDiffArrowInitializer.Companion.getPOSITION_DIFF_KEY(), (Object)$this$apply);
            atomicInteger = atomicInteger2;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)atomicInteger, (String)"getUserData(PositionDiff\u2026OSITION_DIFF_KEY, this) }");
        AtomicInteger diff = atomicInteger;
        diff.set(newValue);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance((String)"#com.intellij.completion.sorting.MLSorter");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#com\u2026letion.sorting.MLSorter\")");
        LOG = logger;
    }

    public static final /* synthetic */ SortingRestriction access$getSortingRestrictions$p(MLSorter $this) {
        SortingRestriction sortingRestriction = $this.sortingRestrictions;
        if (sortingRestriction == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sortingRestrictions");
        }
        return sortingRestriction;
    }

    public static final /* synthetic */ void access$setSortingRestrictions$p(MLSorter $this, SortingRestriction sortingRestriction) {
        $this.sortingRestrictions = sortingRestriction;
    }

    public static final /* synthetic */ Double access$calculateElementScore(MLSorter $this, RankingModelWrapper ranker, LookupElement element, int position, RankingFeatures features2, int prefixLength) {
        return $this.calculateElementScore(ranker, element, position, features2, prefixLength);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000e\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/completion/sorting/MLSorter$ModelTimeTracker;", "", "()V", "itemsScored", "", "timeSpent", "", "finished", "", "performanceTracker", "Lcom/intellij/stats/PerformanceTracker;", "measure", "", "scoringFun", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Double;", "intellij.statsCollector"})
    private static final class ModelTimeTracker {
        private int itemsScored;
        private long timeSpent;

        @Nullable
        public final Double measure(@NotNull Function0<Double> scoringFun) {
            Intrinsics.checkParameterIsNotNull(scoringFun, (String)"scoringFun");
            long start = System.nanoTime();
            Double result = (Double)scoringFun.invoke();
            if (result != null) {
                ++this.itemsScored;
                this.timeSpent += System.nanoTime() - start;
            }
            return result;
        }

        public final void finished(@NotNull PerformanceTracker performanceTracker) {
            Intrinsics.checkParameterIsNotNull((Object)performanceTracker, (String)"performanceTracker");
            if (this.itemsScored != 0) {
                performanceTracker.itemsScored(this.itemsScored, TimeUnit.NANOSECONDS.toMillis(this.timeSpent));
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\t"}, d2={"Lcom/intellij/completion/sorting/MLSorter$SortingRestriction;", "", "itemScored", "", "features", "Lcom/intellij/completion/sorting/RankingFeatures;", "shouldSort", "", "Companion", "intellij.statsCollector"})
    public static interface SortingRestriction {
        public static final Companion Companion = Companion.$$INSTANCE;

        public void itemScored(@NotNull RankingFeatures var1);

        public boolean shouldSort();

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/completion/sorting/MLSorter$SortingRestriction$Companion;", "", "()V", "forLanguage", "Lcom/intellij/completion/sorting/MLSorter$SortingRestriction;", "language", "Lcom/intellij/lang/Language;", "intellij.statsCollector"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            @NotNull
            public final SortingRestriction forLanguage(@NotNull Language language) {
                Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
                if (StringsKt.equals((String)language.getID(), (String)"Java", (boolean)true)) {
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                    if (!application.isUnitTestMode()) {
                        return new SortOnlyWithRecommendersScore();
                    }
                }
                return new SortAll();
            }

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/completion/sorting/MLSorter$SortAll;", "Lcom/intellij/completion/sorting/MLSorter$SortingRestriction;", "()V", "itemScored", "", "features", "Lcom/intellij/completion/sorting/RankingFeatures;", "shouldSort", "", "intellij.statsCollector"})
    private static final class SortAll
    implements SortingRestriction {
        @Override
        public boolean shouldSort() {
            return true;
        }

        @Override
        public void itemScored(@NotNull RankingFeatures features2) {
            Intrinsics.checkParameterIsNotNull((Object)features2, (String)"features");
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/completion/sorting/MLSorter$SortOnlyWithRecommendersScore;", "Lcom/intellij/completion/sorting/MLSorter$SortingRestriction;", "()V", "recommendersScoreFound", "", "itemScored", "", "features", "Lcom/intellij/completion/sorting/RankingFeatures;", "shouldSort", "Companion", "intellij.statsCollector"})
    private static final class SortOnlyWithRecommendersScore
    implements SortingRestriction {
        private boolean recommendersScoreFound;
        private static final List<String> REC_FEATURES_NAMES;
        public static final Companion Companion;

        /*
         * WARNING - void declaration
         */
        @Override
        public void itemScored(@NotNull RankingFeatures features2) {
            Intrinsics.checkParameterIsNotNull((Object)features2, (String)"features");
            if (!this.recommendersScoreFound) {
                boolean bl;
                boolean bl2;
                block4: {
                    void $this$any$iv;
                    Iterable iterable = REC_FEATURES_NAMES;
                    SortOnlyWithRecommendersScore sortOnlyWithRecommendersScore = this;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            if (!features2.hasFeature(it)) continue;
                            bl2 = true;
                            break block4;
                        }
                        bl2 = false;
                    }
                }
                sortOnlyWithRecommendersScore.recommendersScoreFound = bl = bl2;
            }
        }

        @Override
        public boolean shouldSort() {
            return this.recommendersScoreFound;
        }

        static {
            Companion = new Companion(null);
            REC_FEATURES_NAMES = CollectionsKt.listOf((Object[])new String[]{"ml_rec-instances_probability", "ml_rec-statics2_probability"});
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/completion/sorting/MLSorter$SortOnlyWithRecommendersScore$Companion;", "", "()V", "REC_FEATURES_NAMES", "", "", "intellij.statsCollector"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/completion/sorting/MLSorter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "REORDER_ONLY_TOP_K", "", "intellij.statsCollector"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

