/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;

public final class IoTestUtil {
    public static final boolean isSymLinkCreationSupported = SystemInfo.isUnix || SystemInfo.isWinVistaOrNewer && IoTestUtil.canCreateSymlinks();
    private static final String[] UNICODE_PARTS = new String[]{"\u042e\u043d\u0438\u043a\u043e\u0434\u0435", "\u00da\u00f1\u00ed\u00e7\u00f8d\u00ea"};

    private IoTestUtil() {
    }

    @Nullable
    public static String getUnicodeName() {
        return IoTestUtil.filterParts(PathUtil::isValidFileName);
    }

    @Nullable
    public static String getUnicodeName(String forEncoding) {
        return IoTestUtil.filterParts(Charset.forName(forEncoding).newEncoder()::canEncode);
    }

    private static String filterParts(Predicate<? super String> predicate) {
        return StringUtil.nullize((String)Stream.of(UNICODE_PARTS).filter(predicate).collect(Collectors.joining("_")));
    }

    @NotNull
    public static File getTempDirectory() {
        File dir = new File(FileUtil.getTempDirectory());
        File file2 = dir = IoTestUtil.expandWindowsPath(dir);
        if (file2 == null) {
            IoTestUtil.$$$reportNull$$$0(0);
        }
        return file2;
    }

    private static File expandWindowsPath(File file2) {
        if (SystemInfo.isWindows && file2.getPath().indexOf(126) > 0) {
            try {
                return file2.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file2;
    }

    @NotNull
    public static File createSymLink(@NotNull String target, @NotNull String link) {
        if (target == null) {
            IoTestUtil.$$$reportNull$$$0(1);
        }
        if (link == null) {
            IoTestUtil.$$$reportNull$$$0(2);
        }
        return IoTestUtil.createSymLink(target, link, true);
    }

    @NotNull
    public static File createSymLink(@NotNull String target, @NotNull String link, boolean shouldExist) {
        if (target == null) {
            IoTestUtil.$$$reportNull$$$0(3);
        }
        if (link == null) {
            IoTestUtil.$$$reportNull$$$0(4);
        }
        File linkFile = IoTestUtil.getFullLinkPath(link);
        try {
            Files.createSymbolicLink(linkFile.toPath(), FileSystems.getDefault().getPath(target, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Assert.assertEquals((String)("target=" + target + ", link=" + linkFile), (Object)shouldExist, (Object)linkFile.exists());
        File file2 = linkFile;
        if (file2 == null) {
            IoTestUtil.$$$reportNull$$$0(5);
        }
        return file2;
    }

    public static void assumeSymLinkCreationIsSupported() throws AssumptionViolatedException {
        Assume.assumeTrue((String)("Can't create symlinks on " + SystemInfo.getOsNameAndVersion()), (boolean)isSymLinkCreationSupported);
    }

    public static void assumeWindows() throws AssumptionViolatedException {
        Assume.assumeTrue((String)("Need Windows, can't run on " + SystemInfo.OS_NAME), (boolean)SystemInfo.isWindows);
    }

    public static void assumeUnix() throws AssumptionViolatedException {
        Assume.assumeTrue((String)("Need Unix, can't run on " + SystemInfo.OS_NAME), (boolean)SystemInfo.isUnix);
    }

    @NotNull
    public static File createJunction(@NotNull String target, @NotNull String junction) {
        if (target == null) {
            IoTestUtil.$$$reportNull$$$0(6);
        }
        if (junction == null) {
            IoTestUtil.$$$reportNull$$$0(7);
        }
        Assert.assertTrue((boolean)SystemInfo.isWindows);
        File targetFile = new File(target);
        Assert.assertTrue((String)targetFile.getPath(), (boolean)targetFile.isDirectory());
        File junctionFile = IoTestUtil.getFullLinkPath(junction);
        IoTestUtil.runCommand("cmd", "/C", "mklink", "/J", junctionFile.getPath(), targetFile.getPath());
        Assert.assertTrue((String)("target=" + targetFile + ", link=" + junctionFile), (boolean)junctionFile.isDirectory());
        File file2 = junctionFile;
        if (file2 == null) {
            IoTestUtil.$$$reportNull$$$0(8);
        }
        return file2;
    }

    public static void deleteJunction(@NotNull String junction) {
        if (junction == null) {
            IoTestUtil.$$$reportNull$$$0(9);
        }
        Assert.assertTrue((boolean)SystemInfo.isWindows);
        Assert.assertTrue((boolean)new File(junction).delete());
    }

    @NotNull
    public static File createSubst(@NotNull String target) {
        if (target == null) {
            IoTestUtil.$$$reportNull$$$0(10);
        }
        Assert.assertTrue((boolean)SystemInfo.isWindows);
        File targetFile = new File(target);
        Assert.assertTrue((String)targetFile.getPath(), (boolean)targetFile.isDirectory());
        String substRoot = IoTestUtil.getFirstFreeDriveLetter() + ":";
        IoTestUtil.runCommand("subst", substRoot, targetFile.getPath());
        File rootFile = new File(substRoot + "\\");
        Assert.assertTrue((String)("target=" + targetFile + ", subst=" + rootFile), (boolean)rootFile.isDirectory());
        File file2 = rootFile;
        if (file2 == null) {
            IoTestUtil.$$$reportNull$$$0(11);
        }
        return file2;
    }

    public static void deleteSubst(@NotNull String substRoot) {
        if (substRoot == null) {
            IoTestUtil.$$$reportNull$$$0(12);
        }
        IoTestUtil.runCommand("subst", StringUtil.trimEnd((String)substRoot, (String)"\\"), "/d");
    }

    private static char getFirstFreeDriveLetter() {
        Set roots = StreamSupport.stream(FileSystems.getDefault().getRootDirectories().spliterator(), false).map(root -> Character.valueOf(StringUtil.toUpperCase((String)root.toString()).charAt(0))).collect(Collectors.toSet());
        Logger.getInstance(IoTestUtil.class).debug("logical drives: " + roots);
        for (char c = 'E'; c <= 'Z'; c = (char)(c + '\u0001')) {
            if (roots.contains(Character.valueOf(c))) continue;
            return c;
        }
        throw new RuntimeException("No free roots");
    }

    private static File getFullLinkPath(String link) {
        File linkFile = new File(link);
        if (!linkFile.isAbsolute()) {
            linkFile = new File(IoTestUtil.getTempDirectory(), link);
        }
        Assert.assertTrue((String)link, (!linkFile.exists() || linkFile.delete() ? 1 : 0) != 0);
        File parentDir = linkFile.getParentFile();
        Assert.assertTrue((String)("link=" + link + ", parent=" + parentDir), (parentDir != null && (parentDir.isDirectory() || parentDir.mkdirs()) ? 1 : 0) != 0);
        return linkFile;
    }

    private static void runCommand(String ... command) {
        try {
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectErrorStream(true);
            Process process = builder.start();
            StringBuilder output = new StringBuilder();
            Future<?> thread = ProcessIOExecutorService.INSTANCE.submit(() -> {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        output.append(line).append('\n');
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            int ret = process.waitFor();
            thread.get();
            if (ret != 0) {
                throw new RuntimeException(builder.command() + "\nresult: " + ret + "\noutput:\n" + output);
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertTimestampsEqual(long expected, long actual) {
        long roundedExpected = expected / 1000L * 1000L;
        long roundedActual = actual / 1000L * 1000L;
        Assert.assertEquals((String)("expected: " + expected + ", actual: " + actual), (long)roundedExpected, (long)roundedActual);
    }

    public static void assertTimestampsNotEqual(long expected, long actual) {
        long roundedExpected = expected / 1000L * 1000L;
        long roundedActual = actual / 1000L * 1000L;
        Assert.assertTrue((String)("(un)expected: " + expected + ", actual: " + actual), (roundedExpected != roundedActual ? 1 : 0) != 0);
    }

    @NotNull
    public static File createTestJar(@NotNull File jarFile) {
        if (jarFile == null) {
            IoTestUtil.$$$reportNull$$$0(13);
        }
        return IoTestUtil.createTestJar(jarFile, "META-INF/MANIFEST.MF", "");
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static File createTestJar(@NotNull File jarFile, String ... namesAndTexts) {
        if (jarFile == null) {
            IoTestUtil.$$$reportNull$$$0(14);
        }
        if (namesAndTexts == null) {
            IoTestUtil.$$$reportNull$$$0(15);
        }
        ZipOutputStream stream = new ZipOutputStream(new FileOutputStream(jarFile));
        for (int i = 0; i < namesAndTexts.length; i += 2) {
            stream.putNextEntry(new ZipEntry(namesAndTexts[i]));
            if (namesAndTexts[i + 1] != null) {
                stream.write(namesAndTexts[i + 1].getBytes(StandardCharsets.UTF_8));
            }
            stream.closeEntry();
        }
        File file2 = jarFile;
        stream.close();
        File file3 = file2;
        if (file3 == null) {
            IoTestUtil.$$$reportNull$$$0(16);
        }
        return file3;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    @NotNull
    public static File createTestJar(@NotNull File jarFile, @NotNull Collection<? extends Pair<String, byte[]>> namesAndContents) {
        if (jarFile == null) {
            IoTestUtil.$$$reportNull$$$0(17);
        }
        if (namesAndContents == null) {
            IoTestUtil.$$$reportNull$$$0(18);
        }
        ZipOutputStream stream = new ZipOutputStream(new FileOutputStream(jarFile));
        for (Pair<String, byte[]> p : namesAndContents) {
            String name = (String)p.first;
            byte[] content = (byte[])p.second;
            stream.putNextEntry(new ZipEntry(name));
            stream.write(content);
            stream.closeEntry();
        }
        File file2 = jarFile;
        stream.close();
        Object object = file2;
        if (object == null) {
            IoTestUtil.$$$reportNull$$$0(19);
        }
        return object;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static File createTestJar(@NotNull File jarFile, @NotNull File root) {
        if (jarFile == null) {
            IoTestUtil.$$$reportNull$$$0(20);
        }
        if (root == null) {
            IoTestUtil.$$$reportNull$$$0(21);
        }
        ZipOutputStream stream = new ZipOutputStream(new FileOutputStream(jarFile));
        FileUtil.visitFiles((File)root, file2 -> {
            if (file2.isFile()) {
                String path = FileUtil.toSystemIndependentName((String)Objects.requireNonNull(FileUtil.getRelativePath((File)root, (File)file2)));
                try {
                    stream.putNextEntry(new ZipEntry(path));
                    try (FileInputStream is = new FileInputStream((File)file2);){
                        FileUtil.copy((InputStream)is, (OutputStream)stream);
                    }
                    stream.closeEntry();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return true;
        });
        File file3 = jarFile;
        stream.close();
        File file4 = file3;
        if (file4 == null) {
            IoTestUtil.$$$reportNull$$$0(22);
        }
        return file4;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @NotNull
    public static File createTestDir(@NotNull String name) {
        if (name == null) {
            IoTestUtil.$$$reportNull$$$0(23);
        }
        return IoTestUtil.createTestDir(IoTestUtil.getTempDirectory(), name);
    }

    @NotNull
    public static File createTestDir(@NotNull File parent, @NotNull String name) {
        if (parent == null) {
            IoTestUtil.$$$reportNull$$$0(24);
        }
        if (name == null) {
            IoTestUtil.$$$reportNull$$$0(25);
        }
        File dir = new File(parent, name);
        Assert.assertTrue((String)dir.getPath(), (boolean)dir.mkdirs());
        File file2 = dir;
        if (file2 == null) {
            IoTestUtil.$$$reportNull$$$0(26);
        }
        return file2;
    }

    @NotNull
    public static File createTestFile(@NotNull String name) {
        if (name == null) {
            IoTestUtil.$$$reportNull$$$0(27);
        }
        return IoTestUtil.createTestFile(name, null);
    }

    @NotNull
    public static File createTestFile(@NotNull String name, @Nullable String content) {
        if (name == null) {
            IoTestUtil.$$$reportNull$$$0(28);
        }
        return IoTestUtil.createTestFile(IoTestUtil.getTempDirectory(), name, content);
    }

    @NotNull
    public static File createTestFile(@NotNull File parent, @NotNull String name) {
        if (parent == null) {
            IoTestUtil.$$$reportNull$$$0(29);
        }
        if (name == null) {
            IoTestUtil.$$$reportNull$$$0(30);
        }
        return IoTestUtil.createTestFile(parent, name, null);
    }

    @NotNull
    public static File createTestFile(@NotNull File parent, @NotNull String name, @Nullable String content) {
        File file2;
        if (parent == null) {
            IoTestUtil.$$$reportNull$$$0(31);
        }
        if (name == null) {
            IoTestUtil.$$$reportNull$$$0(32);
        }
        try {
            Assert.assertTrue((String)parent.getPath(), (parent.isDirectory() || parent.mkdirs() ? 1 : 0) != 0);
            File file3 = new File(parent, name);
            Assert.assertTrue((String)file3.getPath(), (boolean)file3.createNewFile());
            if (content != null) {
                FileUtil.writeToFile((File)file3, (String)content);
            }
            file2 = file3;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (file2 == null) {
            IoTestUtil.$$$reportNull$$$0(33);
        }
        return file2;
    }

    public static void delete(File ... files) {
        for (File file2 : files) {
            if (file2 == null) continue;
            FileUtil.delete((File)file2);
        }
    }

    public static void updateFile(@NotNull File file2, String content) {
        if (file2 == null) {
            IoTestUtil.$$$reportNull$$$0(34);
        }
        try {
            FileUtil.writeToFile((File)file2, (String)content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean canCreateSymlinks() {
        try {
            Path target = Files.createTempFile("IOTestUtil_link_target.", ".txt", new FileAttribute[0]);
            try {
                boolean bl;
                Path link = target.getParent().resolve("IOTestUtil_link");
                try {
                    Files.createSymbolicLink(link, target.getFileName(), new FileAttribute[0]);
                    bl = true;
                }
                catch (Throwable throwable) {
                    Files.deleteIfExists(link);
                    throw throwable;
                }
                Files.deleteIfExists(link);
                return bl;
            }
            finally {
                Files.delete(target);
            }
        }
        catch (IOException ignored) {
            return false;
        }
    }

    @NotNull
    public static String toLocalUncPath(@NotNull String localPath) {
        if (localPath == null) {
            IoTestUtil.$$$reportNull$$$0(35);
        }
        String string = "\\\\127.0.0.1\\" + localPath.charAt(0) + '$' + localPath.substring(2);
        if (string == null) {
            IoTestUtil.$$$reportNull$$$0(36);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/IoTestUtil";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "junction";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substRoot";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesAndTexts";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesAndContents";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 24: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirectory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/IoTestUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSymLink";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createJunction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubst";
                break;
            }
            case 16: 
            case 19: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestJar";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestDir";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestFile";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "toLocalUncPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSymLink";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createJunction";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deleteJunction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createSubst";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deleteSubst";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createTestJar";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createTestDir";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createTestFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "updateFile";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "toLocalUncPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

