/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.io.DirectoryContentBuilder;
import com.intellij.util.io.DirectoryContentSpec;
import com.intellij.util.io.FileTextMatcher;
import com.intellij.util.io.impl.DirectoryContentBuilderImpl;
import com.intellij.util.io.impl.DirectoryContentSpecImpl;
import com.intellij.util.io.impl.DirectoryContentSpecImplKt;
import com.intellij.util.io.impl.DirectorySpec;
import com.intellij.util.io.impl.ZipSpec;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006H\u0086\b\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\"\u0010\n\u001a\u00020\u00012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006H\u0086\b\u001a\u001e\u0010\u000b\u001a\u00020\u0005*\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0001\u00a8\u0006\u0012"}, d2={"directoryContent", "Lcom/intellij/util/io/DirectoryContentSpec;", "content", "Lkotlin/Function1;", "Lcom/intellij/util/io/DirectoryContentBuilder;", "", "Lkotlin/ExtensionFunctionType;", "directoryContentOf", "dir", "Ljava/nio/file/Path;", "zipFile", "assertMatches", "Ljava/io/File;", "spec", "fileTextMatcher", "Lcom/intellij/util/io/FileTextMatcher;", "generateInVirtualTempDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.testFramework"})
public final class DirectoryContentSpecKt {
    @NotNull
    public static final DirectoryContentSpec directoryContent(@NotNull Function1<? super DirectoryContentBuilder, Unit> content) {
        int $i$f$directoryContent = 0;
        Intrinsics.checkParameterIsNotNull(content, (String)"content");
        DirectoryContentBuilderImpl builder = new DirectoryContentBuilderImpl(new DirectorySpec());
        content.invoke((Object)builder);
        return builder.getResult();
    }

    @NotNull
    public static final DirectoryContentSpec zipFile(@NotNull Function1<? super DirectoryContentBuilder, Unit> content) {
        int $i$f$zipFile = 0;
        Intrinsics.checkParameterIsNotNull(content, (String)"content");
        DirectoryContentBuilderImpl builder = new DirectoryContentBuilderImpl(new ZipSpec());
        content.invoke((Object)builder);
        return builder.getResult();
    }

    @NotNull
    public static final DirectoryContentSpec directoryContentOf(@NotNull Path dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        return DirectoryContentSpecImplKt.createSpecByDirectory(dir);
    }

    @JvmOverloads
    public static final void assertMatches(@NotNull File $this$assertMatches, @NotNull DirectoryContentSpec spec, @NotNull FileTextMatcher fileTextMatcher) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertMatches, (String)"$this$assertMatches");
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        Intrinsics.checkParameterIsNotNull((Object)fileTextMatcher, (String)"fileTextMatcher");
        DirectoryContentSpecImplKt.assertDirectoryContentMatches($this$assertMatches, (DirectoryContentSpecImpl)spec, "", fileTextMatcher);
    }

    public static /* synthetic */ void assertMatches$default(File file2, DirectoryContentSpec directoryContentSpec, FileTextMatcher fileTextMatcher, int n, Object object) {
        if ((n & 2) != 0) {
            fileTextMatcher = FileTextMatcher.Companion.exact();
        }
        DirectoryContentSpecKt.assertMatches(file2, directoryContentSpec, fileTextMatcher);
    }

    @JvmOverloads
    public static final void assertMatches(@NotNull File $this$assertMatches, @NotNull DirectoryContentSpec spec) {
        DirectoryContentSpecKt.assertMatches$default($this$assertMatches, spec, null, 2, null);
    }

    @NotNull
    public static final VirtualFile generateInVirtualTempDir(@NotNull DirectoryContentSpec $this$generateInVirtualTempDir) {
        Intrinsics.checkParameterIsNotNull((Object)$this$generateInVirtualTempDir, (String)"$this$generateInVirtualTempDir");
        File ioFile = $this$generateInVirtualTempDir.generateInTempDir();
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026indFileByIoFile(ioFile)!!");
        VirtualFile virtualFile2 = virtualFile;
        UsefulTestCase.refreshRecursively(virtualFile2);
        return virtualFile2;
    }
}

