/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.TreeActionsToolbarPanel;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.Nullable;

public class MoveChangesDialog
extends DialogWrapper {
    private static final String MOVE_CHANGES_CURRENT_ONLY = "move.changes.current.only";
    private final ChangesTree myTreeList;
    private final Collection<? extends Change> mySelected;
    private final JBCheckBox myCheckBox;

    public MoveChangesDialog(final Project project, Collection<? extends Change> selected, final Set<ChangeList> changeLists, VirtualFile current) {
        super(project, true);
        this.mySelected = selected;
        this.setTitle(VcsBundle.message((String)"dialog.title.move.changes.to.active.changelist", (Object[])new Object[0]));
        this.myTreeList = new ChangesTree(project, true, false){

            @Override
            public void rebuildTree() {
                DefaultTreeModel model = TreeModelBuilder.buildFromChangeLists(project, this.getGrouping(), changeLists);
                this.updateTreeModel(model);
            }
        };
        this.myTreeList.rebuildTree();
        this.myTreeList.selectFile(current);
        this.myCheckBox = new JBCheckBox(VcsBundle.message((String)"checkbox.select.current.file.only", (Object[])new Object[0]));
        this.myCheckBox.setMnemonic('c');
        this.myCheckBox.addActionListener(e -> this.setSelected(this.myCheckBox.isSelected()));
        boolean selectCurrent = PropertiesComponent.getInstance().getBoolean(MOVE_CHANGES_CURRENT_ONLY);
        this.myCheckBox.setSelected(selectCurrent);
        this.setSelected(selectCurrent);
        this.init();
    }

    private void setSelected(boolean selected) {
        this.myTreeList.excludeChanges(this.myTreeList.getIncludedSet());
        if (selected) {
            List<Change> selectedChanges = VcsTreeModelData.selected((JTree)((Object)this.myTreeList)).userObjects(Change.class);
            this.myTreeList.includeChanges(selectedChanges);
        } else {
            this.myTreeList.includeChanges(this.mySelected);
        }
        PropertiesComponent.getInstance().setValue(MOVE_CHANGES_CURRENT_ONLY, selected);
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myTreeList)), "Center");
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction("ChangesView.GroupBy"));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("MoveChangesDialog", (ActionGroup)group, true);
        TreeActionsToolbarPanel toolbarPanel = new TreeActionsToolbarPanel(toolbar, this.myTreeList);
        panel2.add((Component)toolbarPanel, "North");
        this.myTreeList.expandAll();
        this.myTreeList.repaint();
        return panel2;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTreeList;
    }

    public Collection<Change> getIncludedChanges() {
        return VcsTreeModelData.included(this.myTreeList).userObjects(Change.class);
    }

    public boolean isOKActionEnabled() {
        return !this.getIncludedChanges().isEmpty();
    }

    @Nullable
    protected JComponent createDoNotAskCheckbox() {
        return this.myCheckBox;
    }
}

