/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StartupActionScriptManager {
    public static final String STARTUP_WIZARD_MODE = "StartupWizardMode";
    public static final String ACTION_SCRIPT_FILE = "action.script";

    private StartupActionScriptManager() {
    }

    public static synchronized void executeActionScript() throws IOException {
        try {
            List<ActionCommand> commands = StartupActionScriptManager.loadActionScript(StartupActionScriptManager.getActionScriptFile());
            for (ActionCommand command : commands) {
                command.execute();
            }
        }
        finally {
            StartupActionScriptManager.saveActionScript(null);
        }
    }

    public static synchronized void executeActionScript(@NotNull File scriptFile, @NotNull File oldTarget, @NotNull File newTarget) throws IOException {
        if (scriptFile == null) {
            StartupActionScriptManager.$$$reportNull$$$0(0);
        }
        if (oldTarget == null) {
            StartupActionScriptManager.$$$reportNull$$$0(1);
        }
        if (newTarget == null) {
            StartupActionScriptManager.$$$reportNull$$$0(2);
        }
        List<ActionCommand> commands = StartupActionScriptManager.loadActionScript(scriptFile.toPath());
        StartupActionScriptManager.executeActionScriptCommands(commands, oldTarget, newTarget);
    }

    public static void executeActionScriptCommands(List<ActionCommand> commands, @NotNull File oldTarget, @NotNull File newTarget) throws IOException {
        if (oldTarget == null) {
            StartupActionScriptManager.$$$reportNull$$$0(3);
        }
        if (newTarget == null) {
            StartupActionScriptManager.$$$reportNull$$$0(4);
        }
        for (ActionCommand command : commands) {
            ActionCommand toExecute = StartupActionScriptManager.mapPaths(command, oldTarget, newTarget);
            if (toExecute == null) continue;
            toExecute.execute();
        }
    }

    public static synchronized void addActionCommand(ActionCommand command) throws IOException {
        StartupActionScriptManager.addActionCommands(Collections.singletonList(command));
    }

    public static synchronized void addActionCommands(List<? extends ActionCommand> commands) throws IOException {
        if (Boolean.getBoolean(STARTUP_WIZARD_MODE)) {
            for (ActionCommand actionCommand : commands) {
                actionCommand.execute();
            }
        } else {
            List<ActionCommand> script;
            try {
                script = StartupActionScriptManager.loadActionScript(StartupActionScriptManager.getActionScriptFile());
                script.addAll(commands);
            }
            catch (ObjectStreamException objectStreamException) {
                Logger.getInstance(StartupActionScriptManager.class).warn((Throwable)objectStreamException);
                script = new ArrayList<ActionCommand>(commands);
            }
            StartupActionScriptManager.saveActionScript(script);
        }
    }

    @NotNull
    private static Path getActionScriptFile() {
        Path path = Paths.get(PathManager.getPluginTempPath(), ACTION_SCRIPT_FILE);
        if (path == null) {
            StartupActionScriptManager.$$$reportNull$$$0(5);
        }
        return path;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<ActionCommand> loadActionScript(@NotNull Path scriptFile) throws IOException {
        if (scriptFile == null) {
            StartupActionScriptManager.$$$reportNull$$$0(6);
        }
        if (!Files.isRegularFile(scriptFile, new LinkOption[0])) {
            return new ArrayList<ActionCommand>();
        }
        try {
            ois = new ObjectInputStream(Files.newInputStream(scriptFile, new OpenOption[0]));
            try {
                data = ois.readObject();
                if (data instanceof ActionCommand[]) {
                    var3_5 = new ArrayList<ActionCommand>(Arrays.asList((ActionCommand[])data));
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var2_4) {
                try {
                    ois.close();
                    throw var2_4;
                }
                catch (Throwable var3_7) {
                    var2_4.addSuppressed(var3_7);
                }
                throw var2_4;
            }
            ois.close();
            v0 = var3_5;
        }
        catch (ReflectiveOperationException e) {
            throw (StreamCorruptedException)new StreamCorruptedException("Stream error: " + scriptFile).initCause(e);
        }
        if (v0 != null) return v0;
        StartupActionScriptManager.$$$reportNull$$$0(7);
        return v0;
lbl-1000:
        // 1 sources

        {
            if (!(data instanceof List) || ((List)data).size() != 0) ** GOTO lbl-1000
            var3_6 = new ArrayList<ActionCommand>();
        }
        ois.close();
        v1 = var3_6;
        if (v1 != null) return v1;
        StartupActionScriptManager.$$$reportNull$$$0(8);
        return v1;
lbl-1000:
        // 1 sources

        {
            throw new IOException("An unexpected object: " + data + "/" + data.getClass());
        }
    }

    private static void saveActionScript(@Nullable List<ActionCommand> commands) throws IOException {
        Path scriptFile = StartupActionScriptManager.getActionScriptFile();
        StartupActionScriptManager.saveActionScript(commands, scriptFile);
    }

    public static void saveActionScript(@Nullable List<ActionCommand> commands, Path scriptFile) throws IOException {
        if (commands != null) {
            Files.createDirectories(scriptFile.getParent(), new FileAttribute[0]);
            try (ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(scriptFile, new OpenOption[0]));){
                oos.writeObject(commands.toArray(ActionCommand.EMPTY_ARRAY));
            }
        } else if (Files.exists(scriptFile, new LinkOption[0])) {
            FileUtilRt.delete((File)scriptFile.toFile());
        }
    }

    private static ActionCommand mapPaths(ActionCommand command, File oldTarget, File newTarget) {
        File source;
        if (command instanceof CopyCommand) {
            File destination = StartupActionScriptManager.mapPath(((CopyCommand)command).myDestination, oldTarget, newTarget);
            if (destination != null) {
                return new CopyCommand(new File(((CopyCommand)command).mySource), destination);
            }
        } else if (command instanceof UnzipCommand) {
            File destination = StartupActionScriptManager.mapPath(((UnzipCommand)command).myDestination, oldTarget, newTarget);
            if (destination != null) {
                return new UnzipCommand(new File(((UnzipCommand)command).mySource), destination, ((UnzipCommand)command).myFilenameFilter);
            }
        } else if (command instanceof DeleteCommand && (source = StartupActionScriptManager.mapPath(((DeleteCommand)command).mySource, oldTarget, newTarget)) != null) {
            return new DeleteCommand(source);
        }
        return null;
    }

    private static File mapPath(String path, File oldTarget, File newTarget) {
        String oldTargetPath = oldTarget.getPath();
        if (path.startsWith(oldTargetPath)) {
            if (path.length() == oldTargetPath.length()) {
                return newTarget;
            }
            if (path.charAt(oldTargetPath.length()) == File.separatorChar) {
                return new File(newTarget, path.substring(oldTargetPath.length() + 1));
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFile";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldTarget";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTarget";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/startup/StartupActionScriptManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/startup/StartupActionScriptManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionScriptFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadActionScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeActionScript";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeActionScriptCommands";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadActionScript";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DeleteCommand
    implements Serializable,
    ActionCommand {
        private static final long serialVersionUID = 201708031943L;
        private final String mySource;

        public DeleteCommand(@NotNull File source) {
            if (source == null) {
                DeleteCommand.$$$reportNull$$$0(0);
            }
            this.mySource = source.getAbsolutePath();
        }

        @Override
        public void execute() throws IOException {
            File source = new File(this.mySource);
            if (source.exists() && !FileUtilRt.delete((File)source)) {
                throw new IOException("Cannot delete: " + source);
            }
        }

        public String toString() {
            return "delete[" + this.mySource + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ide/startup/StartupActionScriptManager$DeleteCommand", "<init>"));
        }
    }

    public static class UnzipCommand
    implements Serializable,
    ActionCommand {
        private static final long serialVersionUID = 201708031943L;
        private final String mySource;
        private final String myDestination;
        private final FilenameFilter myFilenameFilter;

        public UnzipCommand(@NotNull File source, @NotNull File destination) {
            if (source == null) {
                UnzipCommand.$$$reportNull$$$0(0);
            }
            if (destination == null) {
                UnzipCommand.$$$reportNull$$$0(1);
            }
            this(source, destination, null);
        }

        public UnzipCommand(@NotNull File source, @NotNull File destination, FilenameFilter filenameFilter) {
            if (source == null) {
                UnzipCommand.$$$reportNull$$$0(2);
            }
            if (destination == null) {
                UnzipCommand.$$$reportNull$$$0(3);
            }
            this.mySource = source.getAbsolutePath();
            this.myDestination = destination.getAbsolutePath();
            this.myFilenameFilter = filenameFilter;
        }

        @Override
        public void execute() throws IOException {
            File source = new File(this.mySource);
            File destination = new File(this.myDestination);
            if (!source.isFile()) {
                throw new IOException("Source file missing: " + source);
            }
            if (!destination.isDirectory() && !destination.mkdirs()) {
                throw new IOException("Cannot create a directory: " + destination);
            }
            ZipUtil.extract((File)source, (File)destination, (FilenameFilter)this.myFilenameFilter);
        }

        public String toString() {
            return "unzip[" + this.mySource + "," + this.myDestination + "]";
        }

        public String getSource() {
            return this.mySource;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "destination";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/startup/StartupActionScriptManager$UnzipCommand";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CopyCommand
    implements Serializable,
    ActionCommand {
        private static final long serialVersionUID = 201708031943L;
        private final String mySource;
        private final String myDestination;

        public CopyCommand(@NotNull File source, @NotNull File destination) {
            if (source == null) {
                CopyCommand.$$$reportNull$$$0(0);
            }
            if (destination == null) {
                CopyCommand.$$$reportNull$$$0(1);
            }
            this.mySource = source.getAbsolutePath();
            this.myDestination = destination.getAbsolutePath();
        }

        @Override
        public void execute() throws IOException {
            File source = new File(this.mySource);
            File destination = new File(this.myDestination);
            if (!source.isFile()) {
                throw new IOException("Source file missing: " + source);
            }
            File destDir = destination.getParentFile();
            if (!destDir.isDirectory() && !destDir.mkdirs()) {
                throw new IOException("Cannot create a directory: " + destDir);
            }
            FileUtilRt.copy((File)source, (File)destination);
        }

        public String toString() {
            return "copy[" + this.mySource + "," + this.myDestination + "]";
        }

        public String getSource() {
            return this.mySource;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "destination";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/startup/StartupActionScriptManager$CopyCommand";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ActionCommand {
        public static final ActionCommand[] EMPTY_ARRAY = new ActionCommand[0];

        public void execute() throws IOException;
    }
}

