/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.components.MultiColumnListModel;
import javax.swing.ListModel;

public class FixedColumnsModel
extends MultiColumnListModel {
    private final int myMaxColumns;

    public FixedColumnsModel(ListModel model, int maxColumns) {
        super(model);
        this.myMaxColumns = maxColumns;
    }

    @Override
    public int getRowCount() {
        int columns = this.getColumnCount();
        return columns == 0 ? 0 : this.getSize() / columns + 1;
    }

    @Override
    public int getColumnCount() {
        return Math.min(this.myMaxColumns, this.getSize());
    }

    @Override
    public int toListIndex(int row, int column) {
        int columns = this.getColumnCount();
        return columns == 0 ? -1 : row * columns + column;
    }

    @Override
    public int getColumn(int listIndex) {
        return listIndex % this.myMaxColumns;
    }

    @Override
    public int getRow(int listIndex) {
        return listIndex / this.myMaxColumns;
    }
}

