"""Generated client library for datacatalog version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.datacatalog.v1 import datacatalog_v1_messages as messages


class DatacatalogV1(base_api.BaseApiClient):
  """Generated client library for service datacatalog version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://datacatalog.googleapis.com/'
  MTLS_BASE_URL = 'https://datacatalog.mtls.googleapis.com/'

  _PACKAGE = 'datacatalog'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'DatacatalogV1'
  _URL_VERSION = 'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new datacatalog handle."""
    url = url or self.BASE_URL
    super(DatacatalogV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.catalog = self.CatalogService(self)
    self.entries = self.EntriesService(self)
    self.projects_locations_entryGroups_entries_tags = self.ProjectsLocationsEntryGroupsEntriesTagsService(self)
    self.projects_locations_entryGroups_entries = self.ProjectsLocationsEntryGroupsEntriesService(self)
    self.projects_locations_entryGroups_tags = self.ProjectsLocationsEntryGroupsTagsService(self)
    self.projects_locations_entryGroups = self.ProjectsLocationsEntryGroupsService(self)
    self.projects_locations_tagTemplates_fields_enumValues = self.ProjectsLocationsTagTemplatesFieldsEnumValuesService(self)
    self.projects_locations_tagTemplates_fields = self.ProjectsLocationsTagTemplatesFieldsService(self)
    self.projects_locations_tagTemplates = self.ProjectsLocationsTagTemplatesService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class CatalogService(base_api.BaseApiService):
    """Service class for the catalog resource."""

    _NAME = 'catalog'

    def __init__(self, client):
      super(DatacatalogV1.CatalogService, self).__init__(client)
      self._upload_configs = {
          }

    def Search(self, request, global_params=None):
      r"""Searches Data Catalog for multiple resources like entries, tags that match a query. This is a custom method (https://cloud.google.com/apis/design/custom_methods) and does not return the complete resource, only the resource identifier and high level fields. Clients can subsequentally call `Get` methods. Note that Data Catalog search queries do not guarantee full recall. Query results that match your query may not be returned, even in subsequent result pages. Also note that results returned (and not returned) can vary across repeated search queries. See [Data Catalog Search Syntax](https://cloud.google.com/data-catalog/docs/how-to/search-reference) for more information.

      Args:
        request: (GoogleCloudDatacatalogV1SearchCatalogRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1SearchCatalogResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='datacatalog.catalog.search',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path='v1/catalog:search',
        request_field='<request>',
        request_type_name='GoogleCloudDatacatalogV1SearchCatalogRequest',
        response_type_name='GoogleCloudDatacatalogV1SearchCatalogResponse',
        supports_download=False,
    )

  class EntriesService(base_api.BaseApiService):
    """Service class for the entries resource."""

    _NAME = 'entries'

    def __init__(self, client):
      super(DatacatalogV1.EntriesService, self).__init__(client)
      self._upload_configs = {
          }

    def Lookup(self, request, global_params=None):
      r"""Get an entry by target resource name. This method allows clients to use the resource name from the source Google Cloud Platform service to get the Data Catalog Entry.

      Args:
        request: (DatacatalogEntriesLookupRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1Entry) The response message.
      """
      config = self.GetMethodConfig('Lookup')
      return self._RunMethod(
          config, request, global_params=global_params)

    Lookup.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='datacatalog.entries.lookup',
        ordered_params=[],
        path_params=[],
        query_params=['linkedResource', 'sqlResource'],
        relative_path='v1/entries:lookup',
        request_field='',
        request_type_name='DatacatalogEntriesLookupRequest',
        response_type_name='GoogleCloudDatacatalogV1Entry',
        supports_download=False,
    )

  class ProjectsLocationsEntryGroupsEntriesTagsService(base_api.BaseApiService):
    """Service class for the projects_locations_entryGroups_entries_tags resource."""

    _NAME = 'projects_locations_entryGroups_entries_tags'

    def __init__(self, client):
      super(DatacatalogV1.ProjectsLocationsEntryGroupsEntriesTagsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a tag on an Entry. Note: The project identified by the `parent` parameter for the [tag](https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries.tags/create#path-parameters) and the [tag template](https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.tagTemplates/create#path-parameters) used to create the tag must be from the same organization.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesTagsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1Tag) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}/tags',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.entries.tags.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/tags',
        request_field='googleCloudDatacatalogV1Tag',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesTagsCreateRequest',
        response_type_name='GoogleCloudDatacatalogV1Tag',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a tag.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesTagsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}/tags/{tagsId}',
        http_method='DELETE',
        method_id='datacatalog.projects.locations.entryGroups.entries.tags.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesTagsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the tags on an Entry.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesTagsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1ListTagsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}/tags',
        http_method='GET',
        method_id='datacatalog.projects.locations.entryGroups.entries.tags.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/tags',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesTagsListRequest',
        response_type_name='GoogleCloudDatacatalogV1ListTagsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing tag.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesTagsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1Tag) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}/tags/{tagsId}',
        http_method='PATCH',
        method_id='datacatalog.projects.locations.entryGroups.entries.tags.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='googleCloudDatacatalogV1Tag',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesTagsPatchRequest',
        response_type_name='GoogleCloudDatacatalogV1Tag',
        supports_download=False,
    )

  class ProjectsLocationsEntryGroupsEntriesService(base_api.BaseApiService):
    """Service class for the projects_locations_entryGroups_entries resource."""

    _NAME = 'projects_locations_entryGroups_entries'

    def __init__(self, client):
      super(DatacatalogV1.ProjectsLocationsEntryGroupsEntriesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an entry. Only entries of 'FILESET' type or user-specified type can be created. Users should enable the Data Catalog API in the project identified by the `parent` parameter (see [Data Catalog Resource Project] (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for more information). A maximum of 100,000 entries may be created per entry group.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1Entry) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.entries.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['entryId'],
        relative_path='v1/{+parent}/entries',
        request_field='googleCloudDatacatalogV1Entry',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesCreateRequest',
        response_type_name='GoogleCloudDatacatalogV1Entry',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an existing entry. Only entries created through CreateEntry method can be deleted. Users should enable the Data Catalog API in the project identified by the `name` parameter (see [Data Catalog Resource Project] (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for more information).

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}',
        http_method='DELETE',
        method_id='datacatalog.projects.locations.entryGroups.entries.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an entry.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1Entry) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}',
        http_method='GET',
        method_id='datacatalog.projects.locations.entryGroups.entries.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesGetRequest',
        response_type_name='GoogleCloudDatacatalogV1Entry',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. A `NOT_FOUND` error is returned if the resource does not exist. An empty policy is returned if the resource exists but does not have a policy set on it. Supported resources are: - Tag templates. - Entries. - Entry groups. Note, this method cannot be used to manage policies for BigQuery, Pub/Sub and any external Google Cloud Platform resources synced to Data Catalog. Callers must have following Google IAM permission - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag templates. - `datacatalog.entries.getIamPolicy` to get policies on entries. - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}:getIamPolicy',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.entries.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:getIamPolicy',
        request_field='getIamPolicyRequest',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists entries.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1ListEntriesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries',
        http_method='GET',
        method_id='datacatalog.projects.locations.entryGroups.entries.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken', 'readMask'],
        relative_path='v1/{+parent}/entries',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesListRequest',
        response_type_name='GoogleCloudDatacatalogV1ListEntriesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing entry. Users should enable the Data Catalog API in the project identified by the `entry.name` parameter (see [Data Catalog Resource Project] (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for more information).

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1Entry) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}',
        http_method='PATCH',
        method_id='datacatalog.projects.locations.entryGroups.entries.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='googleCloudDatacatalogV1Entry',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesPatchRequest',
        response_type_name='GoogleCloudDatacatalogV1Entry',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns the caller's permissions on a resource. If the resource does not exist, an empty set of permissions is returned (We don't return a `NOT_FOUND` error). Supported resources are: - Tag templates. - Entries. - Entry groups. Note, this method cannot be used to manage policies for BigQuery, Pub/Sub and any external Google Cloud Platform resources synced to Data Catalog. A caller is not required to have Google IAM permission to make this request.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsEntriesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}:testIamPermissions',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.entries.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsEntriesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsEntryGroupsTagsService(base_api.BaseApiService):
    """Service class for the projects_locations_entryGroups_tags resource."""

    _NAME = 'projects_locations_entryGroups_tags'

    def __init__(self, client):
      super(DatacatalogV1.ProjectsLocationsEntryGroupsTagsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a tag on an Entry. Note: The project identified by the `parent` parameter for the [tag](https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries.tags/create#path-parameters) and the [tag template](https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.tagTemplates/create#path-parameters) used to create the tag must be from the same organization.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsTagsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1Tag) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/tags',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.tags.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/tags',
        request_field='googleCloudDatacatalogV1Tag',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsTagsCreateRequest',
        response_type_name='GoogleCloudDatacatalogV1Tag',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a tag.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsTagsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/tags/{tagsId}',
        http_method='DELETE',
        method_id='datacatalog.projects.locations.entryGroups.tags.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsTagsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the tags on an Entry.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsTagsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1ListTagsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/tags',
        http_method='GET',
        method_id='datacatalog.projects.locations.entryGroups.tags.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/tags',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsTagsListRequest',
        response_type_name='GoogleCloudDatacatalogV1ListTagsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing tag.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsTagsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1Tag) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/tags/{tagsId}',
        http_method='PATCH',
        method_id='datacatalog.projects.locations.entryGroups.tags.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='googleCloudDatacatalogV1Tag',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsTagsPatchRequest',
        response_type_name='GoogleCloudDatacatalogV1Tag',
        supports_download=False,
    )

  class ProjectsLocationsEntryGroupsService(base_api.BaseApiService):
    """Service class for the projects_locations_entryGroups resource."""

    _NAME = 'projects_locations_entryGroups'

    def __init__(self, client):
      super(DatacatalogV1.ProjectsLocationsEntryGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an EntryGroup. An entry group contains logically related entries together with Cloud Identity and Access Management policies that specify the users who can create, edit, and view entries within the entry group. Data Catalog automatically creates an entry group for BigQuery entries ("@bigquery") and Pub/Sub topics ("@pubsub"). Users create their own entry group to contain Cloud Storage fileset entries or custom type entries, and the IAM policies associated with those entries. Entry groups, like entries, can be searched. A maximum of 10,000 entry groups may be created per organization across all locations. Users should enable the Data Catalog API in the project identified by the `parent` parameter (see [Data Catalog Resource Project] (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for more information).

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1EntryGroup) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['entryGroupId'],
        relative_path='v1/{+parent}/entryGroups',
        request_field='googleCloudDatacatalogV1EntryGroup',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsCreateRequest',
        response_type_name='GoogleCloudDatacatalogV1EntryGroup',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an EntryGroup. Only entry groups that do not contain entries can be deleted. Users should enable the Data Catalog API in the project identified by the `name` parameter (see [Data Catalog Resource Project] (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for more information).

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}',
        http_method='DELETE',
        method_id='datacatalog.projects.locations.entryGroups.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an EntryGroup.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1EntryGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}',
        http_method='GET',
        method_id='datacatalog.projects.locations.entryGroups.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['readMask'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsGetRequest',
        response_type_name='GoogleCloudDatacatalogV1EntryGroup',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. A `NOT_FOUND` error is returned if the resource does not exist. An empty policy is returned if the resource exists but does not have a policy set on it. Supported resources are: - Tag templates. - Entries. - Entry groups. Note, this method cannot be used to manage policies for BigQuery, Pub/Sub and any external Google Cloud Platform resources synced to Data Catalog. Callers must have following Google IAM permission - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag templates. - `datacatalog.entries.getIamPolicy` to get policies on entries. - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}:getIamPolicy',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:getIamPolicy',
        request_field='getIamPolicyRequest',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists entry groups.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1ListEntryGroupsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups',
        http_method='GET',
        method_id='datacatalog.projects.locations.entryGroups.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/entryGroups',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsListRequest',
        response_type_name='GoogleCloudDatacatalogV1ListEntryGroupsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an EntryGroup. The user should enable the Data Catalog API in the project identified by the `entry_group.name` parameter (see [Data Catalog Resource Project] (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for more information).

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1EntryGroup) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}',
        http_method='PATCH',
        method_id='datacatalog.projects.locations.entryGroups.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='googleCloudDatacatalogV1EntryGroup',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsPatchRequest',
        response_type_name='GoogleCloudDatacatalogV1EntryGroup',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy for a resource. Replaces any existing policy. Supported resources are: - Tag templates. - Entries. - Entry groups. Note, this method cannot be used to manage policies for BigQuery, Pub/Sub and any external Google Cloud Platform resources synced to Data Catalog. Callers must have following Google IAM permission - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag templates. - `datacatalog.entries.setIamPolicy` to set policies on entries. - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}:setIamPolicy',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns the caller's permissions on a resource. If the resource does not exist, an empty set of permissions is returned (We don't return a `NOT_FOUND` error). Supported resources are: - Tag templates. - Entries. - Entry groups. Note, this method cannot be used to manage policies for BigQuery, Pub/Sub and any external Google Cloud Platform resources synced to Data Catalog. A caller is not required to have Google IAM permission to make this request.

      Args:
        request: (DatacatalogProjectsLocationsEntryGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}:testIamPermissions',
        http_method='POST',
        method_id='datacatalog.projects.locations.entryGroups.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='DatacatalogProjectsLocationsEntryGroupsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsTagTemplatesFieldsEnumValuesService(base_api.BaseApiService):
    """Service class for the projects_locations_tagTemplates_fields_enumValues resource."""

    _NAME = 'projects_locations_tagTemplates_fields_enumValues'

    def __init__(self, client):
      super(DatacatalogV1.ProjectsLocationsTagTemplatesFieldsEnumValuesService, self).__init__(client)
      self._upload_configs = {
          }

    def Rename(self, request, global_params=None):
      r"""Renames an enum value in a tag template. The enum values have to be unique within one enum field.

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesFieldsEnumValuesRenameRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1TagTemplateField) The response message.
      """
      config = self.GetMethodConfig('Rename')
      return self._RunMethod(
          config, request, global_params=global_params)

    Rename.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}/fields/{fieldsId}/enumValues/{enumValuesId}:rename',
        http_method='POST',
        method_id='datacatalog.projects.locations.tagTemplates.fields.enumValues.rename',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:rename',
        request_field='googleCloudDatacatalogV1RenameTagTemplateFieldEnumValueRequest',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesFieldsEnumValuesRenameRequest',
        response_type_name='GoogleCloudDatacatalogV1TagTemplateField',
        supports_download=False,
    )

  class ProjectsLocationsTagTemplatesFieldsService(base_api.BaseApiService):
    """Service class for the projects_locations_tagTemplates_fields resource."""

    _NAME = 'projects_locations_tagTemplates_fields'

    def __init__(self, client):
      super(DatacatalogV1.ProjectsLocationsTagTemplatesFieldsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a field in a tag template. The user should enable the Data Catalog API in the project identified by the `parent` parameter (see [Data Catalog Resource Project](https://cloud.google.com/data-catalog/docs/concepts/resource-project) for more information).

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesFieldsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1TagTemplateField) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}/fields',
        http_method='POST',
        method_id='datacatalog.projects.locations.tagTemplates.fields.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['tagTemplateFieldId'],
        relative_path='v1/{+parent}/fields',
        request_field='googleCloudDatacatalogV1TagTemplateField',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesFieldsCreateRequest',
        response_type_name='GoogleCloudDatacatalogV1TagTemplateField',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a field in a tag template and all uses of that field. Users should enable the Data Catalog API in the project identified by the `name` parameter (see [Data Catalog Resource Project] (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for more information).

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesFieldsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}/fields/{fieldsId}',
        http_method='DELETE',
        method_id='datacatalog.projects.locations.tagTemplates.fields.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesFieldsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a field in a tag template. This method cannot be used to update the field type. Users should enable the Data Catalog API in the project identified by the `name` parameter (see [Data Catalog Resource Project] (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for more information).

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesFieldsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1TagTemplateField) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}/fields/{fieldsId}',
        http_method='PATCH',
        method_id='datacatalog.projects.locations.tagTemplates.fields.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='googleCloudDatacatalogV1TagTemplateField',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesFieldsPatchRequest',
        response_type_name='GoogleCloudDatacatalogV1TagTemplateField',
        supports_download=False,
    )

    def Rename(self, request, global_params=None):
      r"""Renames a field in a tag template. The user should enable the Data Catalog API in the project identified by the `name` parameter (see [Data Catalog Resource Project](https://cloud.google.com/data-catalog/docs/concepts/resource-project) for more information).

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesFieldsRenameRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1TagTemplateField) The response message.
      """
      config = self.GetMethodConfig('Rename')
      return self._RunMethod(
          config, request, global_params=global_params)

    Rename.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}/fields/{fieldsId}:rename',
        http_method='POST',
        method_id='datacatalog.projects.locations.tagTemplates.fields.rename',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:rename',
        request_field='googleCloudDatacatalogV1RenameTagTemplateFieldRequest',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesFieldsRenameRequest',
        response_type_name='GoogleCloudDatacatalogV1TagTemplateField',
        supports_download=False,
    )

  class ProjectsLocationsTagTemplatesService(base_api.BaseApiService):
    """Service class for the projects_locations_tagTemplates resource."""

    _NAME = 'projects_locations_tagTemplates'

    def __init__(self, client):
      super(DatacatalogV1.ProjectsLocationsTagTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a tag template. The user should enable the Data Catalog API in the project identified by the `parent` parameter (see [Data Catalog Resource Project](https://cloud.google.com/data-catalog/docs/concepts/resource-project) for more information).

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1TagTemplate) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates',
        http_method='POST',
        method_id='datacatalog.projects.locations.tagTemplates.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['tagTemplateId'],
        relative_path='v1/{+parent}/tagTemplates',
        request_field='googleCloudDatacatalogV1TagTemplate',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesCreateRequest',
        response_type_name='GoogleCloudDatacatalogV1TagTemplate',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a tag template and all tags using the template. Users should enable the Data Catalog API in the project identified by the `name` parameter (see [Data Catalog Resource Project] (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for more information).

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}',
        http_method='DELETE',
        method_id='datacatalog.projects.locations.tagTemplates.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a tag template.

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1TagTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}',
        http_method='GET',
        method_id='datacatalog.projects.locations.tagTemplates.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesGetRequest',
        response_type_name='GoogleCloudDatacatalogV1TagTemplate',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. A `NOT_FOUND` error is returned if the resource does not exist. An empty policy is returned if the resource exists but does not have a policy set on it. Supported resources are: - Tag templates. - Entries. - Entry groups. Note, this method cannot be used to manage policies for BigQuery, Pub/Sub and any external Google Cloud Platform resources synced to Data Catalog. Callers must have following Google IAM permission - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag templates. - `datacatalog.entries.getIamPolicy` to get policies on entries. - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}:getIamPolicy',
        http_method='POST',
        method_id='datacatalog.projects.locations.tagTemplates.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:getIamPolicy',
        request_field='getIamPolicyRequest',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a tag template. This method cannot be used to update the fields of a template. The tag template fields are represented as separate resources and should be updated using their own create/update/delete methods. Users should enable the Data Catalog API in the project identified by the `tag_template.name` parameter (see [Data Catalog Resource Project] (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for more information).

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDatacatalogV1TagTemplate) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}',
        http_method='PATCH',
        method_id='datacatalog.projects.locations.tagTemplates.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='googleCloudDatacatalogV1TagTemplate',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesPatchRequest',
        response_type_name='GoogleCloudDatacatalogV1TagTemplate',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy for a resource. Replaces any existing policy. Supported resources are: - Tag templates. - Entries. - Entry groups. Note, this method cannot be used to manage policies for BigQuery, Pub/Sub and any external Google Cloud Platform resources synced to Data Catalog. Callers must have following Google IAM permission - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag templates. - `datacatalog.entries.setIamPolicy` to set policies on entries. - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}:setIamPolicy',
        http_method='POST',
        method_id='datacatalog.projects.locations.tagTemplates.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns the caller's permissions on a resource. If the resource does not exist, an empty set of permissions is returned (We don't return a `NOT_FOUND` error). Supported resources are: - Tag templates. - Entries. - Entry groups. Note, this method cannot be used to manage policies for BigQuery, Pub/Sub and any external Google Cloud Platform resources synced to Data Catalog. A caller is not required to have Google IAM permission to make this request.

      Args:
        request: (DatacatalogProjectsLocationsTagTemplatesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/tagTemplates/{tagTemplatesId}:testIamPermissions',
        http_method='POST',
        method_id='datacatalog.projects.locations.tagTemplates.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='DatacatalogProjectsLocationsTagTemplatesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(DatacatalogV1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(DatacatalogV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
