function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { BehaviorSubject, throwError, timer, Subscription, defer, from } from 'rxjs';
import { finalize, filter } from 'rxjs/operators';
import { getCombinedSignal, AbortError } from '../../common/utils';
import { getLongQueryNotification } from './long_query_notification';
var LONG_QUERY_NOTIFICATION_DELAY = 10000;
export var SearchInterceptor = /*#__PURE__*/function () {
  /**
   * `abortController` used to signal all searches to abort.
   */

  /**
   * The number of pending search requests.
   */

  /**
   * Observable that emits when the number of pending requests changes.
   */

  /**
   * The subscriptions from scheduling the automatic timeout for each request.
   */

  /**
   * The current long-running toast (if there is one).
   */

  /**
   * This class should be instantiated with a `requestTimeout` corresponding with how many ms after
   * requests are initiated that they should automatically cancel.
   * @param toasts The `core.notifications.toasts` service
   * @param application  The `core.application` service
   * @param requestTimeout Usually config value `elasticsearch.requestTimeout`
   */
  function SearchInterceptor(deps, requestTimeout) {
    var _this = this;

    _classCallCheck(this, SearchInterceptor);

    this.deps = deps;
    this.requestTimeout = requestTimeout;

    _defineProperty(this, "abortController", new AbortController());

    _defineProperty(this, "pendingCount", 0);

    _defineProperty(this, "pendingCount$", new BehaviorSubject(this.pendingCount));

    _defineProperty(this, "timeoutSubscriptions", new Subscription());

    _defineProperty(this, "longRunningToast", void 0);

    _defineProperty(this, "getPendingCount$", function () {
      return _this.pendingCount$.asObservable();
    });

    _defineProperty(this, "showToast", function () {
      if (_this.longRunningToast) return;
      _this.longRunningToast = _this.deps.toasts.addInfo({
        title: 'Your query is taking a while',
        text: getLongQueryNotification({
          application: _this.deps.application
        })
      }, {
        toastLifeTimeMs: 1000000
      });
    });

    _defineProperty(this, "hideToast", function () {
      if (_this.longRunningToast) {
        _this.deps.toasts.remove(_this.longRunningToast);

        delete _this.longRunningToast;

        if (_this.deps.usageCollector) {
          _this.deps.usageCollector.trackLongQueryDialogDismissed();
        }
      }
    });

    this.deps.http.addLoadingCountSource(this.pendingCount$); // When search requests go out, a notification is scheduled allowing users to continue the
    // request past the timeout. When all search requests complete, we remove the notification.

    this.getPendingCount$().pipe(filter(function (count) {
      return count === 0;
    })).subscribe(this.hideToast);
  }
  /**
   * Returns an `Observable` over the current number of pending searches. This could mean that one
   * of the search requests is still in flight, or that it has only received partial responses.
   */


  _createClass(SearchInterceptor, [{
    key: "runSearch",
    value: function runSearch(request, combinedSignal) {
      return from(this.deps.http.fetch({
        path: "/internal/search/es",
        method: 'POST',
        body: JSON.stringify(request),
        signal: combinedSignal
      }));
    }
    /**
     * Searches using the given `search` method. Overrides the `AbortSignal` with one that will abort
     * either when `cancelPending` is called, when the request times out, or when the original
     * `AbortSignal` is aborted. Updates the `pendingCount` when the request is started/finalized.
     */

  }, {
    key: "search",
    value: function search(request, options) {
      var _this2 = this;

      // Defer the following logic until `subscribe` is actually called
      return defer(function () {
        var _options$signal;

        if (options === null || options === void 0 ? void 0 : (_options$signal = options.signal) === null || _options$signal === void 0 ? void 0 : _options$signal.aborted) {
          return throwError(new AbortError());
        }

        var _this2$setupTimers = _this2.setupTimers(options),
            combinedSignal = _this2$setupTimers.combinedSignal,
            cleanup = _this2$setupTimers.cleanup;

        _this2.pendingCount$.next(++_this2.pendingCount);

        return _this2.runSearch(request, combinedSignal).pipe(finalize(function () {
          _this2.pendingCount$.next(--_this2.pendingCount);

          cleanup();
        }));
      });
    }
  }, {
    key: "setupTimers",
    value: function setupTimers(options) {
      var _this3 = this;

      // Schedule this request to automatically timeout after some interval
      var timeoutController = new AbortController();
      var timeoutSignal = timeoutController.signal;
      var timeout$ = timer(this.requestTimeout);
      var subscription = timeout$.subscribe(function () {
        timeoutController.abort();
      });
      this.timeoutSubscriptions.add(subscription); // Schedule the notification to allow users to cancel or wait beyond the timeout

      var notificationSubscription = timer(LONG_QUERY_NOTIFICATION_DELAY).subscribe(this.showToast); // Get a combined `AbortSignal` that will be aborted whenever the first of the following occurs:
      // 1. The user manually aborts (via `cancelPending`)
      // 2. The request times out
      // 3. The passed-in signal aborts (e.g. when re-fetching, or whenever the app determines)

      var signals = [this.abortController.signal, timeoutSignal].concat(_toConsumableArray((options === null || options === void 0 ? void 0 : options.signal) ? [options.signal] : []));
      var combinedSignal = getCombinedSignal(signals);

      var cleanup = function cleanup() {
        _this3.timeoutSubscriptions.remove(subscription);

        notificationSubscription.unsubscribe();
      };

      combinedSignal.addEventListener('abort', cleanup);
      return {
        combinedSignal: combinedSignal,
        cleanup: cleanup
      };
    }
  }]);

  return SearchInterceptor;
}();