/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useEffect, useCallback, createContext, useContext } from 'react';
import { useMultiContent } from './use_multi_content';
var multiContentContext = createContext({});
export function MultiContentProvider(_ref) {
  var defaultValue = _ref.defaultValue,
      onChange = _ref.onChange,
      children = _ref.children;
  var multiContent = useMultiContent({
    defaultValue: defaultValue,
    onChange: onChange
  });
  return /*#__PURE__*/React.createElement(multiContentContext.Provider, {
    value: multiContent
  }, children);
}
export var MultiContentConsumer = multiContentContext.Consumer;
export function useMultiContentContext() {
  var ctx = useContext(multiContentContext);

  if (Object.keys(ctx).length === 0) {
    throw new Error('useMultiContentContext must be used within a <MultiContentProvider />');
  }

  return ctx;
}
/**
 * Hook to declare a new content and get its defaultValue and a handler to update its content
 *
 * @param contentId The content id to be added to the "contents" map
 */

export function useContent(contentId) {
  var _useMultiContentConte = useMultiContentContext(),
      updateContentAt = _useMultiContentConte.updateContentAt,
      saveSnapshotAndRemoveContent = _useMultiContentConte.saveSnapshotAndRemoveContent,
      getData = _useMultiContentConte.getData;

  var updateContent = useCallback(function (content) {
    updateContentAt(contentId, content);
  }, [contentId, updateContentAt]);
  useEffect(function () {
    return function () {
      // On unmount: save a snapshot of the data and remove content from our contents map
      saveSnapshotAndRemoveContent(contentId);
    };
  }, [contentId, saveSnapshotAndRemoveContent]);
  var data = getData();
  var defaultValue = data[contentId];
  return {
    defaultValue: defaultValue,
    updateContent: updateContent,
    getData: getData
  };
}