/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { i18n } from '@kbn/i18n';
import { EUI_MODAL_CONFIRM_BUTTON, EuiConfirmModal, EuiOverlayMask } from '@elastic/eui';
export var DeleteScritpedFieldConfirmationModal = function DeleteScritpedFieldConfirmationModal(_ref) {
  var field = _ref.field,
      hideDeleteConfirmationModal = _ref.hideDeleteConfirmationModal,
      deleteField = _ref.deleteField;
  var title = i18n.translate('indexPatternManagement.editIndexPattern.scripted.deleteFieldLabel', {
    defaultMessage: "Delete scripted field '{fieldName}'?",
    values: {
      fieldName: field.name
    }
  });
  var cancelButtonText = i18n.translate('indexPatternManagement.editIndexPattern.scripted.deleteField.cancelButton', {
    defaultMessage: 'Cancel'
  });
  var confirmButtonText = i18n.translate('indexPatternManagement.editIndexPattern.scripted.deleteField.deleteButton', {
    defaultMessage: 'Delete'
  });
  return /*#__PURE__*/React.createElement(EuiOverlayMask, null, /*#__PURE__*/React.createElement(EuiConfirmModal, {
    title: title,
    onCancel: hideDeleteConfirmationModal,
    onConfirm: deleteField,
    cancelButtonText: cancelButtonText,
    confirmButtonText: confirmButtonText,
    defaultFocusedButton: EUI_MODAL_CONFIRM_BUTTON
  }));
};