function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import { esQuery } from '../../../data/public';
import { getTimezone } from './get_timezone';
export function getTimelionRequestHandler(_ref) {
  var uiSettings = _ref.uiSettings,
      http = _ref.http,
      timefilter = _ref.timefilter;
  var timezone = getTimezone(uiSettings);
  return /*#__PURE__*/function () {
    var _ref3 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(_ref2) {
      var timeRange, filters, query, visParams, expression, esQueryConfigs, timeRangeBounds, err;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              timeRange = _ref2.timeRange, filters = _ref2.filters, query = _ref2.query, visParams = _ref2.visParams;
              expression = visParams.expression;

              if (expression) {
                _context.next = 4;
                break;
              }

              throw new Error(i18n.translate('timelion.emptyExpressionErrorMessage', {
                defaultMessage: 'Timelion error: No expression provided'
              }));

            case 4:
              esQueryConfigs = esQuery.getEsQueryConfig(uiSettings); // parse the time range client side to make sure it behaves like other charts

              timeRangeBounds = timefilter.calculateBounds(timeRange);
              _context.prev = 6;
              _context.next = 9;
              return http.post('/api/timelion/run', {
                body: JSON.stringify({
                  sheet: [expression],
                  extended: {
                    es: {
                      filter: esQuery.buildEsQuery(undefined, query, filters, esQueryConfigs)
                    }
                  },
                  time: {
                    from: timeRangeBounds.min,
                    to: timeRangeBounds.max,
                    interval: visParams.interval,
                    timezone: timezone
                  }
                })
              });

            case 9:
              return _context.abrupt("return", _context.sent);

            case 12:
              _context.prev = 12;
              _context.t0 = _context["catch"](6);

              if (!(_context.t0 && _context.t0.body)) {
                _context.next = 20;
                break;
              }

              err = new Error("".concat(i18n.translate('timelion.requestHandlerErrorTitle', {
                defaultMessage: 'Timelion request error'
              }), ": ").concat(_context.t0.body.title, " ").concat(_context.t0.body.message));
              err.stack = _context.t0.stack;
              throw err;

            case 20:
              throw _context.t0;

            case 21:
            case "end":
              return _context.stop();
          }
        }
      }, _callee, null, [[6, 12]]);
    }));

    return function (_x) {
      return _ref3.apply(this, arguments);
    };
  }();
}